/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.user.services;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.events.ConfigurationChangedEvent;
import org.apache.marmotta.platform.core.util.CDIUtils;
import org.apache.marmotta.platform.user.api.AccountService;
import org.apache.marmotta.platform.user.api.AuthenticationProvider;
import org.apache.marmotta.platform.user.api.AuthenticationService;
import org.apache.marmotta.platform.user.model.UserAccount;
import org.slf4j.Logger;

@ApplicationScoped
public class AuthenticationServiceImpl
implements AuthenticationService {
    public static final String DEFAULT_AUTH_PROVIDER_NAMED = "lmf";
    @Inject
    private Logger log;
    @Inject
    private AccountService accountService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    @Any
    private Instance<AuthenticationProvider> providers;
    private AuthenticationProvider authenticationProvider;

    @PostConstruct
    protected void initialize() {
        this.log.debug("initializing AuthenticationService");
        String prov = this.configurationService.getStringConfiguration("user.auth.provider", DEFAULT_AUTH_PROVIDER_NAMED);
        Instance selected = CDIUtils.selectNamed(this.providers, (String)prov);
        if (selected.isAmbiguous()) {
            this.authenticationProvider = (AuthenticationProvider)selected.iterator().next();
            this.log.error("multiple candidates for AuthenticationProvider '{}' found. Chose randomly!", (Object)prov);
        } else if (selected.isUnsatisfied()) {
            this.log.error("no candidate for AuthenticationProvider '{}' found, falling back to default", (Object)prov);
            this.authenticationProvider = (AuthenticationProvider)CDIUtils.selectNamed(this.providers, (String)DEFAULT_AUTH_PROVIDER_NAMED).iterator().next();
        } else {
            this.authenticationProvider = (AuthenticationProvider)selected.get();
        }
    }

    protected void onConfigurationChange(@Observes ConfigurationChangedEvent event) {
        if (event.containsChangedKey("user.auth.provider")) {
            this.initialize();
        }
    }

    @Override
    public Set<String> listAuthProviderNames() {
        HashSet<String> pNames = new HashSet<String>();
        for (AuthenticationProvider p : this.providers) {
            Named ann = p.getClass().getAnnotation(Named.class);
            if (ann == null) continue;
            pNames.add(ann.value());
        }
        return pNames;
    }

    @Override
    public boolean authenticateUser(String login, String password) {
        this.log.debug("AUTH {} with {}", (Object)login, this.authenticationProvider != null ? this.authenticationProvider.getClass().getSimpleName() : null);
        return this.authenticationProvider.checkPassword(this.accountService.getAccount(login), password);
    }

    @Override
    public void setUserPassword(String login, String password) {
        UserAccount a = this.accountService.getAccount(login);
        this.authenticationProvider.updatePassword(a, password);
    }

    @Override
    public Set<String> listUserRoles(String login) {
        return this.accountService.getRoles(this.accountService.getAccount(login));
    }

    @Override
    public void addUserRole(String login, String role) {
        UserAccount a = this.accountService.getAccount(login);
        this.accountService.addRole(a, role);
    }

    @Override
    public void removeUserRole(String login, String role) {
        UserAccount a = this.accountService.getAccount(login);
        this.accountService.removeRole(a, role);
    }
}

