/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.user.services;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.user.UserService;
import org.apache.marmotta.platform.core.events.ConfigurationChangedEvent;
import org.apache.marmotta.platform.core.events.SystemStartupEvent;
import org.apache.marmotta.platform.core.exception.UserExistsException;
import org.apache.marmotta.platform.core.model.user.MarmottaUser;
import org.apache.marmotta.platform.core.qualifiers.cache.MarmottaCache;
import org.apache.marmotta.platform.user.api.AccountService;
import org.apache.marmotta.platform.user.model.UserAccount;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.slf4j.Logger;

@ApplicationScoped
public class AccountServiceImpl
implements AccountService {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private UserService userService;
    @Inject
    @MarmottaCache(value="user-cache")
    private Ehcache userCache;
    private UserAccount.PasswordHash hashAlgo = UserAccount.PasswordHash.SHA1;

    @PostConstruct
    public void initialize() {
        String conf = this.configurationService.getStringConfiguration("security.password.hash", "SHA1").toUpperCase();
        try {
            this.hashAlgo = UserAccount.PasswordHash.valueOf(conf);
        }
        catch (Exception e) {
            this.hashAlgo = UserAccount.PasswordHash.SHA1;
            this.log.warn("Invalid/unknown password hash algorithm: {}, falling back to {}", (Object)conf, (Object)this.hashAlgo);
        }
    }

    public void systemStartup(@Observes SystemStartupEvent event) {
        this.log.info("creating default system accounts ...");
        this.createDefaultAccounts();
    }

    public void onConfigurationChange(@Observes ConfigurationChangedEvent event) {
        if (event.containsChangedKey("security.password.hash")) {
            this.initialize();
        }
    }

    @Override
    public void createDefaultAccounts() {
        UserAccount account = this.getAccount("admin");
        if (account == null) {
            HashSet<String> roles = new HashSet<String>(this.configurationService.getListConfiguration("user.admin.roles"));
            account = this.createAccount("admin");
            account.setRoles(roles);
            account.setPasswd(this.hashAlgo, this.configurationService.getStringConfiguration("user.admin.password"));
            this.save(account);
        }
    }

    @Override
    public List<UserAccount> listAccounts() {
        HashSet<String> logins = new HashSet<String>();
        for (String key : this.configurationService.listConfigurationKeys("user")) {
            String[] components = key.split("\\.");
            if (components.length <= 2 || !"webid".equals(components[2])) continue;
            logins.add(components[1]);
        }
        ArrayList<UserAccount> list = new ArrayList<UserAccount>();
        for (String login : logins) {
            list.add(this.getAccount(login));
        }
        for (UserAccount userAccount : list) {
            this.userCache.put(new Element((Serializable)((Object)userAccount.getLogin()), (Serializable)userAccount));
            this.userCache.put(new Element((Serializable)((Object)userAccount.getWebId()), (Serializable)userAccount));
        }
        return list;
    }

    @Override
    public List<UserAccount> listAccounts(String role) {
        ArrayList<UserAccount> result = new ArrayList<UserAccount>();
        for (UserAccount account : this.listAccounts()) {
            if (!account.getRoles().contains(role)) continue;
            result.add(account);
        }
        return result;
    }

    @Override
    public UserAccount createAccount(String login) {
        return this.createAccount(login, null, null);
    }

    @Override
    public UserAccount createAccount(String login, String firstName, String lastName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)login), (Object)"blank/empty login not allowed");
        URI webid = this.userService.getUser(login);
        if (webid == null) {
            try {
                webid = this.userService.createUser(login, firstName, lastName);
            }
            catch (UserExistsException e) {
                this.log.warn("User {} exists. This should not happen as it was checked 3 lines before!", (Object)login);
                webid = this.userService.getUser(login);
            }
        }
        if (webid instanceof KiWiUriResource) {
            UserAccount account = new UserAccount(login, webid.stringValue());
            this.save(account);
            return account;
        }
        this.log.error("could not create user account, the backend is not KiWi");
        return null;
    }

    private void save(UserAccount account) {
        this.configurationService.setConfiguration("user." + account.getLogin() + ".pwhash", account.getPasswdHash());
        this.configurationService.setConfiguration("user." + account.getLogin() + ".webid", account.getWebId());
        this.configurationService.setListConfiguration("user." + account.getLogin() + ".roles", new ArrayList<String>(account.getRoles()));
    }

    @Override
    public void deleteAccount(UserAccount account) {
        for (String key : this.configurationService.listConfigurationKeys("user." + account.getLogin())) {
            this.configurationService.removeConfiguration(key);
        }
        this.userCache.remove((Serializable)((Object)account.getLogin()));
        this.userCache.remove((Serializable)((Object)account.getWebId()));
    }

    @Override
    public UserAccount getAccount(String login) {
        if (StringUtils.isBlank((String)login)) {
            return null;
        }
        UserAccount account = null;
        if (this.userCache != null && this.userCache.get((Serializable)((Object)login)) != null) {
            account = (UserAccount)this.userCache.get((Serializable)((Object)login)).getObjectValue();
        } else if (this.configurationService.isConfigurationSet("user." + login + ".webid")) {
            account = new UserAccount();
            account.setLogin(login);
            account.setPasswdHash(this.configurationService.getStringConfiguration("user." + login + ".pwhash"));
            account.setRoles(new HashSet<String>(this.configurationService.getListConfiguration("user." + login + ".roles")));
            account.setWebId(this.configurationService.getStringConfiguration("user." + login + ".webid"));
            this.userCache.put(new Element((Serializable)((Object)account.getLogin()), (Serializable)account));
            this.userCache.put(new Element((Serializable)((Object)account.getWebId()), (Serializable)account));
        } else {
            this.log.info("UserAccount {} not found", (Object)login);
        }
        return account;
    }

    @Override
    public UserAccount getAccount(URI resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0);
        UserAccount account = null;
        if (this.userCache != null && this.userCache.get((Serializable)resource) != null) {
            account = (UserAccount)this.userCache.get((Serializable)resource).getObjectValue();
        } else {
            for (UserAccount a : this.listAccounts()) {
                if (!a.getWebId().equals(resource.stringValue())) continue;
                account = a;
                break;
            }
            if (account != null) {
                this.userCache.put(new Element((Serializable)((Object)account.getLogin()), (Serializable)account));
                this.userCache.put(new Element((Serializable)((Object)account.getWebId()), (Serializable)account));
            } else {
                this.log.warn("UserAccount {} not found", (Object)resource);
            }
        }
        return account;
    }

    @Override
    public UserAccount getAccount(MarmottaUser user) {
        Resource delegate = user.getDelegate();
        if (delegate instanceof URI) {
            return this.getAccount((URI)delegate);
        }
        return null;
    }

    @Override
    public UserAccount setPassword(UserAccount account, String passwd) {
        account.setPasswd(this.hashAlgo, passwd);
        this.save(account);
        return account;
    }

    @Override
    public boolean checkPassword(UserAccount account, String passwd) {
        return account != null && account.checkPasswd(passwd);
    }

    @Override
    public boolean checkPassword(String login, String passwd) {
        return this.getAccount(login) != null && this.getAccount(login).checkPasswd(passwd);
    }

    @Override
    public void setRoles(UserAccount account, Set<String> roles) {
        account.setRoles(new HashSet<String>(roles));
        this.save(account);
    }

    @Override
    public Set<String> getRoles(UserAccount account) {
        return account.getRoles();
    }

    @Override
    public void addRole(UserAccount account, String role) {
        account.addRole(role);
        this.save(account);
    }

    @Override
    public void removeRole(UserAccount account, String role) {
        Set<String> roles = account.getRoles();
        roles.remove(role);
        account.setRoles(roles);
        this.save(account);
    }

    @Override
    public boolean hasRole(UserAccount account, String role) {
        return account.getRoles().contains(role);
    }
}

