/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.user.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.marmotta.commons.util.HashUtils;

public class UserAccount
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String login;
    private String passwdHash;
    private String webId;
    private Set<String> roles = new HashSet<String>();

    public UserAccount() {
    }

    public UserAccount(String login, String webId) {
        this();
        this.login = login;
        this.webId = webId;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPasswdHash() {
        return this.passwdHash;
    }

    public void setPasswdHash(String passwdHash) {
        this.passwdHash = passwdHash;
    }

    public boolean checkPasswd(String password) {
        return PasswordHash.checkPasswd(this.getPasswdHash(), password);
    }

    public void setPasswd(PasswordHash alg, String passwd) {
        this.passwdHash = alg.encrypt(passwd);
    }

    public String getWebId() {
        return this.webId;
    }

    public void setWebId(String webId) {
        this.webId = webId;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAccount that = (UserAccount)o;
        if (this.login != null ? !this.login.equals(that.login) : that.login != null) {
            return false;
        }
        return !(this.webId != null ? !this.webId.equals(that.webId) : that.webId != null);
    }

    public int hashCode() {
        int result = this.login != null ? this.login.hashCode() : 0;
        result = 31 * result + (this.webId != null ? this.webId.hashCode() : 0);
        return result;
    }

    public static enum PasswordHash {
        PLAIN{

            @Override
            protected String hash(String in) {
                return in;
            }
        }
        ,
        MD5{

            @Override
            protected String hash(String in) {
                return HashUtils.md5sum((String)in);
            }
        }
        ,
        SHA1{

            @Override
            protected String hash(String in) {
                return HashUtils.sha1((String)in);
            }
        };

        private static final Pattern P;

        public String encrypt(String passwd) {
            return passwd == null ? null : ":" + this.toString().toLowerCase() + "::" + this.hash(passwd);
        }

        protected abstract String hash(String var1);

        public static boolean checkPasswd(String encrypted, String passwd) {
            if (encrypted != null && passwd != null) {
                try {
                    Matcher m = P.matcher(encrypted);
                    if (m.matches()) {
                        PasswordHash h = PasswordHash.valueOf(m.group(1).toUpperCase());
                        return encrypted.matches(h.encrypt(passwd));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        public static PasswordHash getPasswordHash(String passwdHash) {
            if (passwdHash != null) {
                try {
                    Matcher m = P.matcher(passwdHash);
                    if (m.matches()) {
                        PasswordHash h = PasswordHash.valueOf(m.group(1).toUpperCase());
                        return h;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return SHA1;
        }

        static {
            P = Pattern.compile(":(\\w+)::(.*)");
        }
    }
}

