/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.user.filters;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.modules.MarmottaHttpFilter;
import org.apache.marmotta.platform.core.api.user.UserService;
import org.apache.marmotta.platform.core.exception.UserExistsException;
import org.apache.marmotta.platform.core.exception.security.AccessDeniedException;
import org.apache.marmotta.platform.user.api.AuthenticationService;
import org.jboss.resteasy.spi.UnhandledException;
import org.openrdf.model.URI;
import org.slf4j.Logger;

@ApplicationScoped
public class MarmottaAuthenticationFilter
implements MarmottaHttpFilter {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private UserService userService;
    @Inject
    private AuthenticationService authenticationService;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.log.info("LMF Authentication Filter starting up; user authentication is {}", (Object)(this.configurationService.getBooleanConfiguration("security.enabled", true) ? "enabled" : "disabled"));
    }

    public String getPattern() {
        return "^/.*";
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.configurationService.getBooleanConfiguration("security.enabled", true)) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            try {
                String authorization = httpRequest.getHeader("Authorization");
                if (authorization != null) {
                    String passwd;
                    String credentialsBase64;
                    String credentialsPlain;
                    String[] credentials;
                    boolean authSuccess = false;
                    String login = "anonymous";
                    if (authorization.startsWith("Basic ") && (credentials = (credentialsPlain = new String(Base64.decodeBase64((String)(credentialsBase64 = authorization.split(" ")[1])))).split(":")).length == 2 && this.authenticationService.authenticateUser(login = credentials[0], passwd = credentials[1])) {
                        authSuccess = true;
                        httpRequest.setAttribute("user.name", (Object)login);
                        httpRequest.setAttribute("user.roles", this.authenticationService.listUserRoles(login));
                        URI user = this.userService.getUser(login);
                        if (user == null) {
                            try {
                                user = this.userService.createUser(login);
                            }
                            catch (UserExistsException e) {
                                // empty catch block
                            }
                        }
                        this.userService.setCurrentUser(user);
                    }
                    if (!authSuccess && !login.equals("anonymous")) {
                        throw new AccessDeniedException();
                    }
                }
                chain.doFilter(request, response);
            }
            catch (AccessDeniedException ex) {
                this.build401Response(response);
            }
            catch (UnhandledException ue) {
                if (ue.getCause().getClass().equals(AccessDeniedException.class)) {
                    this.build401Response(response);
                }
                throw ue;
            }
            finally {
                this.userService.clearCurrentUser();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void build401Response(ServletResponse response) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setStatus(401);
        String authMethod = "Basic";
        if ("BASIC".equalsIgnoreCase(this.configurationService.getStringConfiguration("security.method", authMethod))) {
            authMethod = "Basic";
        }
        String authRealm = this.configurationService.getStringConfiguration("security.realm", "Apache Marmotta");
        httpResponse.setHeader("WWW-Authenticate", authMethod + " realm=\"" + authRealm + "\"");
    }

    public void destroy() {
    }
}

