/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.ldpath.webservices;

import java.io.IOException;
import java.io.Reader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.marmotta.commons.sesame.repository.ExceptionUtils;
import org.apache.marmotta.commons.sesame.repository.ResourceUtils;
import org.apache.marmotta.commons.sesame.repository.ResultUtils;
import org.apache.marmotta.commons.util.JSONUtils;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiStringLiteral;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.backend.sesame.SesameConnectionBackend;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.ldpath.api.LDPathService;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.slf4j.Logger;

@ApplicationScoped
@Path(value="/ldpath")
public class LDPathWebService {
    @Inject
    private Logger log;
    @Inject
    private LDPathService ldPathService;
    @Inject
    private SesameService sesameService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/path")
    @Produces(value={"application/json"})
    public Response evaluatePathQuery(@QueryParam(value="path") String path, @QueryParam(value="uri") String resourceUri) {
        try {
            RepositoryConnection con = this.sesameService.getConnection();
            try {
                con.begin();
                if (ResourceUtils.isSubject((RepositoryConnection)con, (String)resourceUri)) {
                    URI resource = con.getValueFactory().createURI(resourceUri);
                    HashMap<String, String> namespaces = new HashMap<String, String>();
                    for (Namespace ns : ResultUtils.iterable((RepositoryResult)con.getNamespaces())) {
                        namespaces.put(ns.getPrefix(), ns.getName());
                    }
                    ArrayList<Map> result = new ArrayList<Map>();
                    try {
                        for (Value node : this.ldPathService.pathQuery((Value)resource, path, namespaces)) {
                            result.add(JSONUtils.serializeNodeAsJson((Value)node));
                        }
                        Response i$ = Response.ok().entity(result).build();
                        return i$;
                    }
                    catch (LDPathParseException e) {
                        this.log.warn("parse error while evaluating path {}: {}", (Object)path, (Object)e.getMessage());
                        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("parse error while evaluating path '" + path + "': " + e.getMessage())).build();
                        con.commit();
                        con.close();
                        return response;
                    }
                }
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("resource " + resourceUri + " does not exist")).build();
                return response;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                con.commit();
                con.close();
            }
        }
        catch (RepositoryException ex) {
            ExceptionUtils.handleRepositoryException((RepositoryException)ex, LDPathWebService.class);
            return Response.serverError().entity((Object)("error accessing RDF repository: " + ex.getMessage())).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/program")
    @Produces(value={"application/json"})
    public Response evaluateProgramQuery(@QueryParam(value="program") String program, @QueryParam(value="uri") String resourceUri) {
        try {
            RepositoryConnection con = this.sesameService.getConnection();
            try {
                con.begin();
                if (ResourceUtils.isSubject((RepositoryConnection)con, (String)resourceUri)) {
                    URI resource = con.getValueFactory().createURI(resourceUri);
                    HashMap<String, String> namespaces = new HashMap<String, String>();
                    for (Namespace ns : ResultUtils.iterable((RepositoryResult)con.getNamespaces())) {
                        namespaces.put(ns.getPrefix(), ns.getName());
                    }
                    HashMap result = new HashMap();
                    try {
                        for (Map.Entry<String, Collection<?>> row : this.ldPathService.programQuery((Value)resource, program).entrySet()) {
                            ArrayList<Map> rowList = new ArrayList<Map>();
                            for (Object o : row.getValue()) {
                                if (o instanceof KiWiNode) {
                                    rowList.add(JSONUtils.serializeNodeAsJson((Value)((Value)o)));
                                    continue;
                                }
                                rowList.add(JSONUtils.serializeNodeAsJson((Value)new KiWiStringLiteral(o.toString())));
                            }
                            result.put(row.getKey(), rowList);
                        }
                        Response i$ = Response.ok().entity(result).build();
                        return i$;
                    }
                    catch (LDPathParseException e) {
                        this.log.warn("parse error while evaluating program {}: {}", (Object)program, (Object)e.getMessage());
                        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("parse error while evaluating program: " + e.getMessage())).build();
                        con.commit();
                        con.close();
                        return response;
                    }
                }
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("resource " + resourceUri + " does not exist")).build();
                return response;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                con.commit();
                con.close();
            }
        }
        catch (RepositoryException ex) {
            ExceptionUtils.handleRepositoryException((RepositoryException)ex, LDPathWebService.class);
            return Response.serverError().entity((Object)("error accessing RDF repository: " + ex.getMessage())).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/functions")
    @Produces(value={"application/json"})
    public Response listFunctions() {
        ArrayList results = new ArrayList();
        try {
            RepositoryConnection con = this.sesameService.getConnection();
            try {
                con.begin();
                SesameConnectionBackend backend = SesameConnectionBackend.withConnection((RepositoryConnection)con);
                for (SelectorFunction<Value> function : this.ldPathService.getFunctions()) {
                    HashMap<String, String> fmap = new HashMap<String, String>();
                    fmap.put("name", function.getPathExpression((RDFBackend)backend));
                    fmap.put("signature", function.getSignature());
                    fmap.put("description", function.getDescription());
                    results.add(fmap);
                }
            }
            finally {
                con.commit();
                con.close();
            }
        }
        catch (RepositoryException e) {
            return Response.serverError().entity((Object)e).build();
        }
        Collections.sort(results, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                return Collator.getInstance().compare(o1.get("name"), o2.get("name"));
            }
        });
        return Response.ok().entity(results).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/functions/{name}")
    @Produces(value={"application/json"})
    public Response getFunction(@PathParam(value="name") String name) {
        try {
            RepositoryConnection con = this.sesameService.getConnection();
            try {
                con.begin();
                SesameConnectionBackend backend = SesameConnectionBackend.withConnection((RepositoryConnection)con);
                for (SelectorFunction<Value> function : this.ldPathService.getFunctions()) {
                    String fName = function.getPathExpression((RDFBackend)backend);
                    if (!name.equals(fName)) continue;
                    HashMap<String, String> fmap = new HashMap<String, String>();
                    fmap.put("name", fName);
                    fmap.put("signature", function.getSignature());
                    fmap.put("description", function.getDescription());
                    Response response = Response.ok(fmap).build();
                    return response;
                }
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("LDPath function with name " + name + " does not exist")).build();
                return response;
            }
            finally {
                con.commit();
                con.close();
            }
        }
        catch (RepositoryException e) {
            return Response.serverError().entity((Object)e).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/debug")
    @Produces(value={"application/json"})
    public Response testProgram(@QueryParam(value="context") String[] contextURI, @QueryParam(value="context[]") String[] contextURIarr, @Context HttpServletRequest request) {
        String[] cs = contextURI != null ? contextURI : contextURIarr;
        try {
            String program = IOUtils.toString((Reader)request.getReader());
            HashMap<String, String> namespaces = new HashMap<String, String>();
            RepositoryConnection con = this.sesameService.getConnection();
            try {
                con.begin();
                for (Namespace ns : ResultUtils.iterable((RepositoryResult)con.getNamespaces())) {
                    namespaces.put(ns.getPrefix(), ns.getName());
                }
                HashMap combined = new HashMap();
                for (String context : cs) {
                    if (ResourceUtils.isSubject((RepositoryConnection)con, (String)context)) {
                        URI resource = con.getValueFactory().createURI(context);
                        HashMap result = new HashMap();
                        try {
                            for (Map.Entry<String, Collection<?>> row : this.ldPathService.programQuery((Value)resource, program).entrySet()) {
                                ArrayList<Map> rowList = new ArrayList<Map>();
                                for (Object o : row.getValue()) {
                                    if (o instanceof KiWiNode) {
                                        rowList.add(JSONUtils.serializeNodeAsJson((Value)((Value)o)));
                                        continue;
                                    }
                                    rowList.add(JSONUtils.serializeNodeAsJson((Value)new KiWiStringLiteral(o.toString())));
                                }
                                result.put(row.getKey(), rowList);
                            }
                            combined.put(context, result);
                            continue;
                        }
                        catch (LDPathParseException e) {
                            this.log.warn("parse error while evaluating program {}: {}", (Object)program, (Object)e.getMessage());
                            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("parse error while evaluating program: " + e.getMessage())).build();
                            con.commit();
                            con.close();
                            return response;
                        }
                    }
                    Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("resource " + context + " does not exist")).build();
                    return response;
                }
                Response response = Response.ok(combined).build();
                return response;
            }
            finally {
                con.commit();
                con.close();
            }
        }
        catch (RepositoryException ex) {
            ExceptionUtils.handleRepositoryException((RepositoryException)ex, LDPathWebService.class);
            return Response.serverError().entity((Object)("error accessing RDF repository: " + ex.getMessage())).build();
        }
        catch (IOException ex) {
            return Response.serverError().entity((Object)("error reading program from stream: " + ex.getMessage())).build();
        }
    }
}

