/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.ldpath.webservices;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.marmotta.commons.http.UriUtil;
import org.apache.marmotta.commons.sesame.repository.ExceptionUtils;
import org.apache.marmotta.commons.sesame.repository.ResourceUtils;
import org.apache.marmotta.commons.sesame.repository.ResultUtils;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.backend.sesame.SesameConnectionBackend;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.apache.marmotta.platform.core.api.prefix.PrefixService;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.core.services.prefix.PrefixCC;
import org.apache.marmotta.platform.ldpath.api.LDPathService;
import org.openrdf.model.BNode;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

@Path(value="/ldpath/util")
public class LDPathUtilWebService {
    private static final String FUNCTION_NAMESPACE = "function:ldpath#";
    private static final String FUNCTION_PREFIX = "fn";
    private static final String MODE_TRANSFORM = "transformer";
    private static final Pattern CURIE_PATTERN = Pattern.compile("(\\w+):(\\w*)");
    @Inject
    private SesameService sesameService;
    @Inject
    private LDPathService ldPathService;
    @Inject
    private PrefixService prefixService;
    @Inject
    private PrefixCC prefixCC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/namespaces")
    @Produces(value={"application/json"})
    public Map<String, String> listKnownNamespaces(@Context UriInfo info) {
        LDPathPrefixService prefixService = this.createLocalPrefixService(info);
        HashMap<String, String> nss = new HashMap<String, String>();
        try {
            RepositoryConnection con = this.sesameService.getConnection();
            try {
                con.begin();
                for (Namespace ns : ResultUtils.iterable((RepositoryResult)con.getNamespaces())) {
                    nss.put(ns.getPrefix(), ns.getName());
                }
                con.commit();
            }
            finally {
                con.close();
            }
        }
        catch (RepositoryException e) {
            ExceptionUtils.handleRepositoryException((RepositoryException)e, LDPathUtilWebService.class);
        }
        for (Map.Entry e : prefixService.getMappings().entrySet()) {
            nss.put((String)e.getKey(), (String)e.getValue());
        }
        nss.put(FUNCTION_PREFIX, FUNCTION_NAMESPACE);
        return nss;
    }

    @GET
    @Path(value="/prefix")
    @Produces(value={"application/json"})
    public Map<String, String> resolvePrefix(@QueryParam(value="prefix") String prefix, @Context UriInfo info) {
        String namespace;
        LDPathPrefixService prefixService = this.createLocalPrefixService(info);
        if (prefixService.containsPrefix(prefix)) {
            return Collections.singletonMap(prefix, prefixService.getNamespace(prefix));
        }
        if (prefix != null && (namespace = this.prefixCC.getNamespace(prefix)) != null) {
            return Collections.singletonMap(prefix, namespace);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/complete")
    @Produces(value={"application/json"})
    public List<String> complete(@QueryParam(value="prefix") String prefix, @QueryParam(value="uri") String uri, @QueryParam(value="mode") @DefaultValue(value="path") String mode, @Context UriInfo info) {
        int limit = 20;
        LDPathPrefixService prefixService = this.createLocalPrefixService(info);
        if (uri != null) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String sug : this.getCompletions(uri, 20, mode)) {
                String curie = prefixService.getCurie(sug);
                suggestions.add(curie != null ? curie : sug);
            }
            return suggestions;
        }
        if (prefix != null) {
            Matcher m = CURIE_PATTERN.matcher(prefix);
            if (m.matches()) {
                String px = m.group(1);
                String local = m.group(2);
                if (px.equals(FUNCTION_PREFIX)) {
                    ArrayList<String> i$;
                    RepositoryConnection conn = this.sesameService.getConnection();
                    try {
                        conn.begin();
                        SesameConnectionBackend backend = SesameConnectionBackend.withConnection((RepositoryConnection)conn);
                        Set<SelectorFunction<Value>> functions = this.ldPathService.getFunctions();
                        ArrayList<String> suggestions = new ArrayList<String>();
                        for (SelectorFunction<Value> fn : functions) {
                            String fName = fn.getPathExpression((RDFBackend)backend);
                            if (!fName.startsWith(local)) continue;
                            suggestions.add("fn:" + fName + "()");
                        }
                        i$ = suggestions;
                    }
                    catch (Throwable throwable) {
                        try {
                            conn.commit();
                            conn.close();
                            throw throwable;
                        }
                        catch (RepositoryException e) {
                            return Collections.emptyList();
                        }
                    }
                    conn.commit();
                    conn.close();
                    return i$;
                }
                if (prefixService.containsPrefix(px)) {
                    String resolved = prefixService.getNamespace(px) + (local != null ? local : "");
                    ArrayList<String> suggestions = new ArrayList<String>();
                    for (String c : this.getCompletions(resolved, 20, mode)) {
                        if (c.length() <= resolved.length()) continue;
                        String curie = prefixService.getCurie(c);
                        suggestions.add(curie != null ? curie : c);
                    }
                    return suggestions;
                }
            } else {
                ArrayList<String> suggestions = new ArrayList<String>();
                if (mode.equals(MODE_TRANSFORM)) {
                    for (String s : this.ldPathService.getTransformableTypes()) {
                        String px = prefixService.getPrefix(UriUtil.getNamespace((String)s));
                        if (px == null || !px.startsWith(prefix) || suggestions.contains(px)) continue;
                        suggestions.add(px);
                    }
                } else {
                    if (FUNCTION_PREFIX.startsWith(prefix)) {
                        suggestions.add(FUNCTION_PREFIX);
                    }
                    for (String px : prefixService.getMappings().keySet()) {
                        if (!px.startsWith(prefix)) continue;
                        suggestions.add(px);
                    }
                }
                return suggestions;
            }
        }
        return Collections.emptyList();
    }

    private LDPathPrefixService createLocalPrefixService(UriInfo info) {
        HashMap<String, String> ns = new HashMap<String, String>();
        MultivaluedMap queryParameters = info.getQueryParameters();
        for (String key : queryParameters.keySet()) {
            if (!key.startsWith("ns_")) continue;
            ns.put(key.substring(3), (String)queryParameters.getFirst((Object)key));
        }
        return new LDPathPrefixService(ns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getCompletions(String uri, int limit, String mode) {
        ArrayList<String> result = new ArrayList<String>();
        if (!mode.equals(MODE_TRANSFORM)) {
            try {
                RepositoryConnection con = this.sesameService.getConnection();
                try {
                    for (URI r : ResourceUtils.listResourcesByPrefix((RepositoryConnection)con, (String)uri, (int)0, (int)limit)) {
                        result.add(r.stringValue());
                    }
                }
                finally {
                    con.commit();
                    con.close();
                }
            }
            catch (RepositoryException e) {
                ExceptionUtils.handleRepositoryException((RepositoryException)e, LDPathUtilWebService.class);
            }
        }
        for (String s : this.ldPathService.getTransformableTypes()) {
            if (!s.startsWith(uri)) continue;
            result.add(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/path")
    @Produces(value={"application/json"})
    public List<String> pathSuggestions(@QueryParam(value="path") String partialPath, @QueryParam(value="ctx") String[] ctx, @QueryParam(value="ctx[]") String[] ctx2, @Context UriInfo info) {
        LDPathPrefixService prefixService = this.createLocalPrefixService(info);
        HashSet<String> context = new HashSet<String>();
        for (String c : ctx) {
            context.add(c);
        }
        for (String c : ctx2) {
            context.add(c);
        }
        String path = partialPath.replaceAll("/.*", "").trim();
        if (path.equals("")) {
            path = ".";
        }
        try {
            HashSet<URI> pathCandidates = new HashSet<URI>();
            try {
                RepositoryConnection con = this.sesameService.getConnection();
                try {
                    con.begin();
                    for (String rsc_uri : context) {
                        if (!ResourceUtils.isSubject((RepositoryConnection)con, (String)rsc_uri)) continue;
                        URI rsc = con.getValueFactory().createURI(rsc_uri);
                        Collection<Value> cPos = this.ldPathService.pathQuery((Value)rsc, path, prefixService.getMappings());
                        for (Value cP : cPos) {
                            if (!(cP instanceof URI) && !(cP instanceof BNode)) continue;
                            for (Statement t : ResourceUtils.listOutgoing((RepositoryConnection)con, (Resource)((Resource)cP))) {
                                pathCandidates.add(t.getPredicate());
                            }
                        }
                    }
                }
                finally {
                    con.commit();
                    con.close();
                }
            }
            catch (RepositoryException e) {
                ExceptionUtils.handleRepositoryException((RepositoryException)e, LDPathUtilWebService.class);
            }
            ArrayList<String> suggest = new ArrayList<String>();
            for (URI r : pathCandidates) {
                suggest.add(r.stringValue());
            }
            return suggest;
        }
        catch (LDPathParseException e) {
            return Collections.emptyList();
        }
    }

    protected class LDPathPrefixService
    implements PrefixService {
        private final BiMap<String, String> localNS;

        public LDPathPrefixService(Map<String, String> local) {
            this.localNS = local != null ? HashBiMap.create(local) : HashBiMap.create();
        }

        public boolean containsPrefix(String prefix) {
            return this.localNS.containsKey((Object)prefix) || LDPathUtilWebService.this.prefixService.containsPrefix(prefix);
        }

        public boolean containsNamespace(String namespace) {
            return this.localNS.containsValue((Object)namespace) || LDPathUtilWebService.this.prefixService.containsNamespace(namespace);
        }

        public String getNamespace(String prefix) {
            if (this.localNS.containsKey((Object)prefix)) {
                return (String)this.localNS.get((Object)prefix);
            }
            return LDPathUtilWebService.this.prefixService.getNamespace(prefix);
        }

        public String getPrefix(String namespace) {
            if (this.localNS.containsValue((Object)namespace)) {
                return (String)this.localNS.inverse().get((Object)namespace);
            }
            return LDPathUtilWebService.this.prefixService.getPrefix(namespace);
        }

        public Map<String, String> getMappings() {
            HashMap<String, String> mappings = new HashMap<String, String>();
            mappings.putAll(LDPathUtilWebService.this.prefixService.getMappings());
            mappings.putAll((Map<String, String>)this.localNS);
            return Collections.unmodifiableMap(mappings);
        }

        public String getCurie(String uri) {
            if (UriUtil.validate((String)uri)) {
                String ns = UriUtil.getNamespace((String)uri);
                String ref = UriUtil.getReference((String)uri);
                if (StringUtils.isNotBlank((String)ns) && StringUtils.isNotBlank((String)ref) && this.containsNamespace(ns)) {
                    return this.getPrefix(ns) + ":" + ref;
                }
                return null;
            }
            return null;
        }

        public void add(String prefix, String namespace) throws IllegalArgumentException, URISyntaxException {
        }

        public void forceAdd(String prefix, String namespace) {
        }

        public String serializePrefixMapping() {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, String> mapping : this.getMappings().entrySet()) {
                sb.append("\n").append(mapping.getKey()).append(": ").append(mapping.getValue()).append(" ");
            }
            return sb.toString();
        }

        public String serializePrefixesSparqlDeclaration() {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, String> mapping : this.getMappings().entrySet()) {
                sb.append("PREFIX ").append(mapping.getKey()).append(": <").append(mapping.getValue()).append("> \n");
            }
            return sb.toString();
        }
    }
}

