/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.ldpath.services;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.marmotta.ldpath.LDPath;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.api.transformers.NodeTransformer;
import org.apache.marmotta.ldpath.backend.sesame.SesameConnectionBackend;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.apache.marmotta.ldpath.parser.Configuration;
import org.apache.marmotta.ldpath.parser.DefaultConfiguration;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.ldpath.api.AutoRegisteredLDPathFunction;
import org.apache.marmotta.platform.ldpath.api.LDPathService;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;

@ApplicationScoped
public class LDPathServiceImpl
implements LDPathService {
    @Inject
    private Logger log;
    @Inject
    private SesameService sesameService;
    private Configuration<Value> config;
    @Inject
    @Any
    private Instance<AutoRegisteredLDPathFunction> functions;

    @PostConstruct
    public void initialise() {
        this.log.info("initialising LDPath service ...");
        this.config = new DefaultConfiguration();
        for (AutoRegisteredLDPathFunction function : this.functions) {
            this.config.addFunction("http://www.newmedialab.at/lmf/functions/1.0/" + function.getLocalName(), (SelectorFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFunction(SelectorFunction<Value> function) {
        if (function instanceof AutoRegisteredLDPathFunction) {
            this.config.addFunction(((AutoRegisteredLDPathFunction)function).getLocalName(), function);
        } else {
            try {
                RepositoryConnection conn = this.sesameService.getConnection();
                try {
                    conn.begin();
                    SesameConnectionBackend backend = SesameConnectionBackend.withConnection((RepositoryConnection)conn);
                    this.config.addFunction("http://www.newmedialab.at/lmf/functions/1.0/" + function.getPathExpression((RDFBackend)backend), function);
                }
                finally {
                    conn.commit();
                    conn.close();
                }
            }
            catch (RepositoryException e) {
                this.log.warn("Could not add function:" + function.getSignature(), (Throwable)e);
            }
        }
    }

    @Override
    public void registerTransformer(String typeUri, NodeTransformer<?, Value> transformer) {
        this.config.addTransformer(typeUri, transformer);
    }

    @Override
    public Set<SelectorFunction<Value>> getFunctions() {
        HashSet<SelectorFunction<Value>> result = new HashSet<SelectorFunction<Value>>();
        result.addAll(this.config.getFunctions().values());
        return result;
    }

    @Override
    public Set<String> getTransformableTypes() {
        HashSet<String> t = new HashSet<String>();
        t.addAll(this.config.getTransformers().keySet());
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Value> pathQuery(Value context, String path, Map<String, String> namespaces) throws LDPathParseException {
        Collection collection;
        RepositoryConnection conn = this.sesameService.getConnection();
        try {
            conn.begin();
            SesameConnectionBackend backend = SesameConnectionBackend.withConnection((RepositoryConnection)conn);
            LDPath ldpath = new LDPath((RDFBackend)backend, this.config);
            collection = ldpath.pathQuery((Object)context, path, namespaces);
        }
        catch (Throwable throwable) {
            try {
                conn.commit();
                conn.close();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new LDPathParseException("LDPath evaluation failed", (Throwable)e);
            }
        }
        conn.commit();
        conn.close();
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Collection<?>> programQuery(Value context, String program) throws LDPathParseException {
        Map map;
        RepositoryConnection conn = this.sesameService.getConnection();
        try {
            conn.begin();
            SesameConnectionBackend backend = SesameConnectionBackend.withConnection((RepositoryConnection)conn);
            LDPath ldpath = new LDPath((RDFBackend)backend, this.config);
            map = ldpath.programQuery((Object)context, (Reader)new StringReader(program));
        }
        catch (Throwable throwable) {
            try {
                conn.commit();
                conn.close();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new LDPathParseException("LDPath evaluation failed", (Throwable)e);
            }
        }
        conn.commit();
        conn.close();
        return map;
    }
}

