/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.ldpath.model.functions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.apache.marmotta.ldpath.util.Collections;
import org.apache.marmotta.platform.ldpath.api.AutoRegisteredLDPathFunction;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Selector;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupFunction
extends AutoRegisteredLDPathFunction {
    private static final Logger log = LoggerFactory.getLogger(JsoupFunction.class);
    private final StringTransformer<Value> transformer = new StringTransformer();

    public Collection<Value> apply(RDFBackend<Value> rdfBackend, Value context, Collection<Value> ... args) throws IllegalArgumentException {
        Iterator<Value> it;
        if (args.length < 1) {
            throw new IllegalArgumentException("CSS-Selector is required as first argument.");
        }
        HashSet<String> jsoupSelectors = new HashSet<String>();
        for (Value xpath : args[0]) {
            try {
                jsoupSelectors.add(this.transformer.transform(rdfBackend, (Object)xpath, null));
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("First argument must not contain anything else than String-Literals!");
            }
        }
        if (args.length < 2) {
            log.debug("Use context {} to apply css-selector {}", (Object)context, jsoupSelectors);
            it = java.util.Collections.singleton(context).iterator();
        } else {
            log.debug("apply css-selector {} on parsed parameters", jsoupSelectors);
            it = Collections.iterator((int)1, (Collection[])args);
        }
        ArrayList<Value> result = new ArrayList<Value>();
        while (it.hasNext()) {
            Value n = it.next();
            try {
                String string = this.transformer.transform(rdfBackend, (Object)n, null);
                Document jsoup = Jsoup.parse((String)string);
                if (rdfBackend.isURI((Object)context)) {
                    jsoup.setBaseUri(rdfBackend.stringValue((Object)context));
                }
                for (String r : this.doFilter(jsoup, jsoupSelectors)) {
                    result.add((Value)rdfBackend.createLiteral(r));
                }
            }
            catch (IOException e) {
            }
        }
        return result;
    }

    private LinkedList<String> doFilter(Document jsoup, Set<String> jsoupSelectors) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        for (String jsoupSel : jsoupSelectors) {
            try {
                for (Element e : jsoup.select(jsoupSel)) {
                    result.add(e.outerHtml());
                }
            }
            catch (Selector.SelectorParseException xpe) {
                throw new IllegalArgumentException("error while processing jsoup selector: '" + jsoupSel + "'", xpe);
            }
        }
        return result;
    }

    @Override
    public String getLocalName() {
        return "jsoup";
    }

    public String getSignature() {
        return "fn:jsoup(jsoup: String [, nodes: XMLLiteralList]) : LiteralList";
    }

    public String getDescription() {
        return "Evaluate an JSoup CSS selector on either the value of the context node or the values of the nodes passed as arguments.";
    }
}

