/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.ldpath.model.functions;

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiStringLiteral;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.platform.core.api.content.ContentService;
import org.apache.marmotta.platform.ldpath.api.AutoRegisteredLDPathFunction;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.slf4j.Logger;

@ApplicationScoped
public class ContentFunction
extends AutoRegisteredLDPathFunction {
    @Inject
    private Logger log;
    @Inject
    private ContentService contentService;
    private String[] allowedTypes = new String[]{"text/.*", "application/([a-z]+\\+)?xml", "application/([a-z]+\\+)?json"};

    @PostConstruct
    public void initialise() {
        this.log.info("initialising LMF LDPath fn:content(...) function ...");
    }

    public Collection<Value> apply(RDFBackend<Value> kiWiNodeRDFBackend, Value context, Collection<Value> ... args) throws IllegalArgumentException {
        LinkedList<Value> result = new LinkedList<Value>();
        for (Collection<Value> nodes : args) {
            block1: for (Value n : nodes) {
                Resource r;
                String type;
                if (!(n instanceof KiWiResource) || (type = this.contentService.getContentType(r = (Resource)n)) == null) continue;
                for (String allowedType : this.allowedTypes) {
                    if (!type.matches(allowedType)) continue;
                    byte[] data = this.contentService.getContentData(r, type);
                    String content = new String(data);
                    result.add((Value)new KiWiStringLiteral(content));
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public String getLocalName() {
        return "content";
    }

    public String getSignature() {
        return "fn:content(nodes : URIResourceList) : LiteralList";
    }

    public String getDescription() {
        return "Resolve the URIs passed as argument and retrieve their content using the content reader applicable for the resource.";
    }
}

