/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.text;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;

public class WordCountFunction<Node>
extends SelectorFunction<Node> {
    private final URI dataType = URI.create("http://www.w3.org/2001/XMLSchema#integer");

    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)("Check usage: " + this.getSignature()));
        LinkedList<Object> result = new LinkedList<Object>();
        for (Node node : args[0]) {
            String stringValue = backend.stringValue(node);
            boolean isWordChar = false;
            int c = 0;
            for (int i = 0; i < stringValue.length(); ++i) {
                boolean isWC = Character.isLetterOrDigit(stringValue.codePointAt(i));
                if (!isWordChar && isWC) {
                    ++c;
                }
                isWordChar = isWC;
            }
            result.add(backend.createLiteral(String.valueOf(c), null, this.dataType));
        }
        return result;
    }

    public String getSignature() {
        return "fn:wc(text : LiteralList) : IntegerLiteralList";
    }

    public String getDescription() {
        return "Calculates the length of the provided literals (counting continuous chunks of letters+digits)";
    }

    public String getLocalName() {
        return "wc";
    }
}

