/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.text;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;

public class SubstringFunction<Node>
extends SelectorFunction<Node> {
    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        try {
            int start;
            if (args.length < 2 || args.length > 3) {
                throw new IllegalArgumentException("LdPath function " + this.getLocalName() + " requires 2 or 3 arguments");
            }
            if (args[1].size() != 1) {
                throw new IllegalArgumentException("start argument must be a single literal for function " + this.getLocalName());
            }
            if (args.length > 2 && args[2].size() != 1) {
                throw new IllegalArgumentException("end argument must be a single literal for function " + this.getLocalName());
            }
            Collection<Node> nodes = args[0];
            int end = args.length > 2 ? Math.max(backend.intValue(args[2].iterator().next()), 0) : Integer.MAX_VALUE;
            if (end < (start = Math.max(backend.intValue(args[1].iterator().next()), 0))) {
                throw new IllegalArgumentException(this.getLocalName() + " does not allow end beeing smaller than start (end:" + end + " < start:" + start + ")");
            }
            LinkedList<Object> result = new LinkedList<Object>();
            for (Node node : nodes) {
                String str = backend.stringValue(node);
                result.add(backend.createLiteral(str.substring(Math.min(start, str.length()), Math.min(end, str.length()))));
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe);
        }
        catch (ArithmeticException ae) {
            throw new IllegalArgumentException(ae);
        }
    }

    public String getSignature() {
        return "fn:substr(node::Node, start::NumericLiteral [, end::NumericLiteral]) :: StringLiteral";
    }

    public String getDescription() {
        return "Extract a substring for the string representation of a node";
    }

    public String getLocalName() {
        return "substr";
    }
}

