/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.text;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;

public class StrRightFunction<Node>
extends SelectorFunction<Node> {
    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        try {
            if (args.length != 2) {
                throw new IllegalArgumentException("LdPath function " + this.getLocalName() + " requires 2 arguments");
            }
            if (args[1].size() != 1) {
                throw new IllegalArgumentException("len argument must be a single literal for function " + this.getLocalName());
            }
            Collection<Node> nodes = args[0];
            int length = Math.max(backend.intValue(args[1].iterator().next()), 0);
            LinkedList<Object> result = new LinkedList<Object>();
            for (Node node : nodes) {
                String str = backend.stringValue(node);
                result.add(backend.createLiteral(str.substring(Math.max(0, str.length() - length))));
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe);
        }
        catch (ArithmeticException ae) {
            throw new IllegalArgumentException(ae);
        }
    }

    public String getSignature() {
        return "fn:strRight(node::Node, length::NumericLiteral) :: StringLiteral";
    }

    public String getDescription() {
        return "take the last n chars from the string representation";
    }

    protected String getLocalName() {
        return "strRight";
    }
}

