/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.text;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;

public class ReplaceFunction<Node>
extends SelectorFunction<Node> {
    private final StringTransformer<Node> transformer = new StringTransformer();

    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        if (args.length != 3 || args[1].size() != 1 || args[2].size() != 1) {
            throw new IllegalArgumentException("wrong usage: " + this.getSignature());
        }
        Collection<Node> nodes = args[0];
        Object regex = this.transformer.transform((RDFBackend)backend, (Object)args[1].iterator().next(), (Map)null);
        Object replace = this.transformer.transform((RDFBackend)backend, (Object)args[2].iterator().next(), (Map)null);
        try {
            Pattern pattern = Pattern.compile((String)regex);
            HashSet<Object> result = new HashSet<Object>();
            for (Node node : nodes) {
                String string = backend.stringValue(node);
                String replaced = pattern.matcher(string).replaceAll((String)replace);
                if (backend.isURI(node)) {
                    result.add(backend.createURI(replaced));
                    continue;
                }
                if (!backend.isLiteral(node)) continue;
                Locale lang = backend.getLiteralLanguage(node);
                URI type = backend.getLiteralType(node);
                result.add(backend.createLiteral(replaced, lang, type));
            }
            return result;
        }
        catch (PatternSyntaxException pex) {
            throw new IllegalArgumentException("could not parse regex pattern: '" + (String)regex + "'", pex);
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new IllegalArgumentException("invalid replacement string: '" + (String)replace + "'");
        }
    }

    public String getSignature() {
        return "fn:replace(nodes: NodeList, regex: String, replace: String) :: NodeList";
    }

    public String getDescription() {
        return "applies a String.replaceAll on the nodes (URI or LiteralContent resp.).";
    }

    public String getLocalName() {
        return "replace";
    }
}

