/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.versioning.sail;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.UnionIteration;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.apache.marmotta.kiwi.model.rdf.KiWiNamespace;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.apache.marmotta.kiwi.sail.KiWiValueFactory;
import org.apache.marmotta.kiwi.versioning.persistence.KiWiVersioningConnection;
import org.apache.marmotta.kiwi.versioning.sail.KiWiVersioningSail;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.FilterOptimizer;
import org.openrdf.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.openrdf.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.SailReadOnlyException;
import org.openrdf.sail.UnknownSailTransactionStateException;
import org.openrdf.sail.UpdateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiSnapshotConnection
implements SailConnection {
    private KiWiVersioningConnection databaseConnection;
    private Date snapshotDate;
    private String defaultContext;
    private KiWiValueFactory valueFactory;
    private KiWiVersioningSail parent;

    public KiWiSnapshotConnection(KiWiVersioningSail sailBase, Date snapshotDate) throws SailException {
        this.snapshotDate = snapshotDate;
        try {
            this.databaseConnection = sailBase.getPersistence().getConnection();
            this.defaultContext = sailBase.getBaseStore().getDefaultContext();
            this.valueFactory = new KiWiValueFactory(sailBase.getBaseStore(), this.defaultContext);
            this.parent = sailBase;
        }
        catch (SQLException e) {
            throw new SailException("error establishing database connection", (Throwable)e);
        }
    }

    public Date getSnapshotDate() {
        return this.snapshotDate;
    }

    public void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public void close() throws SailException {
        try {
            this.databaseConnection.close();
            this.parent.closeSnapshotConnection(this);
        }
        catch (SQLException e) {
            throw new SailException("database error while closing connection", (Throwable)e);
        }
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        if (!((tupleExpr = tupleExpr.clone()) instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        try {
            KiWiTripleSource tripleSource = new KiWiTripleSource(this, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
            new BindingAssigner().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer((EvaluationStrategy)strategy).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer((EvaluationStatistics)new KiWiEvaluationStatistics()).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            return strategy.evaluate(tupleExpr, bindings);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        try {
            return new ExceptionConvertingIteration<Resource, SailException>((Iteration)this.databaseConnection.listContexts()){

                protected SailException convert(Exception e) {
                    return new SailException("database error while iterating over result set", (Throwable)e);
                }
            };
        }
        catch (SQLException e) {
            throw new SailException("database error while listing contexts", (Throwable)e);
        }
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, final boolean includeInferred, Resource ... contexts) throws SailException {
        final KiWiResource rsubj = this.valueFactory.convert(subj);
        final KiWiUriResource rpred = this.valueFactory.convert(pred);
        final KiWiNode robj = this.valueFactory.convert(obj);
        HashSet contextSet = new HashSet();
        contextSet.addAll(Lists.transform(Arrays.asList(contexts), (Function)new Function<Resource, KiWiResource>(){

            public KiWiResource apply(Resource input) {
                return KiWiSnapshotConnection.this.valueFactory.convert(input);
            }
        }));
        HashSet<DelayedIteration> iterations = new HashSet<DelayedIteration>();
        if (contextSet.size() > 0) {
            for (final KiWiResource context : contextSet) {
                iterations.add(new DelayedIteration<Statement, RepositoryException>(){

                    protected Iteration<? extends Statement, ? extends RepositoryException> createIteration() throws RepositoryException {
                        try {
                            return KiWiSnapshotConnection.this.databaseConnection.listTriplesSnapshot(rsubj, rpred, robj, context, includeInferred, KiWiSnapshotConnection.this.snapshotDate);
                        }
                        catch (SQLException e) {
                            throw new RepositoryException("database error while listing triples", (Throwable)e);
                        }
                    }
                });
            }
        } else {
            iterations.add(new DelayedIteration<Statement, RepositoryException>(){

                protected Iteration<? extends Statement, ? extends RepositoryException> createIteration() throws RepositoryException {
                    try {
                        return KiWiSnapshotConnection.this.databaseConnection.listTriplesSnapshot(rsubj, rpred, robj, null, includeInferred, KiWiSnapshotConnection.this.snapshotDate);
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("database error while listing triples", (Throwable)e);
                    }
                }
            });
        }
        return new UnionIteration(Iterables.transform(iterations, (Function)new Function<DelayedIteration<Statement, RepositoryException>, Iteration<? extends Statement, SailException>>(){

            public Iteration<? extends Statement, SailException> apply(DelayedIteration<Statement, RepositoryException> input) {
                return new ExceptionConvertingIteration<Statement, SailException>(input){

                    protected SailException convert(Exception e) {
                        return new SailException("database error while iterating over result set", (Throwable)e);
                    }
                };
            }
        }));
    }

    public long size(Resource ... contexts) throws SailException {
        try {
            if (contexts.length == 0) {
                return this.databaseConnection.getSnapshotSize(this.snapshotDate);
            }
            long sum = 0L;
            for (Resource context : contexts) {
                sum += this.databaseConnection.getSnapshotSize(this.valueFactory.convert(context), this.snapshotDate);
            }
            return sum;
        }
        catch (SQLException ex) {
            throw new SailException("database error while listing triples", (Throwable)ex);
        }
    }

    public void begin() throws SailException {
    }

    public void commit() throws SailException {
        try {
            this.databaseConnection.commit();
        }
        catch (SQLException e) {
            throw new SailException("database error while committing transaction", (Throwable)e);
        }
    }

    public void rollback() throws SailException {
        try {
            this.databaseConnection.rollback();
        }
        catch (SQLException e) {
            throw new SailException("database error while committing transaction", (Throwable)e);
        }
    }

    public void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public void clear(Resource ... contexts) throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        try {
            return new ExceptionConvertingIteration<Namespace, SailException>((Iteration)this.databaseConnection.listNamespaces()){

                protected SailException convert(Exception e) {
                    return new SailException("database error while iterating over namespaces", (Throwable)e);
                }
            };
        }
        catch (SQLException e) {
            throw new SailException("database error while querying namespaces", (Throwable)e);
        }
    }

    public String getNamespace(String prefix) throws SailException {
        try {
            KiWiNamespace result = this.databaseConnection.loadNamespaceByPrefix(prefix);
            if (result != null) {
                return result.getUri();
            }
            return null;
        }
        catch (SQLException e) {
            throw new SailException("database error while querying namespaces", (Throwable)e);
        }
    }

    public void setNamespace(String prefix, String name) throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public void removeNamespace(String prefix) throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public void clearNamespaces() throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public void addStatement(UpdateContext op, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public void prepare() throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public void startUpdate(UpdateContext op) throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public void removeStatement(UpdateContext op, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public void endUpdate(UpdateContext op) throws SailException {
        throw new SailReadOnlyException("snapshot sails are read-only");
    }

    public boolean isOpen() throws SailException {
        try {
            return !this.databaseConnection.isClosed();
        }
        catch (SQLException e) {
            throw new SailException("database error while accessing connection", (Throwable)e);
        }
    }

    public boolean isActive() throws UnknownSailTransactionStateException {
        try {
            return this.isOpen();
        }
        catch (SailException e) {
            throw new UnknownSailTransactionStateException("unknown sail transaction state, error accessing database");
        }
    }

    private static class KiWiEvaluationStatistics
    extends EvaluationStatistics {
        private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

        protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
            return new KiWiCardinalityCalculator();
        }

        protected class KiWiCardinalityCalculator
        extends EvaluationStatistics.CardinalityCalculator {
            protected KiWiCardinalityCalculator() {
            }

            protected double getCardinality(StatementPattern sp) {
                return super.getCardinality(sp);
            }

            protected Value getConstantValue(Var var) {
                return var != null ? var.getValue() : null;
            }
        }
    }

    private static class KiWiTripleSource
    implements TripleSource {
        private boolean inferred;
        private KiWiSnapshotConnection connection;

        private KiWiTripleSource(KiWiSnapshotConnection connection, boolean inferred) {
            this.inferred = inferred;
            this.connection = connection;
        }

        public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
            try {
                return new ExceptionConvertingIteration<Statement, QueryEvaluationException>(this.connection.getStatements(subj, pred, obj, this.inferred, contexts)){

                    protected QueryEvaluationException convert(Exception e) {
                        if (e instanceof ClosedByInterruptException) {
                            return new QueryInterruptedException((Throwable)e);
                        }
                        if (e instanceof IOException) {
                            return new QueryEvaluationException((Throwable)e);
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (e == null) {
                            throw new IllegalArgumentException("e must not be null");
                        }
                        throw new IllegalArgumentException("Unexpected exception type: " + e.getClass());
                    }
                };
            }
            catch (SailException ex) {
                throw new QueryEvaluationException((Throwable)ex);
            }
        }

        public ValueFactory getValueFactory() {
            return this.connection.valueFactory;
        }
    }
}

