/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.reasoner.sail;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.marmotta.kiwi.reasoner.engine.ReasoningConfiguration;
import org.apache.marmotta.kiwi.reasoner.engine.ReasoningEngine;
import org.apache.marmotta.kiwi.reasoner.model.program.Justification;
import org.apache.marmotta.kiwi.reasoner.model.program.Program;
import org.apache.marmotta.kiwi.reasoner.model.program.Rule;
import org.apache.marmotta.kiwi.reasoner.parser.KWRLProgramParser;
import org.apache.marmotta.kiwi.reasoner.parser.ParseException;
import org.apache.marmotta.kiwi.reasoner.persistence.KiWiReasoningConnection;
import org.apache.marmotta.kiwi.reasoner.persistence.KiWiReasoningPersistence;
import org.apache.marmotta.kiwi.sail.KiWiStore;
import org.apache.marmotta.kiwi.transactions.api.TransactionalSail;
import org.apache.marmotta.kiwi.transactions.wrapper.TransactionalSailWrapper;
import org.openrdf.sail.SailException;
import org.openrdf.sail.StackableSail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiReasoningSail
extends TransactionalSailWrapper {
    private static Logger log = LoggerFactory.getLogger(KiWiReasoningSail.class);
    private ReasoningConfiguration config;
    private ReasoningEngine engine;
    private KiWiReasoningPersistence persistence;
    private boolean initialized = false;

    public KiWiReasoningSail(TransactionalSail parent, ReasoningConfiguration config) {
        super(parent);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SailException {
        KiWiReasoningSail kiWiReasoningSail = this;
        synchronized (kiWiReasoningSail) {
            if (!this.initialized) {
                super.initialize();
                KiWiStore store = this.getBaseStore();
                try {
                    this.persistence = new KiWiReasoningPersistence(store.getPersistence(), this.getValueFactory());
                    this.persistence.initDatabase();
                    this.engine = new ReasoningEngine(this.persistence, (TransactionalSail)this, this.config);
                    this.addTransactionListener(this.engine);
                    this.initialized = true;
                }
                catch (SQLException e) {
                    log.error("error initializing reasoning database", (Throwable)e);
                    throw new SailException("error initializing reasoning database", (Throwable)e);
                }
            }
        }
    }

    public void shutDown() throws SailException {
        this.engine.shutdown();
        super.shutDown();
    }

    public KiWiStore getBaseStore() {
        KiWiReasoningSail current;
        for (current = this; current != null && current.getBaseSail() instanceof StackableSail; current = (StackableSail)current.getBaseSail()) {
        }
        if (current != null && current.getBaseSail() instanceof KiWiStore) {
            return (KiWiStore)current.getBaseSail();
        }
        throw new IllegalStateException("the base store is not a KiWiStore (type: " + current.getBaseSail().getClass().getCanonicalName() + ")!");
    }

    public ReasoningConfiguration getConfig() {
        return this.config;
    }

    public void addProgram(String name, InputStream data) throws IOException, SailException, ParseException {
        KWRLProgramParser parser = new KWRLProgramParser(this.getValueFactory(), data);
        Program p = parser.parseProgram();
        p.setName(name);
        this.addProgram(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgram(Program program) throws SailException {
        try {
            KiWiReasoningConnection connection = this.persistence.getConnection();
            try {
                connection.storeProgram(program);
                connection.commit();
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException ex) {
            throw new SailException("cannot store program in database", (Throwable)ex);
        }
        this.engine.loadPrograms();
        for (Rule rule : program.getRules()) {
            this.engine.notifyAddRule(rule);
        }
    }

    public void updateProgram(String name, InputStream data) throws IOException, SailException, ParseException {
        KWRLProgramParser parser = new KWRLProgramParser(this.getValueFactory(), data);
        Program p = parser.parseProgram();
        p.setName(name);
        this.updateProgram(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgram(Program program) throws SailException {
        HashSet<Rule> added = new HashSet<Rule>();
        HashSet<Rule> removed = new HashSet<Rule>();
        try {
            KiWiReasoningConnection connection = this.persistence.getConnection();
            try {
                Program old = connection.loadProgram(program.getName());
                if (old != null) {
                    for (Rule r : old.getRules()) {
                        if (program.getRules().contains(r)) continue;
                        removed.add(r);
                    }
                    for (Rule r : program.getRules()) {
                        if (old.getRules().contains(r)) continue;
                        added.add(r);
                    }
                }
                connection.updateProgram(program);
                connection.commit();
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException ex) {
            throw new SailException("cannot store program in database", (Throwable)ex);
        }
        this.engine.loadPrograms();
        if (removed.size() > 0) {
            this.engine.notifyRemoveRules();
        }
        for (Rule rule : added) {
            this.engine.notifyAddRule(rule);
        }
    }

    public CloseableIteration<Program, SailException> listPrograms() throws SailException {
        try {
            final KiWiReasoningConnection connection = this.persistence.getConnection();
            return new ExceptionConvertingIteration<Program, SailException>(connection.listPrograms()){

                protected SailException convert(Exception e) {
                    return new SailException((Throwable)e);
                }

                protected void handleClose() throws SailException {
                    super.handleClose();
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (SQLException ex) {
                        throw new SailException("database error while committing/closing connection");
                    }
                }
            };
        }
        catch (SQLException ex) {
            throw new SailException("cannot list programs in database", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Program getProgram(String name) throws SailException {
        Program program;
        KiWiReasoningConnection connection = this.persistence.getConnection();
        try {
            Program p = connection.loadProgram(name);
            connection.commit();
            program = p;
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException ex) {
                throw new SailException("cannot load program from database", (Throwable)ex);
            }
        }
        connection.close();
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProgram(String name) throws SailException {
        try {
            KiWiReasoningConnection connection = this.persistence.getConnection();
            try {
                Program p = connection.loadProgram(name);
                connection.deleteProgram(p);
                connection.commit();
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException ex) {
            throw new SailException("cannot load program from database", (Throwable)ex);
        }
        this.engine.loadPrograms();
        this.engine.notifyRemoveRules();
    }

    public void reRunPrograms() {
        this.engine.reRunPrograms();
    }

    public ReasoningEngine getEngine() {
        return this.engine;
    }

    public KiWiReasoningPersistence getPersistence() {
        return this.persistence;
    }

    public CloseableIteration<Justification, SailException> justify(long tripleId) throws SailException {
        try {
            final KiWiReasoningConnection connection = this.persistence.getConnection();
            return new ExceptionConvertingIteration<Justification, SailException>(connection.listJustificationsForTriple(tripleId)){

                protected SailException convert(Exception e) {
                    return new SailException((Throwable)e);
                }

                protected void handleClose() throws SailException {
                    super.handleClose();
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (SQLException ex) {
                        throw new SailException("database error while committing/closing connection");
                    }
                }
            };
        }
        catch (SQLException ex) {
            throw new SailException("cannot list programs in database", (Throwable)ex);
        }
    }
}

