/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.reasoner.persistence;

import java.sql.SQLException;
import org.apache.marmotta.kiwi.persistence.KiWiDialect;
import org.apache.marmotta.kiwi.persistence.KiWiPersistence;
import org.apache.marmotta.kiwi.reasoner.persistence.KiWiReasoningConnection;
import org.openrdf.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiReasoningPersistence {
    private static Logger log = LoggerFactory.getLogger(KiWiReasoningPersistence.class);
    private KiWiPersistence persistence;
    private ValueFactory valueFactory;

    public KiWiReasoningPersistence(KiWiPersistence persistence, ValueFactory valueFactory) {
        this.persistence = persistence;
        this.valueFactory = valueFactory;
        persistence.addTripleTableDependency("reasoner_justifications", "triple_id");
        persistence.addTripleTableDependency("reasoner_just_supp_triples", "triple_id");
    }

    public void initDatabase() throws SQLException {
        this.persistence.initDatabase("reasoner", new String[]{"reasoner_programs", "reasoner_program_namespaces", "reasoner_program_rules", "reasoner_rules", "reasoner_justifications", "reasoner_just_supp_triples", "reasoner_just_supp_rules"});
    }

    public void dropDatabase() throws SQLException {
        this.persistence.dropDatabase("reasoner");
    }

    public KiWiReasoningConnection getConnection() throws SQLException {
        return new KiWiReasoningConnection(this.persistence, this.persistence.getDialect(), this.persistence.getCacheManager(), this.valueFactory);
    }

    public KiWiDialect getDialect() {
        return this.persistence.getDialect();
    }
}

