/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.reasoner.persistence;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import info.aduna.iteration.IteratorIteration;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.marmotta.kiwi.caching.KiWiCacheManager;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.persistence.KiWiConnection;
import org.apache.marmotta.kiwi.persistence.KiWiDialect;
import org.apache.marmotta.kiwi.persistence.KiWiPersistence;
import org.apache.marmotta.kiwi.persistence.util.ResultSetIteration;
import org.apache.marmotta.kiwi.persistence.util.ResultTransformerFunction;
import org.apache.marmotta.kiwi.reasoner.model.program.Field;
import org.apache.marmotta.kiwi.reasoner.model.program.Filter;
import org.apache.marmotta.kiwi.reasoner.model.program.Justification;
import org.apache.marmotta.kiwi.reasoner.model.program.LiteralField;
import org.apache.marmotta.kiwi.reasoner.model.program.Pattern;
import org.apache.marmotta.kiwi.reasoner.model.program.Program;
import org.apache.marmotta.kiwi.reasoner.model.program.ResourceField;
import org.apache.marmotta.kiwi.reasoner.model.program.Rule;
import org.apache.marmotta.kiwi.reasoner.model.program.VariableField;
import org.apache.marmotta.kiwi.reasoner.model.query.QueryResult;
import org.apache.marmotta.kiwi.reasoner.parser.KWRLProgramParser;
import org.apache.marmotta.kiwi.reasoner.parser.ParseException;
import org.openrdf.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiReasoningConnection
extends KiWiConnection {
    private static Logger log = LoggerFactory.getLogger(KiWiReasoningConnection.class);
    private ValueFactory valueFactory;
    private Cache ruleIdCache;

    public KiWiReasoningConnection(KiWiPersistence persistence, KiWiDialect dialect, KiWiCacheManager cacheManager, ValueFactory valueFactory) throws SQLException {
        super(persistence, dialect, cacheManager);
        this.valueFactory = valueFactory;
        this.ruleIdCache = this.getCacheManager().getCacheByName("reasoning-rule-id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRule(Rule rule, Map<String, String> namespaces) throws SQLException {
        PreparedStatement insertRule;
        if (rule.getId() != null) {
            log.warn("rule {} already had a database ID, not persisting", (Object)rule);
            return;
        }
        this.requireJDBCConnection();
        rule.setId(this.getNextSequence("seq.rules"));
        PreparedStatement preparedStatement = insertRule = this.getPreparedStatement("rules.insert");
        synchronized (preparedStatement) {
            insertRule.setLong(1, rule.getId());
            insertRule.setString(2, rule.getName());
            insertRule.setString(3, rule.getDescription());
            insertRule.setString(4, rule.toString(namespaces));
            insertRule.executeUpdate();
        }
        this.ruleIdCache.put(new Element((Object)rule.getId(), (Object)rule));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rule loadRuleById(long ruleId, Map<String, String> namespaces) throws SQLException {
        PreparedStatement loadRule;
        PreparedStatement preparedStatement;
        Element cached = this.ruleIdCache.get((Serializable)Long.valueOf(ruleId));
        if (cached != null) {
            return (Rule)cached.getObjectValue();
        }
        this.requireJDBCConnection();
        if (namespaces == null) {
            PreparedStatement loadNamespaces;
            namespaces = new HashMap<String, String>();
            preparedStatement = loadNamespaces = this.getPreparedStatement("namespaces.load_by_rule");
            synchronized (preparedStatement) {
                loadNamespaces.setLong(1, ruleId);
                ResultSet namespaceResult = loadNamespaces.executeQuery();
                while (namespaceResult.next()) {
                    namespaces.put(namespaceResult.getString("ns_prefix"), namespaceResult.getString("ns_uri"));
                }
                namespaceResult.close();
            }
        }
        preparedStatement = loadRule = this.getPreparedStatement("rules.load_by_id");
        synchronized (preparedStatement) {
            loadRule.setLong(1, ruleId);
            ResultSet result = loadRule.executeQuery();
            try {
                if (result.next()) {
                    Rule rule = this.constructRuleFromDatabase(result, namespaces);
                    return rule;
                }
                Rule rule = null;
                return rule;
            }
            catch (ParseException e) {
                throw new SQLException("error while parsing rule body", e);
            }
            finally {
                result.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<Rule, SQLException> loadRulesByProgram(long programId, final Map<String, String> namespaces) throws SQLException, ParseException {
        PreparedStatement loadRule;
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = loadRule = this.getPreparedStatement("rules.load_by_program");
        synchronized (preparedStatement) {
            loadRule.setLong(1, programId);
            ResultSet result = loadRule.executeQuery();
            return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<Rule>(){

                public Rule apply(ResultSet row) throws SQLException {
                    try {
                        return KiWiReasoningConnection.this.constructRuleFromDatabase(row, namespaces);
                    }
                    catch (ParseException e) {
                        throw new SQLException("error while parsing rule body", e);
                    }
                }
            });
        }
    }

    protected Rule constructRuleFromDatabase(ResultSet row, Map<String, String> namespaces) throws SQLException, ParseException {
        Element cached = this.ruleIdCache.get((Serializable)Long.valueOf(row.getLong("id")));
        if (cached != null) {
            return (Rule)cached.getObjectValue();
        }
        Rule result = KWRLProgramParser.parseRule(row.getString("body"), namespaces, this.valueFactory);
        result.setId(row.getLong("id"));
        result.setName(row.getString("name"));
        result.setDescription(row.getString("description"));
        this.ruleIdCache.put(new Element((Object)result.getId(), (Object)result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRule(Rule rule) throws SQLException {
        PreparedStatement deleteRule;
        if (rule.getId() == null) {
            log.warn("rule {} does not have a database ID, cannot delete", (Object)rule);
            return;
        }
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = deleteRule = this.getPreparedStatement("rules.delete_by_id");
        synchronized (preparedStatement) {
            deleteRule.setLong(1, rule.getId());
            deleteRule.executeUpdate();
        }
        this.ruleIdCache.remove((Serializable)rule.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeProgram(Program program) throws SQLException {
        PreparedStatement insertRuleRelation;
        PreparedStatement insertNamespaces;
        PreparedStatement insertProgram;
        if (program.getId() != null) {
            throw new SQLException("Program already stored in the database");
        }
        this.requireJDBCConnection();
        program.setId(this.getNextSequence("seq.programs"));
        PreparedStatement preparedStatement = insertProgram = this.getPreparedStatement("programs.insert");
        synchronized (preparedStatement) {
            insertProgram.setLong(1, program.getId());
            insertProgram.setString(2, program.getName());
            insertProgram.setString(3, program.getDescription());
            insertProgram.executeUpdate();
            insertProgram.clearParameters();
        }
        PreparedStatement preparedStatement2 = insertNamespaces = this.getPreparedStatement("programs.add_ns");
        synchronized (preparedStatement2) {
            insertNamespaces.clearBatch();
            for (Map.Entry<String, String> entry : program.getNamespaces().entrySet()) {
                insertNamespaces.clearParameters();
                insertNamespaces.setLong(1, program.getId());
                insertNamespaces.setString(2, entry.getKey());
                insertNamespaces.setString(3, entry.getValue());
                insertNamespaces.addBatch();
            }
            insertNamespaces.executeBatch();
            insertNamespaces.clearBatch();
        }
        for (Rule rule : program.getRules()) {
            this.storeRule(rule, program.getNamespaces());
        }
        PreparedStatement preparedStatement3 = insertRuleRelation = this.getPreparedStatement("programs.add_rule");
        synchronized (preparedStatement3) {
            insertRuleRelation.clearBatch();
            for (Rule rule : program.getRules()) {
                insertRuleRelation.clearParameters();
                insertRuleRelation.setLong(1, program.getId());
                insertRuleRelation.setLong(2, rule.getId());
                insertRuleRelation.addBatch();
            }
            insertRuleRelation.executeBatch();
            insertRuleRelation.clearBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgram(Program program) throws SQLException {
        this.requireJDBCConnection();
        Program old = this.loadProgram(program.getName());
        if (old == null) {
            this.storeProgram(program);
        } else {
            PreparedStatement deleteProgramNS;
            PreparedStatement preparedStatement;
            if (old.getDescription() != null && !old.getDescription().equals(program.getDescription()) || old.getDescription() == null && program.getDescription() != null) {
                PreparedStatement updateProgramDescription;
                preparedStatement = updateProgramDescription = this.getPreparedStatement("programs.update_desc");
                synchronized (preparedStatement) {
                    updateProgramDescription.setString(1, program.getDescription());
                    updateProgramDescription.setLong(2, old.getId());
                    updateProgramDescription.executeUpdate();
                }
            }
            preparedStatement = deleteProgramNS = this.getPreparedStatement("programs.delete_ns");
            synchronized (preparedStatement) {
                deleteProgramNS.clearBatch();
                for (Map.Entry<String, String> oldNS : old.getNamespaces().entrySet()) {
                    if (program.getNamespaces().entrySet().contains(oldNS)) continue;
                    deleteProgramNS.setLong(1, old.getId());
                    deleteProgramNS.setString(2, oldNS.getKey());
                    deleteProgramNS.setString(3, oldNS.getValue());
                    deleteProgramNS.addBatch();
                }
                deleteProgramNS.executeBatch();
            }
            PreparedStatement addProgramNS = this.getPreparedStatement("programs.add_ns");
            PreparedStatement i$ = addProgramNS;
            synchronized (i$) {
                addProgramNS.clearBatch();
                for (Map.Entry<String, String> entry : program.getNamespaces().entrySet()) {
                    if (old.getNamespaces().entrySet().contains(entry)) continue;
                    addProgramNS.setLong(1, old.getId());
                    addProgramNS.setString(2, entry.getKey());
                    addProgramNS.setString(3, entry.getValue());
                    addProgramNS.addBatch();
                }
                addProgramNS.executeBatch();
            }
            PreparedStatement deleteProgramRule = this.getPreparedStatement("programs.delete_rule");
            PreparedStatement deleteRule = this.getPreparedStatement("rules.delete_by_id");
            PreparedStatement preparedStatement2 = deleteProgramRule;
            synchronized (preparedStatement2) {
                deleteProgramRule.clearBatch();
                deleteRule.clearBatch();
                for (Rule oldRule : old.getRules()) {
                    if (program.getRules().contains(oldRule)) continue;
                    deleteProgramRule.setLong(1, old.getId());
                    deleteProgramRule.setLong(2, oldRule.getId());
                    deleteProgramRule.addBatch();
                    deleteRule.setLong(1, oldRule.getId());
                    deleteRule.addBatch();
                    this.deleteJustifications(oldRule);
                    oldRule.setId(null);
                }
                deleteProgramRule.executeBatch();
                deleteRule.executeBatch();
            }
            PreparedStatement preparedStatement3 = this.getPreparedStatement("rules.insert");
            PreparedStatement addProgramRule = this.getPreparedStatement("programs.add_rule");
            PreparedStatement preparedStatement4 = preparedStatement3;
            synchronized (preparedStatement4) {
                preparedStatement3.clearBatch();
                addProgramRule.clearBatch();
                for (Rule rule : program.getRules()) {
                    if (old.getRules().contains(rule)) continue;
                    rule.setId(this.getNextSequence("seq.rules"));
                    preparedStatement3.setLong(1, rule.getId());
                    preparedStatement3.setString(2, rule.getName());
                    preparedStatement3.setString(3, rule.getDescription());
                    preparedStatement3.setString(4, rule.toString(program.getNamespaces()));
                    preparedStatement3.addBatch();
                    addProgramRule.setLong(1, old.getId());
                    addProgramRule.setLong(2, rule.getId());
                    addProgramRule.addBatch();
                }
                preparedStatement3.executeBatch();
                addProgramRule.executeBatch();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Program loadProgram(String name) throws SQLException {
        PreparedStatement loadProgram;
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = loadProgram = this.getPreparedStatement("programs.load_by_name");
        synchronized (preparedStatement) {
            loadProgram.setString(1, name);
            ResultSet result = loadProgram.executeQuery();
            try {
                if (result.next()) {
                    Program program = this.constructProgramFromDatabase(result);
                    return program;
                }
                Program program = null;
                return program;
            }
            catch (ParseException e) {
                throw new SQLException("error while parsing program rules", e);
            }
            finally {
                result.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Program loadProgram(Long id) throws SQLException {
        PreparedStatement loadProgram;
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = loadProgram = this.getPreparedStatement("programs.load_by_id");
        synchronized (preparedStatement) {
            loadProgram.setLong(1, id);
            ResultSet result = loadProgram.executeQuery();
            try {
                if (result.next()) {
                    Program program = this.constructProgramFromDatabase(result);
                    return program;
                }
                Program program = null;
                return program;
            }
            catch (ParseException e) {
                throw new SQLException("error while parsing program rules", e);
            }
            finally {
                result.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Program constructProgramFromDatabase(ResultSet row) throws SQLException, ParseException {
        PreparedStatement loadRule;
        PreparedStatement loadProgramNS;
        Program program = new Program();
        program.setId(row.getLong("id"));
        program.setName(row.getString("name"));
        program.setDescription(row.getString("description"));
        PreparedStatement preparedStatement = loadProgramNS = this.getPreparedStatement("namespaces.load_by_program");
        synchronized (preparedStatement) {
            loadProgramNS.setLong(1, program.getId());
            ResultSet nsResult = loadProgramNS.executeQuery();
            while (nsResult.next()) {
                program.addNamespace(nsResult.getString("ns_prefix"), nsResult.getString("ns_uri"));
            }
            nsResult.close();
        }
        PreparedStatement preparedStatement2 = loadRule = this.getPreparedStatement("rules.load_by_program");
        synchronized (preparedStatement2) {
            loadRule.setLong(1, program.getId());
            ResultSet ruleResult = loadRule.executeQuery();
            while (ruleResult.next()) {
                program.addRule(this.constructRuleFromDatabase(ruleResult, program.getNamespaces()));
            }
            ruleResult.close();
        }
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<Program, SQLException> listPrograms() throws SQLException {
        PreparedStatement listPrograms;
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = listPrograms = this.getPreparedStatement("programs.list");
        synchronized (preparedStatement) {
            ResultSet result = listPrograms.executeQuery();
            return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<Program>(){

                public Program apply(ResultSet row) throws SQLException {
                    try {
                        return KiWiReasoningConnection.this.constructProgramFromDatabase(row);
                    }
                    catch (ParseException e) {
                        throw new SQLException("error while parsing program rules", e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProgram(Program program) throws SQLException {
        PreparedStatement deleteProgram;
        if (program.getId() == null) {
            log.warn("cannot delete non-persistent program (name={})!", (Object)program.getName());
            return;
        }
        this.requireJDBCConnection();
        PreparedStatement deleteProgramRule = this.getPreparedStatement("programs.delete_rule");
        PreparedStatement deleteRule = this.getPreparedStatement("rules.delete_by_id");
        PreparedStatement preparedStatement = deleteProgramRule;
        synchronized (preparedStatement) {
            deleteProgramRule.clearBatch();
            deleteRule.clearBatch();
            for (Rule rule : program.getRules()) {
                deleteProgramRule.setLong(1, program.getId());
                deleteProgramRule.setLong(2, rule.getId());
                deleteProgramRule.addBatch();
                deleteRule.setLong(1, rule.getId());
                deleteRule.addBatch();
                this.deleteJustifications(rule);
            }
            deleteProgramRule.executeBatch();
            deleteRule.executeBatch();
        }
        PreparedStatement deleteProgramNS = this.getPreparedStatement("programs.delete_ns");
        PreparedStatement i$ = deleteProgramNS;
        synchronized (i$) {
            deleteProgramNS.clearBatch();
            for (Map.Entry<String, String> ns : program.getNamespaces().entrySet()) {
                deleteProgramNS.setLong(1, program.getId());
                deleteProgramNS.setString(2, ns.getKey());
                deleteProgramNS.setString(3, ns.getValue());
                deleteProgramNS.addBatch();
            }
            deleteProgramNS.executeBatch();
        }
        PreparedStatement preparedStatement2 = deleteProgram = this.getPreparedStatement("programs.delete");
        synchronized (preparedStatement2) {
            deleteProgram.setLong(1, program.getId());
            deleteProgram.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJustifications(Iterable<Justification> justifications) throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement insertJustification = this.getPreparedStatement("justifications.insert");
        PreparedStatement justificationAddTriple = this.getPreparedStatement("justifications.add_triple");
        PreparedStatement justificationAddRule = this.getPreparedStatement("justifications.add_rule");
        PreparedStatement preparedStatement = insertJustification;
        synchronized (preparedStatement) {
            insertJustification.clearBatch();
            justificationAddTriple.clearBatch();
            justificationAddRule.clearBatch();
            for (Justification j : justifications) {
                if (j.getId() != null) {
                    log.warn("justification is already stored in database, not persisting again (database ID: {})", (Object)j.getId());
                    continue;
                }
                j.setId(this.getNextSequence("seq.justifications"));
                j.setCreatedAt(new Date());
                insertJustification.clearParameters();
                insertJustification.setLong(1, j.getId());
                insertJustification.setLong(2, j.getTriple().getId());
                insertJustification.setTimestamp(3, new Timestamp(j.getCreatedAt().getTime()));
                insertJustification.addBatch();
                for (KiWiTriple supportingTriple : j.getSupportingTriples()) {
                    if (supportingTriple.getId() == null) {
                        log.error("supporting triple is not persistent, cannot store justification (triple={})", (Object)supportingTriple);
                        continue;
                    }
                    justificationAddTriple.clearParameters();
                    justificationAddTriple.setLong(1, j.getId());
                    justificationAddTriple.setLong(2, supportingTriple.getId());
                    justificationAddTriple.addBatch();
                }
                for (Rule supportingRule : j.getSupportingRules()) {
                    if (supportingRule.getId() == null) {
                        log.error("supporting rule is not persistent, cannot store justification (rule={})", (Object)supportingRule);
                        continue;
                    }
                    justificationAddRule.clearParameters();
                    justificationAddRule.setLong(1, j.getId());
                    justificationAddRule.setLong(2, supportingRule.getId());
                    justificationAddRule.addBatch();
                }
            }
            insertJustification.executeBatch();
            justificationAddTriple.executeBatch();
            justificationAddRule.executeBatch();
        }
    }

    public void deleteJustifications(Iterable<Justification> justifications) throws SQLException {
        this.deleteJustifications((Iteration<Justification, SQLException>)new IteratorIteration(justifications.iterator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteJustifications(Iteration<Justification, SQLException> justifications) throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement deleteJustification = this.getPreparedStatement("justifications.delete");
        PreparedStatement deleteJustificationRules = this.getPreparedStatement("justifications.del_rule");
        PreparedStatement deleteJustificationTriples = this.getPreparedStatement("justifications.del_triple");
        PreparedStatement preparedStatement = deleteJustification;
        synchronized (preparedStatement) {
            deleteJustification.clearBatch();
            deleteJustificationRules.clearBatch();
            deleteJustificationTriples.clearBatch();
            while (justifications.hasNext()) {
                Justification j = (Justification)justifications.next();
                if (j.getId() == null) {
                    log.error("cannot delete justification since it does not have a database ID");
                    continue;
                }
                deleteJustificationRules.setLong(1, j.getId());
                deleteJustificationRules.addBatch();
                deleteJustificationTriples.setLong(1, j.getId());
                deleteJustificationTriples.addBatch();
                deleteJustification.setLong(1, j.getId());
                deleteJustification.addBatch();
            }
            Iterations.closeCloseable(justifications);
            deleteJustificationTriples.executeBatch();
            deleteJustificationRules.executeBatch();
            deleteJustification.executeBatch();
        }
    }

    public void deleteJustifications(Rule rule) throws SQLException {
        this.deleteJustifications((Iteration<Justification, SQLException>)this.listJustificationsBySupporting(rule));
    }

    public void deleteJustifications(KiWiTriple triple) throws SQLException {
        this.deleteJustifications((Iteration<Justification, SQLException>)this.listJustificationsBySupporting(triple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteJustifications() throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement deleteJustification = this.getPreparedStatement("justifications.delete_all");
        PreparedStatement deleteJustificationRules = this.getPreparedStatement("justifications.delete_all_rules");
        PreparedStatement deleteJustificationTriples = this.getPreparedStatement("justifications.delete_all_triples");
        PreparedStatement preparedStatement = deleteJustification;
        synchronized (preparedStatement) {
            deleteJustificationRules.executeUpdate();
            deleteJustificationTriples.executeUpdate();
            deleteJustification.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<Justification, SQLException> listJustificationsBySupporting(Rule rule) throws SQLException {
        PreparedStatement listByRule;
        if (rule.getId() == null) {
            return new EmptyIteration();
        }
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = listByRule = this.getPreparedStatement("justifications.load_by_srule");
        synchronized (preparedStatement) {
            listByRule.setLong(1, rule.getId());
            ResultSet result = listByRule.executeQuery();
            return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<Justification>(){

                public Justification apply(ResultSet row) throws SQLException {
                    return KiWiReasoningConnection.this.constructJustificationFromDatabase(row);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<Justification, SQLException> listJustificationsBySupporting(KiWiTriple triple) throws SQLException {
        PreparedStatement listByTriple;
        if (triple.getId() == null) {
            return new EmptyIteration();
        }
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = listByTriple = this.getPreparedStatement("justifications.load_by_striple");
        synchronized (preparedStatement) {
            listByTriple.setLong(1, triple.getId());
            ResultSet result = listByTriple.executeQuery();
            return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<Justification>(){

                public Justification apply(ResultSet row) throws SQLException {
                    return KiWiReasoningConnection.this.constructJustificationFromDatabase(row);
                }
            });
        }
    }

    public CloseableIteration<Justification, SQLException> listJustificationsForTriple(KiWiTriple triple) throws SQLException {
        if (triple.getId() == null) {
            return new EmptyIteration();
        }
        return this.listJustificationsForTriple(triple.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<Justification, SQLException> listJustificationsForTriple(long tripleId) throws SQLException {
        PreparedStatement listForTriple;
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = listForTriple = this.getPreparedStatement("justifications.load_by_triple");
        synchronized (preparedStatement) {
            listForTriple.setLong(1, tripleId);
            ResultSet result = listForTriple.executeQuery();
            return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<Justification>(){

                public Justification apply(ResultSet row) throws SQLException {
                    return KiWiReasoningConnection.this.constructJustificationFromDatabase(row);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Justification constructJustificationFromDatabase(ResultSet row) throws SQLException {
        PreparedStatement loadTriples;
        PreparedStatement loadRules;
        Justification result = new Justification();
        result.setId(row.getLong("id"));
        result.setTriple(this.loadTripleById(row.getLong("triple_id")));
        result.setCreatedAt(new Date(row.getTimestamp("createdAt").getTime()));
        PreparedStatement preparedStatement = loadRules = this.getPreparedStatement("justifications.load_rules");
        synchronized (preparedStatement) {
            loadRules.setLong(1, result.getId());
            ResultSet ruleResult = loadRules.executeQuery();
            while (ruleResult.next()) {
                result.getSupportingRules().add(this.loadRuleById(ruleResult.getLong("rule_id"), null));
            }
            ruleResult.close();
        }
        PreparedStatement preparedStatement2 = loadTriples = this.getPreparedStatement("justifications.load_triples");
        synchronized (preparedStatement2) {
            loadTriples.setLong(1, result.getId());
            ResultSet tripleResult = loadTriples.executeQuery();
            while (tripleResult.next()) {
                result.getSupportingTriples().add(this.loadTripleById(tripleResult.getLong("triple_id")));
            }
            tripleResult.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<KiWiTriple, SQLException> listUnsupportedTriples() throws SQLException {
        PreparedStatement listUnsupported;
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = listUnsupported = this.getPreparedStatement("justifications.list_unsupported");
        synchronized (preparedStatement) {
            ResultSet result = listUnsupported.executeQuery();
            return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<KiWiTriple>(){

                public KiWiTriple apply(ResultSet row) throws SQLException {
                    return KiWiReasoningConnection.this.constructTripleFromDatabase(row);
                }
            });
        }
    }

    public CloseableIteration<QueryResult, SQLException> query(final Collection<Pattern> patterns, final QueryResult initialBindings, Set<Filter> filters, List<VariableField> orderBy, final boolean justifications) throws SQLException {
        List vNames;
        String pName;
        String pName2;
        this.requireJDBCConnection();
        if (filters != null) {
            throw new IllegalArgumentException("filters are not yet supported by the QueryService");
        }
        String[] positions = new String[]{"subject", "predicate", "object", "context"};
        int patternCount = 0;
        final HashMap<Pattern, String> patternNames = new HashMap<Pattern, String>();
        for (Pattern p : patterns) {
            patternNames.put(p, "P" + ++patternCount);
        }
        int variableCount = 0;
        final HashMap<VariableField, String> variableNames = new HashMap<VariableField, String>();
        HashMap queryVariables = new HashMap();
        for (Pattern p : patterns) {
            Field[] fields = new Field[]{p.getSubject(), p.getProperty(), p.getObject(), p.getContext()};
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i] == null || !fields[i].isVariableField()) continue;
                VariableField v = (VariableField)fields[i];
                if (variableNames.get(v) == null) {
                    variableNames.put(v, "V" + ++variableCount);
                    queryVariables.put(v, new LinkedList());
                }
                pName2 = (String)patternNames.get(p);
                String vName = (String)variableNames.get(v);
                ((List)queryVariables.get(v)).add(pName2 + "_" + positions[i] + "_" + vName);
            }
        }
        StringBuilder selectClause = new StringBuilder();
        final LinkedList<VariableField> selectVariables = new LinkedList<VariableField>();
        Iterator<Object> it = queryVariables.keySet().iterator();
        while (it.hasNext()) {
            VariableField v = (VariableField)it.next();
            String projectedName = (String)variableNames.get(v);
            String fromName = (String)((List)queryVariables.get(v)).get(0);
            selectClause.append(fromName);
            selectClause.append(".id as ");
            selectClause.append(projectedName);
            if (it.hasNext()) {
                selectClause.append(", ");
            }
            selectVariables.add(v);
        }
        if (justifications) {
            for (Pattern p : patterns) {
                if (selectClause.length() > 0) {
                    selectClause.append(", ");
                }
                selectClause.append((String)patternNames.get(p));
                selectClause.append(".id as ");
                selectClause.append((String)patternNames.get(p));
            }
        }
        StringBuilder fromClause = new StringBuilder();
        Iterator<Pattern> it2 = patterns.iterator();
        while (it2.hasNext()) {
            Pattern p = it2.next();
            pName2 = (String)patternNames.get(p);
            fromClause.append("triples " + pName2);
            Field[] fields = new Field[]{p.getSubject(), p.getProperty(), p.getObject(), p.getContext()};
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i] == null || !fields[i].isVariableField()) continue;
                String vName = (String)variableNames.get(fields[i]);
                fromClause.append(" INNER JOIN nodes AS ");
                fromClause.append(pName2 + "_" + positions[i] + "_" + vName);
                fromClause.append(" ON " + pName2 + "." + positions[i] + " = ");
                fromClause.append(pName2 + "_" + positions[i] + "_" + vName + ".id ");
            }
            if (!it2.hasNext()) continue;
            fromClause.append(",\n ");
        }
        LinkedList<String> whereConditions = new LinkedList<String>();
        for (Pattern p : patterns) {
            pName = (String)patternNames.get(p);
            Field[] fields = new Field[]{p.getSubject(), p.getProperty(), p.getObject(), p.getContext()};
            for (int i = 0; i < fields.length; ++i) {
                Long nodeId = null;
                if (fields[i] != null && fields[i].isLiteralField()) {
                    nodeId = ((KiWiNode)((LiteralField)fields[i]).getLiteral()).getId();
                } else if (fields[i] != null && fields[i].isResourceField()) {
                    nodeId = ((KiWiNode)((ResourceField)fields[i]).getResource()).getId();
                }
                if (nodeId == null) continue;
                String condition = pName + "." + positions[i] + " = " + nodeId;
                whereConditions.add(condition);
            }
        }
        for (VariableField v : queryVariables.keySet()) {
            vNames = (List)queryVariables.get(v);
            for (int i = 1; i < vNames.size(); ++i) {
                String vName1 = (String)vNames.get(i - 1);
                String vName2 = (String)vNames.get(i);
                whereConditions.add(vName1 + ".id = " + vName2 + ".id");
            }
        }
        if (initialBindings != null) {
            for (VariableField v : initialBindings.getBindings().keySet()) {
                vNames = (List)queryVariables.get(v);
                if (vNames == null || vNames.size() <= 0) continue;
                String vName = (String)vNames.get(0);
                KiWiNode binding = initialBindings.getBindings().get(v);
                whereConditions.add(vName + ".id = " + binding.getId());
            }
        }
        for (Pattern p : patterns) {
            pName = (String)patternNames.get(p);
            whereConditions.add(pName + ".deleted = false");
        }
        StringBuilder whereClause = new StringBuilder();
        Iterator it3 = whereConditions.iterator();
        while (it3.hasNext()) {
            whereClause.append((String)it3.next());
            whereClause.append("\n ");
            if (!it3.hasNext()) continue;
            whereClause.append("AND ");
        }
        StringBuilder orderByClause = new StringBuilder();
        if (orderBy != null && orderBy.size() > 0) {
            Iterator<VariableField> it4 = orderBy.iterator();
            while (it4.hasNext()) {
                VariableField v = it4.next();
                String vName = (String)variableNames.get(v);
                orderByClause.append(vName);
                if (!it4.hasNext()) continue;
                orderByClause.append(", ");
            }
        }
        String queryString = "SELECT " + selectClause + "\n " + "FROM " + fromClause + "\n " + "WHERE " + whereClause + "\n " + (orderBy != null && orderBy.size() > 0 ? "ORDER BY " + orderByClause + " ASC\n " : "");
        log.debug("constructed SQL query string {}", (Object)queryString);
        PreparedStatement queryStatement = this.getJDBCConnection().prepareStatement(queryString);
        ResultSet result = queryStatement.executeQuery();
        return new ResultSetIteration(result, true, (ResultTransformerFunction)new ResultTransformerFunction<QueryResult>(){

            public QueryResult apply(ResultSet row) throws SQLException {
                QueryResult resultRow = new QueryResult();
                for (VariableField v : selectVariables) {
                    resultRow.getBindings().put(v, KiWiReasoningConnection.this.loadNodeById(row.getLong((String)variableNames.get(v))));
                }
                if (justifications) {
                    for (Pattern p : patterns) {
                        resultRow.getJustifications().add(KiWiReasoningConnection.this.loadTripleById(row.getLong((String)patternNames.get(p))));
                    }
                }
                if (initialBindings != null && initialBindings.getBindings().size() > 0) {
                    for (VariableField v : initialBindings.getBindings().keySet()) {
                        if (resultRow.getBindings().containsKey(v)) continue;
                        resultRow.getBindings().put(v, initialBindings.getBindings().get(v));
                    }
                    if (justifications) {
                        resultRow.getJustifications().addAll(initialBindings.getJustifications());
                    }
                }
                return resultRow;
            }
        });
    }
}

