/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.reasoner.parser;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.marmotta.kiwi.reasoner.model.program.Program;
import org.apache.marmotta.kiwi.reasoner.model.program.ResourceField;
import org.apache.marmotta.kiwi.reasoner.model.program.Rule;
import org.apache.marmotta.kiwi.reasoner.model.program.VariableField;
import org.apache.marmotta.kiwi.reasoner.parser.KWRLProgramParser;
import org.apache.marmotta.kiwi.reasoner.parser.ParseException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KWRLProgramParserBase {
    protected static final Logger log = LoggerFactory.getLogger(KWRLProgramParserBase.class);
    protected ValueFactory valueFactory;
    protected Map<String, VariableField> variables;
    protected Map<String, ResourceField> resources;
    protected Map<String, String> namespaces = new HashMap<String, String>();

    protected KWRLProgramParserBase() {
    }

    protected ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    protected void setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    protected void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public static Program parseProgram(String content, ValueFactory vf) throws ParseException {
        KWRLProgramParser parser = new KWRLProgramParser(vf, content);
        return parser.parseProgram();
    }

    public static Rule parseRule(String content, ValueFactory vf) throws ParseException {
        return KWRLProgramParserBase.parseRule(content, null, vf);
    }

    public static Rule parseRule(String content, Map<String, String> namespaces, ValueFactory vf) throws ParseException {
        KWRLProgramParser parser = new KWRLProgramParser(vf, content);
        if (namespaces != null) {
            parser.setNamespaces(namespaces);
        }
        return parser.parseRule();
    }

    public synchronized Program parseProgram() throws ParseException {
        return this.Program();
    }

    public synchronized Rule parseRule(Map<String, String> namespaces) throws ParseException {
        this.namespaces = namespaces;
        return this.Rule();
    }

    public synchronized Rule parseRule() throws ParseException {
        return this.Rule();
    }

    protected URI resolveResource(String uri) {
        return this.valueFactory.createURI(uri);
    }

    protected Literal resolveLiteral(Object content, Locale loc, String typeUri) {
        if (typeUri != null) {
            return this.valueFactory.createLiteral(content.toString(), this.valueFactory.createURI(typeUri));
        }
        if (loc != null) {
            return this.valueFactory.createLiteral(content.toString(), loc.getLanguage());
        }
        return this.valueFactory.createLiteral(content);
    }

    protected VariableField getVariable(String name) {
        if (this.variables != null && this.variables.get(name) != null) {
            return this.variables.get(name);
        }
        VariableField result = new VariableField(name);
        this.variables.put(name, result);
        return result;
    }

    protected ResourceField getResource(String uri) {
        if (this.resources != null && this.resources.get(uri) != null) {
            return this.resources.get(uri);
        }
        ResourceField result = new ResourceField((Resource)this.resolveResource(uri));
        this.resources.put(uri, result);
        return result;
    }

    protected ResourceField getResourceByNS(String nsUri) throws ParseException {
        String[] components = nsUri.split(":");
        if (this.namespaces.get(components[0]) == null) {
            throw new ParseException("namespace " + components[0] + " could not be found");
        }
        String uri = this.namespaces.get(components[0]) + components[1];
        return this.getResource(uri);
    }

    protected void startRule() {
        this.variables = new HashMap<String, VariableField>();
        this.resources = new HashMap<String, ResourceField>();
    }

    protected void endRule() {
        this.variables = null;
        this.resources = null;
    }

    public abstract Program Program() throws ParseException;

    public abstract Rule Rule() throws ParseException;
}

