/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.reasoner.model.program;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.marmotta.kiwi.reasoner.model.program.Pattern;

public class Rule {
    private Long id;
    private String name;
    private String description;
    private Pattern head;
    private List<Pattern> body;

    public Rule() {
    }

    public Rule(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Pattern getHead() {
        return this.head;
    }

    public void setHead(Pattern head) {
        this.head = head;
    }

    public List<Pattern> getBody() {
        return this.body;
    }

    public void setBody(List<Pattern> body) {
        this.body = body;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Iterator<Pattern> it = this.getBody().iterator();
        while (it.hasNext()) {
            s.append(it.next().toString());
            if (it.hasNext()) {
                s.append(", ");
                continue;
            }
            s.append(" ");
        }
        s.append("-> ");
        s.append(this.getHead().toString());
        return s.toString();
    }

    public String toString(Map<String, String> namespaces) {
        StringBuilder s = new StringBuilder();
        Iterator<Pattern> it = this.getBody().iterator();
        while (it.hasNext()) {
            s.append(it.next().toString(namespaces));
            if (it.hasNext()) {
                s.append(", ");
                continue;
            }
            s.append(" ");
        }
        s.append("-> ");
        s.append(this.getHead().toString(namespaces));
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        if (this.id != null) {
            return rule.id != null && this.id.equals(rule.id);
        }
        if (this.head != null ? !this.head.equals(rule.head) : rule.head != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(rule.name) : rule.name != null) {
            return false;
        }
        if (this.getBody() != null && rule.getBody() != null) {
            HashSet<Pattern> s1 = new HashSet<Pattern>(this.getBody());
            HashSet<Pattern> s2 = new HashSet<Pattern>(rule.getBody());
            return s1.equals(s2);
        }
        return this.getBody() == null && rule.getBody() == null;
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode() * 37;
        }
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.head != null ? this.head.hashCode() : 0);
        result = 31 * result;
        if (this.getBody() != null) {
            for (Pattern pattern : this.getBody()) {
                result += pattern.hashCode();
            }
        }
        return result;
    }
}

