/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.reasoner.model.program;

import java.util.Map;
import org.apache.marmotta.kiwi.reasoner.model.program.Field;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class ResourceField
implements Field {
    private Resource resource;

    public ResourceField(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Map<String, String> namespaces) {
        if (this.getResource() instanceof URI) {
            String uri = this.getResource().stringValue();
            if (namespaces != null) {
                for (Map.Entry<String, String> ns : namespaces.entrySet()) {
                    if (!uri.startsWith(ns.getValue())) continue;
                    return ns.getKey() + ":" + uri.substring(ns.getValue().length());
                }
            }
            return "<" + uri + ">";
        }
        if (this.getResource() instanceof BNode) {
            return "_:" + this.getResource().stringValue();
        }
        return null;
    }

    @Override
    public boolean isResourceField() {
        return true;
    }

    @Override
    public boolean isLiteralField() {
        return false;
    }

    @Override
    public boolean isVariableField() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceField that = (ResourceField)o;
        return !(this.resource != null ? !this.resource.equals(that.resource) : that.resource != null);
    }

    public int hashCode() {
        return this.resource != null ? this.resource.hashCode() : 0;
    }
}

