/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.reasoner.model.program;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.marmotta.kiwi.reasoner.model.program.Rule;

public class Program {
    private Long id;
    private String name;
    private String description;
    private Map<String, String> namespaces;
    private List<Rule> rules = new ArrayList<Rule>();

    public Program() {
        this.namespaces = new HashMap<String, String>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public void addNamespace(String prefix, String uri) {
        this.getNamespaces().put(prefix, uri);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public void addRule(Rule rule) {
        this.getRules().add(rule);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> ns : this.getNamespaces().entrySet()) {
            builder.append("@prefix ");
            builder.append(ns.getKey());
            builder.append(": <");
            builder.append(ns.getValue());
            builder.append(">\n");
        }
        if (this.getNamespaces().size() > 0) {
            builder.append("\n");
        }
        for (Rule rule : this.getRules()) {
            builder.append(rule.toString(this.getNamespaces()));
            builder.append("\n");
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Program program = (Program)o;
        if (this.description != null ? !this.description.equals(program.description) : program.description != null) {
            return false;
        }
        if (!this.name.equals(program.name)) {
            return false;
        }
        if (!((Object)this.namespaces).equals(program.namespaces)) {
            return false;
        }
        return ((Object)this.rules).equals(program.rules);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + ((Object)this.namespaces).hashCode();
        result = 31 * result + ((Object)this.rules).hashCode();
        return result;
    }
}

