/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.reasoner.engine;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iterations;
import info.aduna.iteration.SingletonIteration;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.marmotta.kiwi.model.caching.TripleTable;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.apache.marmotta.kiwi.reasoner.engine.ReasoningConfiguration;
import org.apache.marmotta.kiwi.reasoner.model.program.Justification;
import org.apache.marmotta.kiwi.reasoner.model.program.LiteralField;
import org.apache.marmotta.kiwi.reasoner.model.program.Pattern;
import org.apache.marmotta.kiwi.reasoner.model.program.Program;
import org.apache.marmotta.kiwi.reasoner.model.program.ResourceField;
import org.apache.marmotta.kiwi.reasoner.model.program.Rule;
import org.apache.marmotta.kiwi.reasoner.model.program.VariableField;
import org.apache.marmotta.kiwi.reasoner.model.query.QueryResult;
import org.apache.marmotta.kiwi.reasoner.persistence.KiWiReasoningConnection;
import org.apache.marmotta.kiwi.reasoner.persistence.KiWiReasoningPersistence;
import org.apache.marmotta.kiwi.sail.KiWiSailConnection;
import org.apache.marmotta.kiwi.transactions.api.TransactionListener;
import org.apache.marmotta.kiwi.transactions.api.TransactionalSail;
import org.apache.marmotta.kiwi.transactions.model.TransactionData;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReasoningEngine
implements TransactionListener {
    private static Logger log = LoggerFactory.getLogger(ReasoningEngine.class);
    private static final String TASK_GROUP = "Reasoner";
    private LinkedBlockingQueue<TransactionData> reasoningQueue;
    private KiWiReasoningPersistence persistence;
    private TransactionalSail store;
    private ReasoningConfiguration config;
    private List<Program> programs;
    private Map<Pattern, Rule> patternRuleMap;
    private static long taskCounter = 0L;
    private SKWRLReasoner reasonerThread;
    private Lock persistenceLock;
    private static int indexerCounter = 0;

    public ReasoningEngine(KiWiReasoningPersistence persistence, TransactionalSail store, ReasoningConfiguration config) {
        this.persistence = persistence;
        this.store = store;
        this.config = config;
        this.persistenceLock = new ReentrantLock();
        this.loadPrograms();
        this.reasoningQueue = new LinkedBlockingQueue();
        this.reasonerThread = new SKWRLReasoner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPrograms() {
        log.info("program configuration changed, reloading ...");
        this.patternRuleMap = new HashMap<Pattern, Rule>();
        try {
            KiWiReasoningConnection connection = this.persistence.getConnection();
            try {
                this.programs = Iterations.asList(connection.listPrograms());
                for (Program p : this.programs) {
                    for (Rule rule : p.getRules()) {
                        for (Pattern pattern : rule.getBody()) {
                            this.patternRuleMap.put(pattern, rule);
                        }
                    }
                }
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException ex) {
            this.programs = Collections.emptyList();
            log.warn("cannot load reasoning programs, reasoning disabled (error message: {})", (Object)ex.getMessage());
        }
    }

    public void programChanged(Program program) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddRule(Rule rule) {
        this.startTask("Addition of rule " + rule.getName(), TASK_GROUP);
        log.debug("processing new rule: {}", (Object)rule);
        try {
            this.updateTaskStatus("processing new rule ...");
            this.processRule(rule, null, null);
        }
        catch (Exception ex) {
            log.error("error while processing rule", (Throwable)ex);
            return;
        }
        finally {
            this.endTask();
        }
    }

    public void notifyRemoveRules() {
        this.startTask("Removing Rules", TASK_GROUP);
        this.updateTaskStatus("cleaning up unsupported triples");
        try {
            KiWiReasoningConnection connection = this.persistence.getConnection();
            try {
                this.cleanupUnsupported(connection);
            }
            catch (SQLException ex) {
                connection.rollback();
                throw ex;
            }
            finally {
                connection.close();
            }
        }
        catch (SailException ex) {
            log.error("REPOSITORY ERROR: could not clean up unsupported triples, database state will be inconsistent! Message: {}", (Object)ex.getMessage());
            log.debug("Exception details:", (Throwable)ex);
        }
        catch (SQLException ex) {
            log.error("DATABASE ERROR: could not clean up justifications for triples, database state will be inconsistent! Message: {}", (Object)ex.getMessage());
            log.debug("Exception details:", (Throwable)ex);
        }
        this.endTask();
    }

    public void afterCommit(TransactionData data) {
        if ((data.getAddedTriples().size() > 0 || data.getRemovedTriples().size() > 0) && this.patternRuleMap.size() > 0) {
            this.reasoningQueue.remove(data);
            if (!this.reasoningQueue.offer(data)) {
                log.info("waiting for reasoning queue to become available ...");
                try {
                    this.reasoningQueue.put(data);
                    log.info("reasoning queue available, added data");
                }
                catch (InterruptedException e) {
                    log.error("interrupted while waiting for reasoning queue to become available ...");
                }
            }
        }
    }

    public void beforeCommit(TransactionData data) {
    }

    public void rollback(TransactionData data) {
    }

    protected void startTask(String name, String taskGroup) {
    }

    protected void endTask() {
    }

    protected void updateTaskStatus(String message) {
    }

    protected void updateTaskProgress(int progress) {
    }

    protected void updateTaskMaxProgress(int progress) {
    }

    private void executeReasoner(TransactionData data) {
        this.updateTaskStatus("fetching worklist");
        HashSet<KiWiTriple> newTriples = new HashSet<KiWiTriple>();
        for (Statement stmt : data.getAddedTriples()) {
            KiWiTriple t = (KiWiTriple)stmt;
            if (!t.isMarkedForReasoning().booleanValue()) continue;
            newTriples.add(t);
            t.setMarkedForReasoning(Boolean.valueOf(false));
        }
        if (newTriples.size() > 0) {
            long start2 = System.currentTimeMillis();
            this.updateTaskStatus("reasoning over " + newTriples.size() + " new triples");
            this.processRules(newTriples);
            log.debug("REASONER: reasoning for {} new triples took {} ms overall", (Object)newTriples.size(), (Object)(System.currentTimeMillis() - start2));
        }
        if (data.getRemovedTriples().size() > 0) {
            log.debug("cleaning up justifications and inferences for {} triples", (Object)data.getRemovedTriples().size());
            try {
                KiWiReasoningConnection connection = this.persistence.getConnection();
                try {
                    this.cleanupJustifications(connection, (TripleTable<Statement>)data.getRemovedTriples());
                    this.cleanupUnsupported(connection);
                    connection.commit();
                }
                catch (SQLException ex) {
                    connection.rollback();
                    throw ex;
                }
                finally {
                    connection.close();
                }
            }
            catch (SailException ex) {
                log.error("REPOSITORY ERROR: could not clean up unsupported triples, database state will be inconsistent! Message: {}", (Object)ex.getMessage());
                log.debug("Exception details:", (Throwable)ex);
            }
            catch (SQLException ex) {
                log.error("DATABASE ERROR: could not clean up justifications for triples, database state will be inconsistent! Message: {}", (Object)ex.getMessage());
                log.debug("Exception details:", (Throwable)ex);
            }
        }
    }

    public void reRunPrograms() {
        String taskName = "Reasoner Task " + ++taskCounter + " (full reasoning)";
        this.startTask("Synchronous " + taskName, TASK_GROUP);
        this.executeReasoner();
        this.endTask();
    }

    private void executeReasoner() {
        this.updateTaskStatus("removing old justifications");
        try {
            KiWiReasoningConnection connection = this.persistence.getConnection();
            try {
                connection.deleteJustifications();
                this.cleanupUnsupported(connection);
                connection.commit();
            }
            catch (SQLException ex) {
                connection.rollback();
                throw ex;
            }
            finally {
                connection.close();
            }
        }
        catch (SailException ex) {
            log.error("REPOSITORY ERROR: could not clean up unsupported triples, database state will be inconsistent! Message: {}", (Object)ex.getMessage());
            log.debug("Exception details:", (Throwable)ex);
        }
        catch (SQLException ex) {
            log.error("DATABASE ERROR: could not clean up justifications for triples, database state will be inconsistent! Message: {}", (Object)ex.getMessage());
            log.debug("Exception details:", (Throwable)ex);
        }
        try {
            this.updateTaskStatus("processing rules ...");
            for (Program p : this.programs) {
                for (Rule rule : p.getRules()) {
                    this.startTask("Rule Processing", TASK_GROUP);
                    this.updateTaskStatus("processing rule " + rule.getName() + " ...");
                    this.processRule(rule, null, null);
                    this.endTask();
                }
            }
        }
        catch (Exception ex) {
            log.error("error while processing rules", (Throwable)ex);
            return;
        }
    }

    private void storeJustifications(Iterable<Justification> justifications) {
        long counter = 0L;
        this.updateTaskStatus("storing new justifications ...");
        try {
            KiWiReasoningConnection connection = this.persistence.getConnection();
            try {
                connection.storeJustifications(justifications);
                connection.commit();
            }
            catch (SQLException ex) {
                connection.rollback();
                throw ex;
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException ex) {
            log.error("DATABASE ERROR: could not add new justifications for triples, database state will be inconsistent! Message: {}", (Object)ex.getMessage());
            log.debug("Exception details:", (Throwable)ex);
        }
    }

    private void cleanupJustifications(KiWiReasoningConnection connection, TripleTable<Statement> removedTriples) throws SQLException {
        this.updateTaskStatus("cleaning up justifications for " + removedTriples.size() + " removed triples");
        for (Statement stmt : removedTriples) {
            KiWiTriple t = (KiWiTriple)stmt;
            connection.deleteJustifications(t);
        }
    }

    private void cleanupUnsupported(KiWiReasoningConnection connection) throws SQLException, SailException {
        this.updateTaskStatus("cleaning up unsupported triples");
        int count = 0;
        boolean total = false;
        this.startTask("Unsupported Triple Cleaner", TASK_GROUP);
        this.updateTaskStatus("loading unsupported triples");
        CloseableIteration<KiWiTriple, SQLException> tripleIterator = connection.listUnsupportedTriples();
        this.updateTaskStatus("deleting unsupported triples");
        NotifyingSailConnection tc = this.store.getConnection();
        KiWiSailConnection ic = this.getWrappedConnection((SailConnection)tc);
        try {
            tc.begin();
            while (tripleIterator.hasNext()) {
                ic.removeInferredStatement((KiWiTriple)tripleIterator.next());
                ++count;
            }
            log.debug("removed {} unsupported triples", (Object)count);
            tc.commit();
        }
        catch (SailException ex) {
            ic.rollback();
            throw ex;
        }
        finally {
            Iterations.closeCloseable(tripleIterator);
            ic.close();
        }
    }

    private void processRules(Set<KiWiTriple> addedTriples) {
        try {
            this.updateTaskStatus("processing rules ...");
            for (Pattern pattern : this.patternRuleMap.keySet()) {
                for (KiWiTriple triple : addedTriples) {
                    QueryResult match = this.matches(pattern, triple);
                    if (match == null) continue;
                    log.debug("pattern {} matched with triple {}", (Object)pattern.toString(), (Object)triple.toString());
                    this.processRule(this.patternRuleMap.get(pattern), match, pattern);
                }
            }
        }
        catch (Exception ex) {
            log.error("error while processing rules", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRule(Rule rule, QueryResult match, Pattern p) {
        log.debug("REASONER: evaluating rule body for rule {} ...", (Object)rule);
        HashSet<Pattern> body = new HashSet<Pattern>(rule.getBody());
        if (p != null) {
            body.remove(p);
        }
        try {
            KiWiReasoningConnection connection = this.persistence.getConnection();
            NotifyingSailConnection sail = this.store.getConnection();
            KiWiSailConnection isail = this.getWrappedConnection((SailConnection)sail);
            try {
                Object bodyResult = body.size() > 0 ? connection.query(body, match, null, null, true) : (match != null ? new SingletonIteration((Object)match) : new CloseableIteration<QueryResult, SQLException>());
                long counter = 0L;
                HashSet<Justification> justifications = new HashSet<Justification>();
                sail.begin();
                while (bodyResult.hasNext()) {
                    Value object;
                    QueryResult row = (QueryResult)bodyResult.next();
                    Map<VariableField, KiWiNode> binding = row.getBindings();
                    Resource subject = null;
                    KiWiUriResource property = null;
                    if (rule.getHead().getSubject() != null && rule.getHead().getSubject().isVariableField()) {
                        if (!binding.get(rule.getHead().getSubject()).isUriResource() && !binding.get(rule.getHead().getSubject()).isAnonymousResource()) {
                            log.info("cannot use value {} as subject, because it is not a resource", (Object)binding.get(rule.getHead().getSubject()));
                            continue;
                        }
                        subject = (KiWiResource)binding.get(rule.getHead().getSubject());
                    } else if (rule.getHead().getSubject() != null && rule.getHead().getSubject().isResourceField()) {
                        subject = ((ResourceField)rule.getHead().getSubject()).getResource();
                    } else {
                        throw new IllegalArgumentException("Subject of rule head may only be a variable or a resource; rule: " + rule);
                    }
                    if (rule.getHead().getProperty() != null && rule.getHead().getProperty().isVariableField()) {
                        if (!binding.get(rule.getHead().getProperty()).isUriResource()) {
                            log.info("cannot use value {} as property, because it is not a URI resource", (Object)binding.get(rule.getHead().getProperty()));
                            continue;
                        }
                        property = (KiWiUriResource)binding.get(rule.getHead().getProperty());
                    } else if (rule.getHead().getProperty() != null && rule.getHead().getProperty().isResourceField()) {
                        property = (KiWiUriResource)((ResourceField)rule.getHead().getProperty()).getResource();
                    } else {
                        throw new IllegalArgumentException("Property of rule head may only be a variable or a resource; rule: " + rule);
                    }
                    if (rule.getHead().getObject() != null && rule.getHead().getObject().isVariableField()) {
                        object = (Value)binding.get(rule.getHead().getObject());
                    } else if (rule.getHead().getObject() != null && rule.getHead().getObject().isResourceField()) {
                        object = ((ResourceField)rule.getHead().getObject()).getResource();
                    } else if (rule.getHead().getObject() != null && rule.getHead().getObject().isLiteralField()) {
                        object = ((LiteralField)rule.getHead().getObject()).getLiteral();
                    } else {
                        throw new IllegalArgumentException("Object of rule head may only be a variable, a literal, or a resource; rule: " + rule);
                    }
                    KiWiTriple triple = isail.addInferredStatement(subject, (URI)property, object);
                    Justification justification = new Justification();
                    justification.setTriple(triple);
                    justification.getSupportingRules().add(rule);
                    justification.getSupportingTriples().addAll(row.getJustifications());
                    justifications.add(justification);
                    if (++counter % (long)this.config.getBatchSize() != 0L) continue;
                    this.persistenceLock.lock();
                    try {
                        sail.commit();
                        log.debug("adding {} justifications", (Object)justifications.size());
                        this.updateTaskStatus("storing justifications ...");
                        Set<Justification> baseJustifications = this.getBaseJustifications(connection, justifications);
                        if (this.config.isRemoveDuplicateJustifications()) {
                            this.removeDuplicateJustifications(connection, baseJustifications);
                        }
                        log.debug("{} justifications added after resolving inferred triples", (Object)baseJustifications.size());
                        if (baseJustifications.size() > 0) {
                            connection.storeJustifications(baseJustifications);
                        }
                        connection.commit();
                        sail.begin();
                    }
                    finally {
                        this.persistenceLock.unlock();
                    }
                    justifications.clear();
                }
                this.persistenceLock.lock();
                try {
                    sail.commit();
                    log.debug("adding {} justifications", (Object)justifications.size());
                    this.updateTaskStatus("storing justifications ...");
                    Set<Justification> baseJustifications = this.getBaseJustifications(connection, justifications);
                    if (this.config.isRemoveDuplicateJustifications()) {
                        this.removeDuplicateJustifications(connection, baseJustifications);
                    }
                    if (baseJustifications.size() > 0) {
                        connection.storeJustifications(baseJustifications);
                    }
                    log.debug("{} justifications added after resolving inferred triples", (Object)baseJustifications.size());
                    Iterations.closeCloseable(bodyResult);
                    connection.commit();
                }
                finally {
                    this.persistenceLock.unlock();
                }
            }
            catch (SailException ex) {
                connection.rollback();
                sail.rollback();
                throw ex;
            }
            catch (SQLException ex) {
                sail.rollback();
                connection.rollback();
                throw ex;
            }
            finally {
                connection.close();
                sail.close();
            }
        }
        catch (SQLException ex) {
            log.error("DATABASE ERROR: could not process rule, database state will be inconsistent! Message: {}", (Object)ex.getMessage());
            log.debug("Exception details:", (Throwable)ex);
        }
        catch (SailException ex) {
            log.error("REPOSITORY ERROR: could not process rule, database state will be inconsistent! Message: {}", (Object)ex.getMessage());
            log.debug("Exception details:", (Throwable)ex);
        }
    }

    private Collection<Justification> getJustifications(KiWiReasoningConnection connection, KiWiTriple t, Set<Justification> transactionJustifications) throws SQLException {
        HashSet<Justification> justifications = new HashSet<Justification>();
        Iterations.addAll(connection.listJustificationsForTriple(t), justifications);
        for (Justification j : transactionJustifications) {
            if (!j.getTriple().equals((Object)t)) continue;
            justifications.add(j);
        }
        return justifications;
    }

    private Set<Justification> getBaseJustifications(KiWiReasoningConnection connection, Set<Justification> justifications) throws SQLException {
        HashSet<Justification> baseJustifications = new HashSet<Justification>();
        HashMap<KiWiTriple, Collection<Justification>> justificationCache = new HashMap<KiWiTriple, Collection<Justification>>();
        for (Justification justification : justifications) {
            KiWiTriple triple = justification.getTriple();
            Justification newJustification = new Justification();
            newJustification.setSupportingRules(justification.getSupportingRules());
            newJustification.setTriple(triple);
            Set<Justification> tripleJustifications = Collections.singleton(newJustification);
            for (KiWiTriple support : justification.getSupportingTriples()) {
                if (support.isInferred()) {
                    Collection<Justification> supportJustifications = (Collection<Justification>)justificationCache.get(support);
                    if (supportJustifications == null || supportJustifications.size() == 0) {
                        supportJustifications = this.getJustifications(connection, support, baseJustifications);
                        justificationCache.put(support, supportJustifications);
                    }
                    if (supportJustifications.size() == 0) {
                        log.error("error: inferred triple {} is not justified!", (Object)support);
                    }
                    Set<Justification> oldTripleJustifications = tripleJustifications;
                    tripleJustifications = new HashSet<Justification>();
                    for (Justification j1 : oldTripleJustifications) {
                        for (Justification j2 : supportJustifications) {
                            Justification j3 = new Justification();
                            j3.setTriple(triple);
                            j3.getSupportingTriples().addAll(j1.getSupportingTriples());
                            j3.getSupportingTriples().addAll(j2.getSupportingTriples());
                            j3.getSupportingRules().addAll(j1.getSupportingRules());
                            j3.getSupportingRules().addAll(j2.getSupportingRules());
                            tripleJustifications.add(j3);
                        }
                    }
                    continue;
                }
                for (Justification j : tripleJustifications) {
                    j.getSupportingTriples().add(support);
                }
            }
            baseJustifications.addAll(tripleJustifications);
        }
        return baseJustifications;
    }

    private void removeDuplicateJustifications(KiWiReasoningConnection connection, Set<Justification> justifications) throws SQLException {
        HashMap<KiWiTriple, Collection<Justification>> justificationCache = new HashMap<KiWiTriple, Collection<Justification>>();
        Iterator<Justification> it = justifications.iterator();
        while (it.hasNext()) {
            Justification j = it.next();
            Collection<Justification> supportJustifications = (Collection<Justification>)justificationCache.get(j.getTriple());
            if (supportJustifications == null) {
                supportJustifications = this.getJustifications(connection, j.getTriple(), Collections.<Justification>emptySet());
                justificationCache.put(j.getTriple(), supportJustifications);
            }
            if (!supportJustifications.contains(j)) continue;
            it.remove();
        }
    }

    private QueryResult matches(Pattern pattern, KiWiTriple triple) {
        KiWiNode binding;
        boolean result = true;
        QueryResult match = new QueryResult();
        if (pattern.getSubject().isResourceField()) {
            result = ((ResourceField)pattern.getSubject()).getResource().equals(triple.getSubject());
        } else if (pattern.getSubject().isVariableField()) {
            binding = match.getBindings().get(pattern.getSubject());
            if (binding != null) {
                result = binding.equals(triple.getSubject());
            } else {
                match.getBindings().put((VariableField)pattern.getSubject(), (KiWiNode)triple.getSubject());
            }
        }
        if (result && pattern.getProperty().isResourceField()) {
            result = ((ResourceField)pattern.getProperty()).getResource().equals(triple.getPredicate());
        } else if (result && pattern.getProperty().isVariableField()) {
            binding = match.getBindings().get(pattern.getProperty());
            if (binding != null) {
                result = binding.equals(triple.getPredicate());
            } else {
                match.getBindings().put((VariableField)pattern.getProperty(), (KiWiNode)triple.getPredicate());
            }
        }
        if (result && pattern.getContext() != null && pattern.getContext().isResourceField()) {
            result = ((ResourceField)pattern.getContext()).getResource().equals(triple.getContext());
        } else if (result && pattern.getContext() != null && pattern.getContext().isVariableField()) {
            binding = match.getBindings().get(pattern.getContext());
            if (binding != null) {
                result = binding.equals(triple.getContext());
            } else {
                match.getBindings().put((VariableField)pattern.getContext(), (KiWiNode)triple.getContext());
            }
        }
        if (result && pattern.getObject().isResourceField()) {
            result = ((ResourceField)pattern.getObject()).getResource().equals(triple.getObject());
        } else if (result && pattern.getObject().isLiteralField()) {
            result = ((LiteralField)pattern.getObject()).getLiteral().equals(triple.getObject());
        } else if (result && pattern.getObject().isVariableField()) {
            binding = match.getBindings().get(pattern.getObject());
            if (binding != null) {
                result = binding.equals(triple.getObject());
            } else {
                match.getBindings().put((VariableField)pattern.getObject(), triple.getObject());
            }
        }
        if (result) {
            match.getJustifications().add(triple);
            return match;
        }
        return null;
    }

    public boolean isRunning() {
        return this.reasonerThread.isRunning() || !this.reasoningQueue.isEmpty();
    }

    public void shutdown() {
        log.info("shutting down reasoning service ...");
        this.reasonerThread.shutdown();
    }

    private KiWiSailConnection getWrappedConnection(SailConnection connection) throws SailException {
        SailConnection it = connection;
        while (it instanceof SailConnectionWrapper) {
            if (!((it = ((SailConnectionWrapper)it).getWrappedConnection()) instanceof KiWiSailConnection)) continue;
            return (KiWiSailConnection)it;
        }
        throw new SailException("no underlying KiWiSailConnection found for connection");
    }

    private class SKWRLReasoner
    extends Thread {
        private boolean shutdown;
        private boolean running;

        private SKWRLReasoner() {
            super("SKWRL Reasoner " + ++indexerCounter);
            this.shutdown = false;
            this.running = false;
            this.setDaemon(true);
            this.start();
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        public boolean isRunning() {
            return this.running;
        }

        @Override
        public void run() {
            log.info("{} starting up ...", (Object)this.getName());
            ReasoningEngine.this.startTask(this.getName(), ReasoningEngine.TASK_GROUP);
            while (!this.shutdown || ReasoningEngine.this.reasoningQueue.size() > 0) {
                this.running = false;
                try {
                    ReasoningEngine.this.updateTaskStatus("idle");
                    TransactionData data = (TransactionData)ReasoningEngine.this.reasoningQueue.take();
                    this.running = true;
                    ReasoningEngine.this.updateTaskMaxProgress(ReasoningEngine.this.reasoningQueue.size());
                    ReasoningEngine.this.executeReasoner(data);
                }
                catch (InterruptedException ex) {
                }
                catch (Exception ex) {
                    log.warn("reasoning task threw an exception", (Throwable)ex);
                }
            }
            try {
                ReasoningEngine.this.endTask();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info("{} shutting down ...", (Object)this.getName());
        }
    }
}

