/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.rangetree.GrowingHeapSliceWriter;
import org.apache.lucene.rangetree.HeapSliceWriter;
import org.apache.lucene.rangetree.OfflineSliceWriter;
import org.apache.lucene.rangetree.SliceReader;
import org.apache.lucene.rangetree.SliceWriter;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.OfflineSorter;

class RangeTreeWriter {
    static final int BYTES_PER_DOC = 20;
    public static final int DEFAULT_MAX_VALUES_IN_LEAF_NODE = 1024;
    public static final int DEFAULT_MAX_VALUES_SORT_IN_HEAP = 131072;
    private final byte[] scratchBytes = new byte[20];
    private final ByteArrayDataOutput scratchBytesOutput = new ByteArrayDataOutput(this.scratchBytes);
    private OfflineSorter.ByteSequencesWriter writer;
    private GrowingHeapSliceWriter heapWriter;
    private Path tempInput;
    private final int maxValuesInLeafNode;
    private final int maxValuesSortInHeap;
    private long valueCount;
    private long globalMinValue = Long.MAX_VALUE;
    private long globalMaxValue = Long.MIN_VALUE;

    public RangeTreeWriter() throws IOException {
        this(1024, 131072);
    }

    public RangeTreeWriter(int maxValuesInLeafNode, int maxValuesSortInHeap) throws IOException {
        RangeTreeWriter.verifyParams(maxValuesInLeafNode, maxValuesSortInHeap);
        this.maxValuesInLeafNode = maxValuesInLeafNode;
        this.maxValuesSortInHeap = maxValuesSortInHeap;
        this.heapWriter = new GrowingHeapSliceWriter(maxValuesSortInHeap);
    }

    public static void verifyParams(int maxValuesInLeafNode, int maxValuesSortInHeap) {
        if (maxValuesInLeafNode <= 0) {
            throw new IllegalArgumentException("maxValuesInLeafNode must be > 0; got " + maxValuesInLeafNode);
        }
        if (maxValuesInLeafNode > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxValuesInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxValuesInLeafNode);
        }
        if (maxValuesSortInHeap < maxValuesInLeafNode) {
            throw new IllegalArgumentException("maxValuesSortInHeap must be >= maxValuesInLeafNode; got " + maxValuesSortInHeap + " vs maxValuesInLeafNode=" + maxValuesInLeafNode);
        }
        if (maxValuesSortInHeap > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxValuesSortInHeap must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxValuesSortInHeap);
        }
    }

    private void switchToOffline() throws IOException {
        this.tempInput = Files.createTempFile(OfflineSorter.getDefaultTempDir(), "in", "", new FileAttribute[0]);
        this.writer = new OfflineSorter.ByteSequencesWriter(this.tempInput);
        int i = 0;
        while ((long)i < this.valueCount) {
            this.scratchBytesOutput.reset(this.scratchBytes);
            this.scratchBytesOutput.writeLong(this.heapWriter.values[i]);
            this.scratchBytesOutput.writeVInt(this.heapWriter.docIDs[i]);
            this.scratchBytesOutput.writeVLong((long)i);
            this.writer.write(this.scratchBytes, 0, this.scratchBytes.length);
            ++i;
        }
        this.heapWriter = null;
    }

    void add(long value, int docID) throws IOException {
        if (this.valueCount >= (long)this.maxValuesSortInHeap) {
            if (this.writer == null) {
                this.switchToOffline();
            }
            this.scratchBytesOutput.reset(this.scratchBytes);
            this.scratchBytesOutput.writeLong(value);
            this.scratchBytesOutput.writeVInt(docID);
            this.scratchBytesOutput.writeVLong(this.valueCount);
            this.writer.write(this.scratchBytes, 0, this.scratchBytes.length);
        } else {
            this.heapWriter.append(value, this.valueCount, docID);
        }
        ++this.valueCount;
        this.globalMaxValue = Math.max(value, this.globalMaxValue);
        this.globalMinValue = Math.min(value, this.globalMinValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SliceWriter convertToFixedWidth(Path in) throws IOException {
        SliceWriter sortedWriter;
        block12: {
            OfflineSorter.ByteSequencesReader reader;
            block11: {
                BytesRefBuilder scratch = new BytesRefBuilder();
                scratch.grow(20);
                BytesRef bytes = scratch.get();
                ByteArrayDataInput dataReader = new ByteArrayDataInput();
                reader = null;
                sortedWriter = null;
                boolean success = false;
                try {
                    reader = new OfflineSorter.ByteSequencesReader(in);
                    sortedWriter = this.getWriter(this.valueCount);
                    for (long i = 0L; i < this.valueCount; ++i) {
                        boolean result = reader.read(scratch);
                        assert (result);
                        dataReader.reset(bytes.bytes, bytes.offset, bytes.length);
                        long value = dataReader.readLong();
                        int docID = dataReader.readVInt();
                        assert (docID >= 0) : "docID=" + docID;
                        long ord = dataReader.readVLong();
                        sortedWriter.append(value, ord, docID);
                    }
                    success = true;
                    if (!success) break block11;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{sortedWriter, reader});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{sortedWriter, reader});
                        try {
                            sortedWriter.destroy();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{sortedWriter, reader});
                break block12;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{sortedWriter, reader});
            try {
                sortedWriter.destroy();
            }
            catch (Throwable throwable) {}
        }
        return sortedWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SliceWriter sort() throws IOException {
        SliceWriter sliceWriter;
        block9: {
            Path sorted;
            block8: {
                if (this.heapWriter != null) {
                    assert (this.valueCount < Integer.MAX_VALUE);
                    new InPlaceMergeSorter(){

                        protected void swap(int i, int j) {
                            int docID = ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.docIDs[i];
                            ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.docIDs[i] = ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.docIDs[j];
                            ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.docIDs[j] = docID;
                            long ord = ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.ords[i];
                            ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.ords[i] = ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.ords[j];
                            ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.ords[j] = ord;
                            long value = ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.values[i];
                            ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.values[i] = ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.values[j];
                            ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.values[j] = value;
                        }

                        protected int compare(int i, int j) {
                            int cmp = Long.compare(((RangeTreeWriter)RangeTreeWriter.this).heapWriter.values[i], ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.values[j]);
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = Integer.compare(((RangeTreeWriter)RangeTreeWriter.this).heapWriter.docIDs[i], ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.docIDs[j]);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Long.compare(((RangeTreeWriter)RangeTreeWriter.this).heapWriter.ords[i], ((RangeTreeWriter)RangeTreeWriter.this).heapWriter.ords[j]);
                        }
                    }.sort(0, (int)this.valueCount);
                    HeapSliceWriter sorted2 = new HeapSliceWriter((int)this.valueCount);
                    int i = 0;
                    while ((long)i < this.valueCount) {
                        sorted2.append(this.heapWriter.values[i], this.heapWriter.ords[i], this.heapWriter.docIDs[i]);
                        ++i;
                    }
                    sorted2.close();
                    return sorted2;
                }
                assert (this.tempInput != null);
                final ByteArrayDataInput reader = new ByteArrayDataInput();
                Comparator<BytesRef> cmp = new Comparator<BytesRef>(){
                    private final ByteArrayDataInput readerB = new ByteArrayDataInput();

                    @Override
                    public int compare(BytesRef a, BytesRef b) {
                        reader.reset(a.bytes, a.offset, a.length);
                        long valueA = reader.readLong();
                        int docIDA = reader.readVInt();
                        long ordA = reader.readVLong();
                        reader.reset(b.bytes, b.offset, b.length);
                        long valueB = reader.readLong();
                        int docIDB = reader.readVInt();
                        long ordB = reader.readVLong();
                        int cmp = Long.compare(valueA, valueB);
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = Integer.compare(docIDA, docIDB);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return Long.compare(ordA, ordB);
                    }
                };
                sorted = Files.createTempFile(OfflineSorter.getDefaultTempDir(), "sorted", "", new FileAttribute[0]);
                boolean success = false;
                try {
                    OfflineSorter sorter = new OfflineSorter((Comparator)cmp);
                    sorter.sort(this.tempInput, sorted);
                    SliceWriter writer = this.convertToFixedWidth(sorted);
                    success = true;
                    sliceWriter = writer;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.rm((Path[])new Path[]{sorted});
                    } else {
                        IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{sorted});
                    }
                    throw throwable;
                }
                IOUtils.rm((Path[])new Path[]{sorted});
                break block9;
            }
            IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{sorted});
        }
        return sliceWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long finish(IndexOutput out) throws IOException {
        int i;
        long[] leafBlockFPs;
        long[] blockMinValues;
        int numLeaves;
        block16: {
            SliceWriter sortedWriter;
            block15: {
                if (this.writer != null) {
                    this.writer.close();
                }
                if (this.valueCount == 0L) {
                    throw new IllegalStateException("at least one value must be indexed");
                }
                long countPerLeaf = this.valueCount;
                long innerNodeCount = 1L;
                while (countPerLeaf > (long)this.maxValuesInLeafNode) {
                    countPerLeaf = (countPerLeaf + 1L) / 2L;
                    innerNodeCount *= 2L;
                }
                if (1L + 2L * innerNodeCount >= Integer.MAX_VALUE) {
                    throw new IllegalStateException("too many nodes; increase maxValuesInLeafNode (currently " + this.maxValuesInLeafNode + ") and reindex");
                }
                numLeaves = (int)(--innerNodeCount + 1L);
                blockMinValues = new long[numLeaves];
                leafBlockFPs = new long[numLeaves];
                assert (this.valueCount / (long)blockMinValues.length <= (long)this.maxValuesInLeafNode) : "valueCount=" + this.valueCount + " blockMinValues.length=" + blockMinValues.length + " maxValuesInLeafNode=" + this.maxValuesInLeafNode;
                sortedWriter = null;
                boolean success = false;
                try {
                    sortedWriter = this.sort();
                    this.heapWriter = null;
                    this.build(1, numLeaves, new PathSlice(sortedWriter, 0L, this.valueCount), out, this.globalMinValue, this.globalMaxValue, blockMinValues, leafBlockFPs);
                    success = true;
                    if (!success) break block15;
                }
                catch (Throwable throwable) {
                    if (success) {
                        sortedWriter.destroy();
                        IOUtils.rm((Path[])new Path[]{this.tempInput});
                    } else {
                        try {
                            sortedWriter.destroy();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{this.tempInput});
                    }
                    throw throwable;
                }
                sortedWriter.destroy();
                IOUtils.rm((Path[])new Path[]{this.tempInput});
                break block16;
            }
            try {
                sortedWriter.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{this.tempInput});
        }
        long indexFP = out.getFilePointer();
        out.writeVInt(numLeaves);
        out.writeVInt((int)(this.valueCount / (long)numLeaves));
        for (i = 0; i < blockMinValues.length; ++i) {
            out.writeLong(blockMinValues[i]);
        }
        for (i = 0; i < leafBlockFPs.length; ++i) {
            out.writeVLong(leafBlockFPs[i]);
        }
        out.writeLong(this.globalMaxValue);
        return indexFP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSplitValue(PathSlice source, long leftCount, long minValue, long maxValue) throws IOException {
        long splitValue;
        block7: {
            SliceReader reader;
            block6: {
                reader = source.writer.getReader(source.start + leftCount);
                boolean success = false;
                try {
                    boolean result = reader.next();
                    assert (result);
                    splitValue = reader.value();
                    assert (splitValue >= minValue && splitValue <= maxValue) : "splitValue=" + splitValue + " minValue=" + minValue + " maxValue=" + maxValue + " reader=" + reader;
                    success = true;
                    if (!success) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{reader});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{reader});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
        }
        return splitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(int nodeID, int leafNodeOffset, PathSlice source, IndexOutput out, long minValue, long maxValue, long[] blockMinValues, long[] leafBlockFPs) throws IOException {
        block21: {
            long count;
            block19: {
                int[] docIDs;
                block20: {
                    SliceReader reader;
                    block17: {
                        block18: {
                            count = source.count;
                            if (!(source.writer instanceof OfflineSliceWriter) || count > (long)this.maxValuesSortInHeap) break block18;
                            HeapSliceWriter writer = new HeapSliceWriter((int)count);
                            SliceReader reader2 = source.writer.getReader(source.start);
                            try {
                                int i = 0;
                                while ((long)i < count) {
                                    boolean hasNext = reader2.next();
                                    assert (hasNext);
                                    writer.append(reader2.value(), reader2.ord(), reader2.docID());
                                    ++i;
                                }
                            }
                            catch (Throwable throwable) {
                                IOUtils.close((Closeable[])new Closeable[]{reader2, writer});
                                throw throwable;
                            }
                            IOUtils.close((Closeable[])new Closeable[]{reader2, writer});
                            source = new PathSlice(writer, 0L, count);
                        }
                        assert (count > 0L);
                        if (nodeID < leafNodeOffset) break block19;
                        assert (maxValue >= minValue);
                        reader = source.writer.getReader(source.start);
                        docIDs = new int[(int)count];
                        boolean success = false;
                        try {
                            int i = 0;
                            while ((long)i < source.count) {
                                boolean result = reader.next();
                                assert (result);
                                docIDs[i] = reader.docID();
                                ++i;
                            }
                            success = true;
                            if (!success) break block17;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close((Closeable[])new Closeable[]{reader});
                            } else {
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                            }
                            throw throwable;
                        }
                        IOUtils.close((Closeable[])new Closeable[]{reader});
                        break block20;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                }
                Arrays.sort(docIDs);
                int lastDocID = -1;
                int uniqueCount = 0;
                for (int i = 0; i < docIDs.length; ++i) {
                    int docID = docIDs[i];
                    if (docID == lastDocID) continue;
                    ++uniqueCount;
                    lastDocID = docID;
                }
                assert ((long)uniqueCount <= count);
                long startFP = out.getFilePointer();
                out.writeVInt(uniqueCount);
                int blockID = nodeID - leafNodeOffset;
                leafBlockFPs[blockID] = startFP;
                blockMinValues[blockID] = minValue;
                lastDocID = -1;
                for (int i = 0; i < docIDs.length; ++i) {
                    int docID = docIDs[i];
                    if (docID == lastDocID) continue;
                    out.writeInt(docID);
                    lastDocID = docID;
                }
                break block21;
            }
            assert (nodeID < blockMinValues.length) : "nodeID=" + nodeID + " blockMinValues.length=" + blockMinValues.length;
            assert (source.count == count);
            long leftCount = source.count / 2L;
            long splitValue = this.getSplitValue(source, leftCount, minValue, maxValue);
            this.build(2 * nodeID, leafNodeOffset, new PathSlice(source.writer, source.start, leftCount), out, minValue, splitValue, blockMinValues, leafBlockFPs);
            this.build(2 * nodeID + 1, leafNodeOffset, new PathSlice(source.writer, source.start + leftCount, count - leftCount), out, splitValue, maxValue, blockMinValues, leafBlockFPs);
        }
    }

    SliceWriter getWriter(long count) throws IOException {
        if (count < (long)this.maxValuesSortInHeap) {
            return new HeapSliceWriter((int)count);
        }
        return new OfflineSliceWriter(count);
    }

    private static final class PathSlice {
        final SliceWriter writer;
        final long start;
        final long count;

        public PathSlice(SliceWriter writer, long start, long count) {
            this.writer = writer;
            this.start = start;
            this.count = count;
        }

        public String toString() {
            return "PathSlice(start=" + this.start + " count=" + this.count + " writer=" + this.writer + ")";
        }
    }
}

