/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortingMergePolicy;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class EarlyTerminatingSortingCollector
extends FilterCollector {
    protected final Sort sort;
    protected final int numDocsToCollect;
    private final Sort mergePolicySort;
    private final AtomicBoolean terminatedEarly = new AtomicBoolean(false);

    public static boolean canEarlyTerminate(Sort searchSort, Sort mergePolicySort) {
        SortField[] fields2;
        SortField[] fields1 = searchSort.getSort();
        if (fields1.length > (fields2 = mergePolicySort.getSort()).length) {
            return false;
        }
        return Arrays.asList(fields1).equals(Arrays.asList(fields2).subList(0, fields1.length));
    }

    public EarlyTerminatingSortingCollector(Collector in, Sort sort, int numDocsToCollect, Sort mergePolicySort) {
        super(in);
        if (numDocsToCollect <= 0) {
            throw new IllegalArgumentException("numDocsToCollect must always be > 0, got " + numDocsToCollect);
        }
        if (!EarlyTerminatingSortingCollector.canEarlyTerminate(sort, mergePolicySort)) {
            throw new IllegalStateException("Cannot early terminate with sort order " + sort + " if segments are sorted with " + mergePolicySort);
        }
        this.sort = sort;
        this.numDocsToCollect = numDocsToCollect;
        this.mergePolicySort = mergePolicySort;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        if (SortingMergePolicy.isSorted(context.reader(), this.mergePolicySort)) {
            return new FilterLeafCollector(super.getLeafCollector(context)){
                private int numCollected;

                public void collect(int doc) throws IOException {
                    super.collect(doc);
                    if (++this.numCollected >= EarlyTerminatingSortingCollector.this.numDocsToCollect) {
                        EarlyTerminatingSortingCollector.this.terminatedEarly.set(true);
                        throw new CollectionTerminatedException();
                    }
                }
            };
        }
        return super.getLeafCollector(context);
    }

    public boolean terminatedEarly() {
        return this.terminatedEarly.get();
    }
}

