/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.links.LinksProvider;
import org.apache.isis.viewer.wicket.model.mementos.ActionParameterMemento;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.mementos.SpecUtils;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModelWithPending;
import org.apache.wicket.Session;

public class ScalarModel
extends EntityModel
implements LinksProvider {
    private static final long serialVersionUID = 1L;
    private final Kind kind;
    private final ObjectAdapterMemento parentObjectAdapterMemento;
    private ActionParameterMemento parameterMemento;
    private PropertyMemento propertyMemento;
    private List<LinkAndLabel> entityActions = Lists.newArrayList();
    private transient ObjectAdapter[] actionArgsHint;

    public ScalarModel(ObjectAdapterMemento parentObjectAdapterMemento, ActionParameterMemento apm) {
        this.kind = Kind.PARAMETER;
        this.parentObjectAdapterMemento = parentObjectAdapterMemento;
        this.parameterMemento = apm;
        this.init();
        this.setMode(EntityModel.Mode.EDIT);
    }

    public ScalarModel(ObjectAdapterMemento parentObjectAdapterMemento, PropertyMemento pm) {
        this.kind = Kind.PROPERTY;
        this.parentObjectAdapterMemento = parentObjectAdapterMemento;
        this.propertyMemento = pm;
        this.init();
        this.setObject(parentObjectAdapterMemento);
        this.setMode(EntityModel.Mode.VIEW);
    }

    private void init() {
        this.kind.init(this);
    }

    public void reset() {
        this.kind.reset(this);
    }

    public ObjectAdapterMemento getParentObjectAdapterMemento() {
        return this.parentObjectAdapterMemento;
    }

    protected void setObject(ObjectAdapterMemento parentObjectAdapterMemento) {
        OneToOneAssociation property = this.propertyMemento.getProperty();
        ObjectAdapter associatedAdapter = property.get(parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK));
        this.setObject(associatedAdapter);
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.kind.getName(this);
    }

    public PropertyMemento getPropertyMemento() {
        return this.propertyMemento;
    }

    public ActionParameterMemento getParameterMemento() {
        return this.parameterMemento;
    }

    @Override
    public ObjectSpecification getTypeOfSpecification() {
        return this.kind.getScalarTypeSpec(this);
    }

    public boolean isScalarTypeAnyOf(Class<?> ... requiredClass) {
        String fullName = this.getTypeOfSpecification().getFullIdentifier();
        for (Class<?> requiredCls : requiredClass) {
            if (!fullName.equals(requiredCls.getName())) continue;
            return true;
        }
        return false;
    }

    public String getObjectAsString() {
        ObjectAdapter adapter = (ObjectAdapter)this.getObject();
        if (adapter == null) {
            return null;
        }
        return adapter.titleString(null);
    }

    @Override
    public void setObject(ObjectAdapter adapter) {
        super.setObject(adapter);
    }

    public void setObjectAsString(String enteredText) {
        ParseableFacet parseableFacet = (ParseableFacet)this.getTypeOfSpecification().getFacet(ParseableFacet.class);
        if (parseableFacet == null) {
            throw new RuntimeException("unable to parse string for " + this.getTypeOfSpecification().getFullIdentifier());
        }
        Localization localization = IsisContext.getLocalization();
        ObjectAdapter adapter = parseableFacet.parseTextEntry((ObjectAdapter)this.getObject(), enteredText, localization);
        this.setObject(adapter);
    }

    public String disable(Where where) {
        return this.kind.disable(this, where);
    }

    public String parseAndValidate(String proposedPojoAsStr) {
        return this.kind.parseAndValidate(this, proposedPojoAsStr);
    }

    public String validate(ObjectAdapter proposedAdapter) {
        return this.kind.validate(this, proposedAdapter);
    }

    @Override
    protected AuthenticationSession getAuthenticationSession() {
        return ((AuthenticationSessionProvider)Session.get()).getAuthenticationSession();
    }

    public boolean isRequired() {
        return this.kind.isRequired(this);
    }

    public String getLongName() {
        return this.kind.getLongName(this);
    }

    public <T extends Facet> T getFacet(Class<T> facetType) {
        return this.kind.getFacet(this, facetType);
    }

    public void resetVersion() {
        this.kind.resetVersion(this);
    }

    public String getDescribedAs() {
        return this.kind.getDescribedAs(this);
    }

    public boolean hasChoices() {
        return this.kind.hasChoices(this);
    }

    public List<ObjectAdapter> getChoices(ObjectAdapter[] argumentsIfAvailable, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        return this.kind.getChoices(this, argumentsIfAvailable, authenticationSession, deploymentCategory);
    }

    public boolean hasAutoComplete() {
        return this.kind.hasAutoComplete(this);
    }

    public List<ObjectAdapter> getAutoComplete(String searchTerm, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
        return this.kind.getAutoComplete(this, searchTerm, authenticationSession, deploymentCategory);
    }

    public int getLength() {
        return this.kind.getLength(this);
    }

    public Integer getScale() {
        return this.kind.getScale(this);
    }

    public int getTypicalLength() {
        return this.kind.getTypicalLength(this);
    }

    public void addEntityActions(List<LinkAndLabel> entityActions) {
        this.entityActions.addAll(entityActions);
    }

    @Override
    public List<LinkAndLabel> getLinks() {
        return Collections.unmodifiableList(this.entityActions);
    }

    public int getAutoCompleteMinLength() {
        return this.kind.getAutoCompleteOrChoicesMinLength(this);
    }

    public ScalarModelWithPending asScalarModelWithPending() {
        return new ScalarModelWithPending(){
            private static final long serialVersionUID = 1L;

            @Override
            public ObjectAdapterMemento getPending() {
                return ScalarModel.this.getPending();
            }

            @Override
            public void setPending(ObjectAdapterMemento pending) {
                ScalarModel.this.setPending(pending);
            }

            @Override
            public ScalarModel getScalarModel() {
                return ScalarModel.this;
            }
        };
    }

    public void setActionArgsHint(ObjectAdapter[] actionArgsHint) {
        this.actionArgsHint = actionArgsHint;
    }

    public ObjectAdapter[] getActionArgsHint() {
        return this.actionArgsHint;
    }

    public static enum Kind {
        PROPERTY{

            @Override
            public String getName(ScalarModel scalarModel) {
                return scalarModel.getPropertyMemento().getProperty().getName();
            }

            @Override
            public ObjectSpecification getScalarTypeSpec(ScalarModel scalarModel) {
                ObjectSpecId type = scalarModel.getPropertyMemento().getType();
                return SpecUtils.getSpecificationFor(type);
            }

            @Override
            public String getIdentifier(ScalarModel scalarModel) {
                return scalarModel.getPropertyMemento().getIdentifier();
            }

            @Override
            public String getLongName(ScalarModel scalarModel) {
                ObjectSpecId objectSpecId = scalarModel.parentObjectAdapterMemento.getObjectSpecId();
                String specShortName = SpecUtils.getSpecificationFor(objectSpecId).getShortIdentifier();
                return specShortName + "-" + scalarModel.getPropertyMemento().getProperty().getId();
            }

            @Override
            public String disable(ScalarModel scalarModel, Where where) {
                ObjectAdapter parentAdapter = scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK);
                OneToOneAssociation property = scalarModel.getPropertyMemento().getProperty();
                try {
                    AuthenticationSession session = scalarModel.getAuthenticationSession();
                    Consent usable = property.isUsable(session, parentAdapter, where);
                    return usable.isAllowed() ? null : usable.getReason();
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public String parseAndValidate(ScalarModel scalarModel, String proposedPojoAsStr) {
                OneToOneAssociation property = scalarModel.getPropertyMemento().getProperty();
                ParseableFacet parseableFacet = (ParseableFacet)property.getFacet(ParseableFacet.class);
                if (parseableFacet == null) {
                    parseableFacet = (ParseableFacet)property.getSpecification().getFacet(ParseableFacet.class);
                }
                try {
                    ObjectAdapter parentAdapter = scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK);
                    ObjectAdapter currentValue = property.get(parentAdapter);
                    Localization localization = IsisContext.getLocalization();
                    ObjectAdapter proposedAdapter = parseableFacet.parseTextEntry(currentValue, proposedPojoAsStr, localization);
                    Consent valid = property.isAssociationValid(parentAdapter, proposedAdapter);
                    return valid.isAllowed() ? null : valid.getReason();
                }
                catch (ConcurrencyException ex) {
                    return null;
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public String validate(ScalarModel scalarModel, ObjectAdapter proposedAdapter) {
                ObjectAdapter parentAdapter = scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK);
                OneToOneAssociation property = scalarModel.getPropertyMemento().getProperty();
                try {
                    Consent valid = property.isAssociationValid(parentAdapter, proposedAdapter);
                    return valid.isAllowed() ? null : valid.getReason();
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public boolean isRequired(ScalarModel scalarModel) {
                OneToOneAssociation facetHolder = scalarModel.getPropertyMemento().getProperty();
                return 1.isRequired((FacetHolder)facetHolder);
            }

            @Override
            public <T extends Facet> T getFacet(ScalarModel scalarModel, Class<T> facetType) {
                OneToOneAssociation facetHolder = scalarModel.getPropertyMemento().getProperty();
                return (T)facetHolder.getFacet(facetType);
            }

            @Override
            public boolean hasChoices(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty();
                return property.hasChoices();
            }

            @Override
            public List<ObjectAdapter> getChoices(ScalarModel scalarModel, ObjectAdapter[] argumentsIfAvailable, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty();
                ObjectAdapter[] choices = property.getChoices(scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK), authenticationSession, deploymentCategory);
                return Kind.choicesAsList(choices);
            }

            @Override
            public boolean hasAutoComplete(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty();
                return property.hasAutoComplete();
            }

            @Override
            public List<ObjectAdapter> getAutoComplete(ScalarModel scalarModel, String searchArg, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty();
                ObjectAdapter parentAdapter = scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
                ObjectAdapter[] choices = property.getAutoComplete(parentAdapter, searchArg, authenticationSession, deploymentCategory);
                return Kind.choicesAsList(choices);
            }

            @Override
            public int getAutoCompleteOrChoicesMinLength(ScalarModel scalarModel) {
                if (scalarModel.hasAutoComplete()) {
                    PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                    OneToOneAssociation property = propertyMemento.getProperty();
                    return property.getAutoCompleteMinLength();
                }
                return 0;
            }

            @Override
            public void resetVersion(ScalarModel scalarModel) {
                scalarModel.parentObjectAdapterMemento.resetVersion();
            }

            @Override
            public String getDescribedAs(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty();
                return property.getDescription();
            }

            @Override
            public Integer getLength(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty();
                BigDecimalValueFacet facet = (BigDecimalValueFacet)property.getFacet(BigDecimalValueFacet.class);
                return facet != null ? facet.getLength() : null;
            }

            @Override
            public Integer getScale(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty();
                BigDecimalValueFacet facet = (BigDecimalValueFacet)property.getFacet(BigDecimalValueFacet.class);
                return facet != null ? facet.getScale() : null;
            }

            @Override
            public int getTypicalLength(ScalarModel scalarModel) {
                PropertyMemento propertyMemento = scalarModel.getPropertyMemento();
                OneToOneAssociation property = propertyMemento.getProperty();
                TypicalLengthFacet facet = (TypicalLengthFacet)property.getFacet(TypicalLengthFacet.class);
                return facet != null ? facet.value() : 25;
            }

            @Override
            public void init(ScalarModel scalarModel) {
                this.reset(scalarModel);
            }

            @Override
            public void reset(ScalarModel scalarModel) {
                OneToOneAssociation property = scalarModel.propertyMemento.getProperty();
                ObjectAdapter associatedAdapter = property.get(scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK));
                scalarModel.setObject(associatedAdapter);
            }
        }
        ,
        PARAMETER{

            @Override
            public String getName(ScalarModel scalarModel) {
                return scalarModel.getParameterMemento().getActionParameter().getName();
            }

            @Override
            public ObjectSpecification getScalarTypeSpec(ScalarModel scalarModel) {
                return scalarModel.getParameterMemento().getSpecification();
            }

            @Override
            public String getIdentifier(ScalarModel scalarModel) {
                return "" + scalarModel.getParameterMemento().getNumber();
            }

            @Override
            public String getLongName(ScalarModel scalarModel) {
                ObjectAdapterMemento adapterMemento = scalarModel.getObjectAdapterMemento();
                if (adapterMemento == null) {
                    return null;
                }
                ObjectSpecId objectSpecId = adapterMemento.getObjectSpecId();
                String specShortName = SpecUtils.getSpecificationFor(objectSpecId).getShortIdentifier();
                String parmId = scalarModel.getParameterMemento().getActionParameter().getIdentifier().toNameIdentityString();
                return specShortName + "-" + parmId + "-" + scalarModel.getParameterMemento().getNumber();
            }

            @Override
            public String disable(ScalarModel scalarModel, Where where) {
                return null;
            }

            @Override
            public String parseAndValidate(ScalarModel scalarModel, String proposedPojoAsStr) {
                ObjectActionParameter parameter = scalarModel.getParameterMemento().getActionParameter();
                try {
                    ObjectAdapter parentAdapter = scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK);
                    Localization localization = IsisContext.getLocalization();
                    String invalidReasonIfAny = parameter.isValid(parentAdapter, (Object)proposedPojoAsStr, localization);
                    return invalidReasonIfAny;
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public String validate(ScalarModel scalarModel, ObjectAdapter proposedAdapter) {
                ObjectActionParameter parameter = scalarModel.getParameterMemento().getActionParameter();
                try {
                    ObjectAdapter parentAdapter = scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK);
                    Localization localization = IsisContext.getLocalization();
                    String invalidReasonIfAny = parameter.isValid(parentAdapter, proposedAdapter.getObject(), localization);
                    return invalidReasonIfAny;
                }
                catch (Exception ex) {
                    return ex.getLocalizedMessage();
                }
            }

            @Override
            public boolean isRequired(ScalarModel scalarModel) {
                ObjectActionParameter facetHolder = scalarModel.getParameterMemento().getActionParameter();
                return 2.isRequired((FacetHolder)facetHolder);
            }

            @Override
            public <T extends Facet> T getFacet(ScalarModel scalarModel, Class<T> facetType) {
                ObjectActionParameter facetHolder = scalarModel.getParameterMemento().getActionParameter();
                return (T)facetHolder.getFacet(facetType);
            }

            @Override
            public boolean hasChoices(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter();
                return actionParameter.hasChoices();
            }

            @Override
            public List<ObjectAdapter> getChoices(ScalarModel scalarModel, ObjectAdapter[] argumentsIfAvailable, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter();
                ObjectAdapter parentAdapter = scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK);
                ObjectAdapter[] choices = actionParameter.getChoices(parentAdapter, argumentsIfAvailable, authenticationSession, deploymentCategory);
                return Kind.choicesAsList(choices);
            }

            @Override
            public boolean hasAutoComplete(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter();
                return actionParameter.hasAutoComplete();
            }

            @Override
            public List<ObjectAdapter> getAutoComplete(ScalarModel scalarModel, String searchArg, AuthenticationSession authenticationSession, DeploymentCategory deploymentCategory) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter();
                ObjectAdapter parentAdapter = scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
                ObjectAdapter[] choices = actionParameter.getAutoComplete(parentAdapter, searchArg, authenticationSession, deploymentCategory);
                return Kind.choicesAsList(choices);
            }

            @Override
            public int getAutoCompleteOrChoicesMinLength(ScalarModel scalarModel) {
                if (scalarModel.hasAutoComplete()) {
                    ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                    ObjectActionParameter actionParameter = parameterMemento.getActionParameter();
                    return actionParameter.getAutoCompleteMinLength();
                }
                return 0;
            }

            @Override
            public void resetVersion(ScalarModel scalarModel) {
            }

            @Override
            public String getDescribedAs(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter();
                return actionParameter.getDescription();
            }

            @Override
            public Integer getLength(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter();
                BigDecimalValueFacet facet = (BigDecimalValueFacet)actionParameter.getFacet(BigDecimalValueFacet.class);
                return facet != null ? facet.getLength() : null;
            }

            @Override
            public Integer getScale(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter();
                BigDecimalValueFacet facet = (BigDecimalValueFacet)actionParameter.getFacet(BigDecimalValueFacet.class);
                return facet != null ? facet.getScale() : null;
            }

            @Override
            public int getTypicalLength(ScalarModel scalarModel) {
                ActionParameterMemento parameterMemento = scalarModel.getParameterMemento();
                ObjectActionParameter actionParameter = parameterMemento.getActionParameter();
                TypicalLengthFacet facet = (TypicalLengthFacet)actionParameter.getFacet(TypicalLengthFacet.class);
                return facet != null ? facet.value() : 25;
            }

            @Override
            public void init(ScalarModel scalarModel) {
            }

            @Override
            public void reset(ScalarModel scalarModel) {
                ObjectActionParameter actionParameter = scalarModel.parameterMemento.getActionParameter();
                ObjectAdapter defaultAdapter = actionParameter.getDefault(scalarModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK));
                scalarModel.setObject(defaultAdapter);
            }
        };


        private static List<ObjectAdapter> choicesAsList(ObjectAdapter[] choices) {
            if (choices != null && choices.length > 0) {
                return Arrays.asList(choices);
            }
            return Collections.emptyList();
        }

        public abstract String getName(ScalarModel var1);

        public abstract ObjectSpecification getScalarTypeSpec(ScalarModel var1);

        public abstract String getIdentifier(ScalarModel var1);

        public abstract String disable(ScalarModel var1, Where var2);

        public abstract String parseAndValidate(ScalarModel var1, String var2);

        public abstract String validate(ScalarModel var1, ObjectAdapter var2);

        public abstract String getLongName(ScalarModel var1);

        public abstract boolean isRequired(ScalarModel var1);

        public abstract <T extends Facet> T getFacet(ScalarModel var1, Class<T> var2);

        static boolean isRequired(FacetHolder facetHolder) {
            MandatoryFacet mandatoryFacet = (MandatoryFacet)facetHolder.getFacet(MandatoryFacet.class);
            boolean required = mandatoryFacet != null && !mandatoryFacet.isInvertedSemantics();
            return required;
        }

        public abstract boolean hasChoices(ScalarModel var1);

        public abstract List<ObjectAdapter> getChoices(ScalarModel var1, ObjectAdapter[] var2, AuthenticationSession var3, DeploymentCategory var4);

        public abstract boolean hasAutoComplete(ScalarModel var1);

        public abstract List<ObjectAdapter> getAutoComplete(ScalarModel var1, String var2, AuthenticationSession var3, DeploymentCategory var4);

        public abstract int getAutoCompleteOrChoicesMinLength(ScalarModel var1);

        public abstract void resetVersion(ScalarModel var1);

        public abstract String getDescribedAs(ScalarModel var1);

        public abstract Integer getLength(ScalarModel var1);

        public abstract Integer getScale(ScalarModel var1);

        public abstract int getTypicalLength(ScalarModel var1);

        public abstract void init(ScalarModel var1);

        public abstract void reset(ScalarModel var1);
    }
}

