/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.mementos;

import java.io.Serializable;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.mementos.SpecUtils;

public class PropertyMemento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ObjectSpecId owningSpecId;
    private final String identifier;
    private final ObjectSpecId specId;

    private static ObjectSpecification owningSpecFor(OneToOneAssociation association) {
        return IsisContext.getSpecificationLoader().loadSpecification(association.getIdentifier().toClassIdentityString());
    }

    public PropertyMemento(ObjectSpecId owningType, String identifier) {
        this(owningType, identifier, null);
    }

    public PropertyMemento(ObjectSpecId owningType, String identifier, ObjectSpecId type) {
        this(owningType, identifier, type, PropertyMemento.propertyFor(owningType, identifier));
    }

    public PropertyMemento(OneToOneAssociation property) {
        this(PropertyMemento.owningSpecFor(property).getSpecId(), property.getIdentifier().toNameIdentityString(), property.getSpecification().getSpecId(), property);
    }

    private PropertyMemento(ObjectSpecId owningSpecId, String name, ObjectSpecId specId, OneToOneAssociation property) {
        this.owningSpecId = owningSpecId;
        this.identifier = name;
        this.specId = specId;
    }

    public ObjectSpecId getOwningType() {
        return this.owningSpecId;
    }

    public ObjectSpecId getType() {
        return this.specId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public OneToOneAssociation getProperty() {
        return PropertyMemento.propertyFor(this.owningSpecId, this.identifier);
    }

    private static OneToOneAssociation propertyFor(ObjectSpecId owningType, String identifier) {
        return (OneToOneAssociation)SpecUtils.getSpecificationFor(owningType).getAssociation(identifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyMemento other = (PropertyMemento)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }
}

