/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.mementos;

import java.io.Serializable;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.wicket.model.mementos.ActionMemento;

public class ActionParameterMemento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ActionMemento actionMemento;
    private final int number;
    private transient ObjectActionParameter actionParameter;

    public ActionParameterMemento(ActionMemento actionMemento, int number) {
        this(actionMemento, number, ActionParameterMemento.actionParameterFor(actionMemento, number));
    }

    public ActionParameterMemento(ObjectActionParameter actionParameter) {
        this(new ActionMemento(actionParameter.getAction()), actionParameter.getNumber(), actionParameter);
    }

    private ActionParameterMemento(ActionMemento actionMemento, int number, ObjectActionParameter actionParameter) {
        this.actionMemento = actionMemento;
        this.number = number;
        this.actionParameter = actionParameter;
    }

    public ActionMemento getActionMemento() {
        return this.actionMemento;
    }

    public int getNumber() {
        return this.number;
    }

    public ObjectActionParameter getActionParameter() {
        if (this.actionParameter == null) {
            this.actionParameter = ActionParameterMemento.actionParameterFor(this.actionMemento, this.number);
        }
        return this.actionParameter;
    }

    private static ObjectActionParameter actionParameterFor(ActionMemento actionMemento, int number) {
        ObjectAction action = actionMemento.getAction();
        return (ObjectActionParameter)action.getParameters().get(number);
    }

    public ObjectSpecification getSpecification() {
        return this.getActionParameter().getSpecification();
    }
}

