/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.hints;

import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public interface UiHintContainer {
    public String getHint(Component var1, String var2);

    public void setHint(Component var1, String var2, String var3);

    public void clearHint(Component var1, String var2);

    public static class Util {
        private Util() {
        }

        public static UiHintContainer hintContainerOf(Component component) {
            return Util.hintContainerOf(component, UiHintContainer.class);
        }

        public static <T extends UiHintContainer> T hintContainerOf(Component component, Class<T> additionalConstraint) {
            if (component == null) {
                return null;
            }
            IModel model = component.getDefaultModel();
            if (model != null && additionalConstraint.isAssignableFrom(model.getClass())) {
                return (T)((UiHintContainer)additionalConstraint.cast(model));
            }
            return Util.hintContainerOf((Component)component.getParent(), additionalConstraint);
        }
    }
}

