/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;

public abstract class AuthenticatorTestCase
extends TestCase {
    private Server server;
    private String host = null;
    private int port = -1;
    Context context;
    private static Properties authenticatorConfig;
    private String POST = "test";

    protected static void setAuthenticationHandlerConfig(Properties config) {
        authenticatorConfig = config;
    }

    protected void start() throws Exception {
        this.server = new Server(0);
        this.context = new Context();
        this.context.setContextPath("/foo");
        this.server.setHandler((Handler)this.context);
        this.context.addFilter(new FilterHolder(TestFilter.class), "/*", 0);
        this.context.addServlet(new ServletHolder(TestServlet.class), "/bar");
        this.host = "localhost";
        ServerSocket ss = new ServerSocket(0);
        this.port = ss.getLocalPort();
        ss.close();
        this.server.getConnectors()[0].setHost(this.host);
        this.server.getConnectors()[0].setPort(this.port);
        this.server.start();
        System.out.println("Running embedded servlet container at: http://" + this.host + ":" + this.port);
    }

    protected void stop() throws Exception {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.server.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getBaseURL() {
        return "http://" + this.host + ":" + this.port + "/foo/bar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _testAuthentication(Authenticator authenticator, boolean doPost) throws Exception {
        this.start();
        try {
            URL url = new URL(this.getBaseURL());
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            AuthenticatedURL aUrl = new AuthenticatedURL(authenticator);
            HttpURLConnection conn = aUrl.openConnection(url, token);
            String tokenStr = token.toString();
            if (doPost) {
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
            }
            conn.connect();
            if (doPost) {
                OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
                writer.write(this.POST);
                ((Writer)writer).close();
            }
            AuthenticatorTestCase.assertEquals((int)200, (int)conn.getResponseCode());
            if (doPost) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String echo = reader.readLine();
                AuthenticatorTestCase.assertEquals((String)this.POST, (String)echo);
                AuthenticatorTestCase.assertNull((Object)reader.readLine());
            }
            aUrl = new AuthenticatedURL();
            conn = aUrl.openConnection(url, token);
            conn.connect();
            AuthenticatorTestCase.assertEquals((int)200, (int)conn.getResponseCode());
            AuthenticatorTestCase.assertEquals((String)tokenStr, (String)token.toString());
        }
        finally {
            this.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            ServletInputStream is = req.getInputStream();
            ServletOutputStream os = resp.getOutputStream();
            int c = is.read();
            while (c > -1) {
                os.write(c);
                c = is.read();
            }
            is.close();
            os.close();
            resp.setStatus(200);
        }
    }

    public static class TestFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            return authenticatorConfig;
        }
    }
}

