/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.TestSaslRPC;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.TokenInfo;
import org.junit.Test;

public class TestDistributedCacheAlternateFileSystem {
    private static final String REAL_USER_NAME = "realUser1@HADOOP.APACHE.ORG";
    private static final String REAL_USER_SHORT_NAME = "realUser1";
    private static final String PROXY_USER_NAME = "proxyUser";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2"};
    private static final String ADDRESS = "0.0.0.0";
    private TestProtocol proxy;
    private static Configuration masterConf = new Configuration();
    private static final String ALTERNATE_FILE_BASE = "gqlpt";
    public static final Log LOG = LogFactory.getLog(TestDistributedCacheAlternateFileSystem.class);

    private void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        LOG.info((Object)("Local Ip addresses: " + builder.toString()));
        conf.setStrings(ProxyUsers.getProxySuperuserIpConfKey((String)superUserShortName), new String[]{builder.toString()});
    }

    private FileSystem getFS(UserGroupInformation ugi, final Configuration conf) throws IOException {
        final Path sysDir = new Path("/gqlpt");
        try {
            return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return sysDir.getFileSystem(conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void addToClasspath(final FileSystem proxyUserFileSystem, final FileSystem realUserFileSystem, UserGroupInformation ugi, final String corePathString, final Configuration conf) throws IOException, InterruptedException {
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws IOException {
                DistributedCache.addFileToClassPath((Path)new Path("proxy-fs-as-" + corePathString), (Configuration)conf, (FileSystem)proxyUserFileSystem);
                DistributedCache.addFileToClassPath((Path)new Path("real-fs-as-" + corePathString), (Configuration)conf, (FileSystem)realUserFileSystem);
                DistributedCache.addFileToClassPath((Path)new Path("no-fs-as-" + corePathString), (Configuration)conf);
                return true;
            }
        });
    }

    private static boolean uriUsesProxyFS(URI uri) {
        String uriString = uri.toString();
        return uriString.contains("file:/gqlpt/");
    }

    private static boolean uriShouldUseProxyFS(URI uri) {
        String uriString = uri.toString();
        int filenameStart = uriString.lastIndexOf(File.separator) + 1;
        String fileName = uriString.substring(filenameStart);
        int lastProxyOccurrence = uriString.lastIndexOf("proxy");
        return fileName.contains("proxy-fs-as") || fileName.contains("no-fs-as") && fileName.contains("as-proxy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistributedCacheProxyUsers() throws Exception {
        URI[] result;
        FileSystem proxyUserFileSystemTemp;
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUser((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi);
        UserGroupInformation curUGI = (UserGroupInformation)proxyUserUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws IOException {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assert.assertTrue((boolean)curUGI.toString().equals("proxyUser via realUser1@HADOOP.APACHE.ORG"));
        Configuration conf = new Configuration();
        FileSystem realUserFileSystem = this.getFS(realUserUgi, conf);
        String oldWorkingDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", "/gqlpt");
            proxyUserFileSystemTemp = this.getFS(proxyUserUgi, conf);
        }
        finally {
            System.setProperty("user.dir", oldWorkingDir);
        }
        FileSystem proxyUserFileSystem = proxyUserFileSystemTemp;
        this.addToClasspath(proxyUserFileSystem, realUserFileSystem, realUserUgi, "real.jar", conf);
        this.addToClasspath(proxyUserFileSystem, realUserFileSystem, proxyUserUgi, "proxy.jar", conf);
        for (URI uri : result = DistributedCache.getCacheFiles((Configuration)conf)) {
            System.out.println("One URI is " + uri);
        }
        for (URI uri : result) {
            Assert.assertEquals((String)("Inconsistent file system usage for URI " + uri), (boolean)TestDistributedCacheAlternateFileSystem.uriUsesProxyFS(uri), (boolean)TestDistributedCacheAlternateFileSystem.uriShouldUseProxyFS(uri));
        }
    }

    private void refreshConf(Configuration conf) throws IOException {
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    static {
        masterConf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//RULE:[1:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//DEFAULT");
        UserGroupInformation.setConfiguration((Configuration)masterConf);
    }

    public class TestImpl
    implements TestProtocol {
        @Override
        public String aMethod() throws IOException {
            return UserGroupInformation.getCurrentUser().toString();
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 1L;
        }
    }

    @TokenInfo(value=TestSaslRPC.TestTokenSelector.class)
    public static interface TestProtocol
    extends VersionedProtocol {
        public static final long versionID = 1L;

        public String aMethod() throws IOException;
    }
}

