/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNameNodeCorruptionRecovery {
    private MiniDFSCluster cluster;

    @Before
    public void setUpCluster() throws IOException {
        this.cluster = new MiniDFSCluster(new Configuration(), 0, true, null);
        this.cluster.waitActive();
    }

    @After
    public void tearDownCluster() {
        this.cluster.shutdown();
    }

    @Test
    public void testFsTimeFileCorrupt() throws IOException, InterruptedException {
        Assert.assertEquals((long)this.cluster.getNameDirs().size(), (long)2L);
        TestNameNodeCorruptionRecovery.truncateStorageDirFile(this.cluster, FSImage.NameNodeFile.TIME, 0);
        this.cluster.restartNameNode();
    }

    private static void truncateStorageDirFile(MiniDFSCluster cluster, FSImage.NameNodeFile f, int storageDirIndex) throws IOException {
        File currentDir = cluster.getNameNode().getFSImage().getStorageDir(storageDirIndex).getCurrentDir();
        File nameNodeFile = new File(currentDir, f.getName());
        Assert.assertTrue((boolean)nameNodeFile.isFile());
        Assert.assertTrue((boolean)nameNodeFile.delete());
        Assert.assertTrue((boolean)nameNodeFile.createNewFile());
    }
}

