/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.Host2NodesMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHost2NodesMap {
    private Host2NodesMap map = new Host2NodesMap();
    private final DatanodeDescriptor[] dataNodes = new DatanodeDescriptor[]{new DatanodeDescriptor(new DatanodeID("h1:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h2:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h3:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h3:5030"), "/d1/r2")};
    private final DatanodeDescriptor NULL_NODE = null;
    private final DatanodeDescriptor NODE = new DatanodeDescriptor(new DatanodeID("h3:5040"), "/d1/r4");

    @Before
    public void setup() {
        for (DatanodeDescriptor node : this.dataNodes) {
            this.map.add(node);
        }
        this.map.add(this.NULL_NODE);
    }

    @Test
    public void testContains() throws Exception {
        for (int i = 0; i < this.dataNodes.length; ++i) {
            Assert.assertTrue((boolean)this.map.contains(this.dataNodes[i]));
        }
        Assert.assertFalse((boolean)this.map.contains(this.NULL_NODE));
        Assert.assertFalse((boolean)this.map.contains(this.NODE));
    }

    @Test
    public void testGetDatanodeByHost() throws Exception {
        Assert.assertTrue((this.map.getDatanodeByHost("h1") == this.dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByHost("h2") == this.dataNodes[1] ? 1 : 0) != 0);
        DatanodeDescriptor node = this.map.getDatanodeByHost("h3");
        Assert.assertTrue((node == this.dataNodes[2] || node == this.dataNodes[3] ? 1 : 0) != 0);
        Assert.assertTrue((null == this.map.getDatanodeByHost("h4") ? 1 : 0) != 0);
    }

    @Test
    public void testGetDatanodeByName() throws Exception {
        Assert.assertTrue((this.map.getDatanodeByName("h1:5020") == this.dataNodes[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByName("h1:5030") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByName("h2:5020") == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByName("h2:5030") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByName("h3:5020") == this.dataNodes[2] ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByName("h3:5030") == this.dataNodes[3] ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByName("h3:5040") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByName("h4") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByName(null) == null ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws Exception {
        Assert.assertFalse((boolean)this.map.remove(this.NODE));
        Assert.assertTrue((boolean)this.map.remove(this.dataNodes[0]));
        Assert.assertTrue((this.map.getDatanodeByHost("h1") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByHost("h2") == this.dataNodes[1] ? 1 : 0) != 0);
        DatanodeDescriptor node = this.map.getDatanodeByHost("h3");
        Assert.assertTrue((node == this.dataNodes[2] || node == this.dataNodes[3] ? 1 : 0) != 0);
        Assert.assertTrue((null == this.map.getDatanodeByHost("h4") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.map.remove(this.dataNodes[2]));
        Assert.assertTrue((this.map.getDatanodeByHost("h1") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByHost("h2") == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByHost("h3") == this.dataNodes[3] ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.map.remove(this.dataNodes[3]));
        Assert.assertTrue((this.map.getDatanodeByHost("h1") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByHost("h2") == this.dataNodes[1] ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getDatanodeByHost("h3") == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.map.remove(this.NULL_NODE));
        Assert.assertTrue((boolean)this.map.remove(this.dataNodes[1]));
        Assert.assertFalse((boolean)this.map.remove(this.dataNodes[1]));
    }
}

