/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.security.token.block.SecurityTestUtil;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;

public class TestBlockTokenWithDFS
extends TestCase {
    private static final int BLOCK_SIZE = 1024;
    private static final int FILE_SIZE = 2048;
    private static final String FILE_TO_READ = "/fileToRead.dat";
    private static final String FILE_TO_WRITE = "/fileToWrite.dat";
    private static final String FILE_TO_APPEND = "/fileToAppend.dat";
    private final byte[] rawData = new byte[2048];

    public TestBlockTokenWithDFS() {
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        Random r = new Random();
        r.nextBytes(this.rawData);
    }

    private void createFile(FileSystem fs, Path filename) throws IOException {
        FSDataOutputStream out = fs.create(filename);
        out.write(this.rawData);
        out.close();
    }

    private boolean checkFile1(FSDataInputStream in) {
        byte[] toRead = new byte[2048];
        int totalRead = 0;
        int nRead = 0;
        try {
            while ((nRead = in.read(toRead, totalRead, toRead.length - totalRead)) > 0) {
                totalRead += nRead;
            }
        }
        catch (IOException e) {
            return false;
        }
        TestBlockTokenWithDFS.assertEquals((String)"Cannot read file.", (int)toRead.length, (int)totalRead);
        return this.checkFile(toRead);
    }

    private boolean checkFile2(FSDataInputStream in) {
        byte[] toRead = new byte[2048];
        try {
            TestBlockTokenWithDFS.assertEquals((String)"Cannot read file", (int)toRead.length, (int)in.read(0L, toRead, 0, toRead.length));
        }
        catch (IOException e) {
            return false;
        }
        return this.checkFile(toRead);
    }

    private boolean checkFile(byte[] fileToCheck) {
        if (fileToCheck.length != this.rawData.length) {
            return false;
        }
        for (int i = 0; i < fileToCheck.length; ++i) {
            if (fileToCheck[i] == this.rawData[i]) continue;
            return false;
        }
        return true;
    }

    private static FSDataOutputStream writeFile(FileSystem fileSys, Path name, short repl, long blockSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), repl, blockSize);
        return stm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryRead(Configuration conf, LocatedBlock lblock, boolean shouldSucceed) {
        InetSocketAddress targetAddr = null;
        Socket s = null;
        DFSClient.BlockReader blockReader = null;
        Block block = lblock.getBlock();
        try {
            DatanodeInfo[] nodes = lblock.getLocations();
            targetAddr = NetUtils.createSocketAddr((String)nodes[0].getName());
            s = new Socket();
            s.connect(targetAddr, 60000);
            s.setSoTimeout(60000);
            blockReader = DFSClient.BlockReader.newBlockReader((Socket)s, (String)(targetAddr.toString() + ":" + block.getBlockId()), (long)block.getBlockId(), (Token)lblock.getBlockToken(), (long)block.getGenerationStamp(), (long)0L, (long)-1L, (int)conf.getInt("io.file.buffer.size", 4096));
        }
        catch (IOException ex) {
            if (ex instanceof InvalidBlockTokenException) {
                TestBlockTokenWithDFS.assertFalse((String)"OP_READ_BLOCK: access token is invalid, when it is expected to be valid", (boolean)shouldSucceed);
                return;
            }
            TestBlockTokenWithDFS.fail((String)"OP_READ_BLOCK failed due to reasons other than access token");
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iex) {
                }
                finally {
                    s = null;
                }
            }
        }
        if (blockReader == null) {
            TestBlockTokenWithDFS.fail((String)"OP_READ_BLOCK failed due to reasons other than access token");
        }
        TestBlockTokenWithDFS.assertTrue((String)"OP_READ_BLOCK: access token is valid, when it is expected to be invalid", (boolean)shouldSucceed);
    }

    private static Configuration getConf(int numDataNodes) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.setLong("dfs.block.size", 1024L);
        conf.setInt("io.bytes.per.checksum", 1024);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.replication", numDataNodes);
        conf.setInt("ipc.client.connect.max.retries", 0);
        conf.setBoolean("dfs.support.append", true);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppend() throws Exception {
        MiniDFSCluster cluster = null;
        int numDataNodes = 2;
        Configuration conf = TestBlockTokenWithDFS.getConf(numDataNodes);
        try {
            cluster = new MiniDFSCluster(conf, numDataNodes, true, null);
            cluster.waitActive();
            TestBlockTokenWithDFS.assertEquals((int)numDataNodes, (int)cluster.getDataNodes().size());
            SecurityTestUtil.setBlockTokenLifetime(cluster.getNameNode().getNamesystem().accessTokenHandler, 1000L);
            Path fileToAppend = new Path(FILE_TO_APPEND);
            FileSystem fs = cluster.getFileSystem();
            FSDataOutputStream stm = TestBlockTokenWithDFS.writeFile(fs, fileToAppend, (short)numDataNodes, 1024L);
            stm.write(this.rawData, 0, 1);
            stm.close();
            stm = fs.append(fileToAppend);
            int mid = this.rawData.length - 1;
            stm.write(this.rawData, 1, mid - 1);
            stm.sync();
            Token<BlockTokenIdentifier> token = DFSTestUtil.getAccessToken(stm);
            while (!SecurityTestUtil.isBlockTokenExpired(token)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {}
            }
            cluster.stopDataNode(0);
            stm.write(this.rawData, mid, this.rawData.length - mid);
            stm.close();
            FSDataInputStream in5 = fs.open(fileToAppend);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in5));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWrite() throws Exception {
        MiniDFSCluster cluster = null;
        int numDataNodes = 2;
        Configuration conf = TestBlockTokenWithDFS.getConf(numDataNodes);
        try {
            cluster = new MiniDFSCluster(conf, numDataNodes, true, null);
            cluster.waitActive();
            TestBlockTokenWithDFS.assertEquals((int)numDataNodes, (int)cluster.getDataNodes().size());
            SecurityTestUtil.setBlockTokenLifetime(cluster.getNameNode().getNamesystem().accessTokenHandler, 1000L);
            Path fileToWrite = new Path(FILE_TO_WRITE);
            FileSystem fs = cluster.getFileSystem();
            FSDataOutputStream stm = TestBlockTokenWithDFS.writeFile(fs, fileToWrite, (short)numDataNodes, 1024L);
            int mid = this.rawData.length - 1;
            stm.write(this.rawData, 0, mid);
            stm.sync();
            Token<BlockTokenIdentifier> token = DFSTestUtil.getAccessToken(stm);
            while (!SecurityTestUtil.isBlockTokenExpired(token)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {}
            }
            cluster.stopDataNode(0);
            stm.write(this.rawData, mid, this.rawData.length - mid);
            stm.close();
            FSDataInputStream in4 = fs.open(fileToWrite);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in4));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRead() throws Exception {
        MiniDFSCluster cluster = null;
        int numDataNodes = 2;
        Configuration conf = TestBlockTokenWithDFS.getConf(numDataNodes);
        try {
            cluster = new MiniDFSCluster(conf, numDataNodes, true, null);
            cluster.waitActive();
            TestBlockTokenWithDFS.assertEquals((int)numDataNodes, (int)cluster.getDataNodes().size());
            SecurityTestUtil.setBlockTokenLifetime(cluster.getNameNode().getNamesystem().accessTokenHandler, 1000L);
            Path fileToRead = new Path(FILE_TO_READ);
            FileSystem fs = cluster.getFileSystem();
            this.createFile(fs, fileToRead);
            FSDataInputStream in1 = fs.open(fileToRead);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in1));
            FSDataInputStream in2 = fs.open(fileToRead);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in2));
            FSDataInputStream in3 = fs.open(fileToRead);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile2(in3));
            DFSClient dfsclient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), conf);
            List locatedBlocks = cluster.getNameNode().getBlockLocations(FILE_TO_READ, 0L, 2048L).getLocatedBlocks();
            LocatedBlock lblock = (LocatedBlock)locatedBlocks.get(0);
            Token myToken = lblock.getBlockToken();
            TestBlockTokenWithDFS.assertFalse((boolean)SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)myToken));
            TestBlockTokenWithDFS.tryRead(conf, lblock, true);
            while (!SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)myToken)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {}
            }
            TestBlockTokenWithDFS.assertTrue((boolean)SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)myToken));
            TestBlockTokenWithDFS.tryRead(conf, lblock, false);
            lblock.setBlockToken(cluster.getNameNode().getNamesystem().accessTokenHandler.generateToken(lblock.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.READ)));
            TestBlockTokenWithDFS.tryRead(conf, lblock, true);
            Block wrongBlock = new Block(lblock.getBlock().getBlockId() + 1L);
            lblock.setBlockToken(cluster.getNameNode().getNamesystem().accessTokenHandler.generateToken(wrongBlock, EnumSet.of(BlockTokenSecretManager.AccessMode.READ)));
            TestBlockTokenWithDFS.tryRead(conf, lblock, false);
            lblock.setBlockToken(cluster.getNameNode().getNamesystem().accessTokenHandler.generateToken(lblock.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE, BlockTokenSecretManager.AccessMode.COPY, BlockTokenSecretManager.AccessMode.REPLACE)));
            TestBlockTokenWithDFS.tryRead(conf, lblock, false);
            SecurityTestUtil.setBlockTokenLifetime(cluster.getNameNode().getNamesystem().accessTokenHandler, 600000L);
            List<LocatedBlock> lblocks = DFSTestUtil.getAllBlocks(in1);
            for (LocatedBlock blk : lblocks) {
                TestBlockTokenWithDFS.assertTrue((boolean)SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)blk.getBlockToken()));
            }
            in1.seek(0L);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in1));
            List<LocatedBlock> lblocks2 = DFSTestUtil.getAllBlocks(in2);
            for (LocatedBlock blk : lblocks2) {
                TestBlockTokenWithDFS.assertTrue((boolean)SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)blk.getBlockToken()));
            }
            TestBlockTokenWithDFS.assertTrue((boolean)in2.seekToNewSource(0L));
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in2));
            List<LocatedBlock> lblocks3 = DFSTestUtil.getAllBlocks(in3);
            for (LocatedBlock blk : lblocks3) {
                TestBlockTokenWithDFS.assertTrue((boolean)SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)blk.getBlockToken()));
            }
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile2(in3));
            TestBlockTokenWithDFS.assertTrue((boolean)cluster.restartDataNodes(true));
            cluster.waitActive();
            TestBlockTokenWithDFS.assertEquals((int)numDataNodes, (int)cluster.getDataNodes().size());
            cluster.shutdownNameNode();
            lblocks = DFSTestUtil.getAllBlocks(in1);
            for (LocatedBlock blk : lblocks) {
                TestBlockTokenWithDFS.assertFalse((boolean)SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)blk.getBlockToken()));
            }
            in1.seek(0L);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in1));
            lblocks2 = DFSTestUtil.getAllBlocks(in2);
            for (LocatedBlock blk : lblocks2) {
                TestBlockTokenWithDFS.assertFalse((boolean)SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)blk.getBlockToken()));
            }
            in2.seekToNewSource(0L);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in2));
            lblocks3 = DFSTestUtil.getAllBlocks(in3);
            for (LocatedBlock blk : lblocks3) {
                TestBlockTokenWithDFS.assertFalse((boolean)SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)blk.getBlockToken()));
            }
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile2(in3));
            cluster.restartNameNode();
            cluster.shutdownNameNode();
            in1.seek(0L);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in1));
            in2.seekToNewSource(0L);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in2));
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile2(in3));
            cluster.restartNameNode();
            TestBlockTokenWithDFS.assertTrue((boolean)cluster.restartDataNodes(true));
            cluster.waitActive();
            TestBlockTokenWithDFS.assertEquals((int)numDataNodes, (int)cluster.getDataNodes().size());
            cluster.shutdownNameNode();
            in1.seek(0L);
            TestBlockTokenWithDFS.assertFalse((boolean)this.checkFile1(in1));
            TestBlockTokenWithDFS.assertFalse((boolean)this.checkFile2(in3));
            cluster.restartNameNode();
            in1.seek(0L);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in1));
            in2.seekToNewSource(0L);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in2));
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile2(in3));
            TestBlockTokenWithDFS.assertTrue((boolean)cluster.restartDataNodes(false));
            cluster.waitActive();
            TestBlockTokenWithDFS.assertEquals((int)numDataNodes, (int)cluster.getDataNodes().size());
            in1.seek(0L);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in1));
            in2.seekToNewSource(0L);
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile1(in2));
            TestBlockTokenWithDFS.assertTrue((boolean)this.checkFile2(in3));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testEnd2End() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        new TestBalancer().integrationTest(conf);
    }
}

