/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.shared.ldap.model.constants.SaslQoP;
import org.apache.directory.shared.ldap.model.constants.SaslSecurityStrength;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;

public abstract class SaslRequest {
    protected String saslMechanism;
    protected List<Control> controls = new ArrayList<Control>();
    protected String username;
    protected byte[] credentials;
    protected String realmName;
    protected String authorizationId;
    protected SaslQoP qualityOfProtection;
    protected SaslSecurityStrength securityStrength;
    protected boolean mutualAuthentication = false;

    protected SaslRequest(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public void addAllControls(Control[] controls) {
        this.controls.addAll(Arrays.asList(controls));
    }

    public void addControl(Control control) {
        this.controls.add(control);
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public Control[] getControls() {
        return this.controls.toArray(new Control[0]);
    }

    public byte[] getCredentials() {
        if (this.credentials != null) {
            return this.credentials;
        }
        return StringConstants.EMPTY_BYTES;
    }

    public SaslQoP getQualityOfProtection() {
        return this.qualityOfProtection;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public SaslSecurityStrength getSecurityStrength() {
        return this.securityStrength;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isMutualAuthentication() {
        return this.mutualAuthentication;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public void setCredentials(byte[] credentials) {
        this.credentials = credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = Strings.getBytesUtf8((String)credentials);
    }

    public void setMutualAuthentication(boolean mutualAuthentication) {
        this.mutualAuthentication = mutualAuthentication;
    }

    public void setQualityOfProtection(SaslQoP qualityOfProtection) {
        this.qualityOfProtection = qualityOfProtection;
    }

    protected void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    protected void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public void setSecurityStrength(SaslSecurityStrength securityStrength) {
        this.securityStrength = securityStrength;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

