/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.exception.InvalidConnectionException;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.AttributesFactory;
import org.apache.directory.shared.ldap.model.schema.DitContentRule;
import org.apache.directory.shared.ldap.model.schema.DitStructureRule;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.model.schema.NameForm;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaObject;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectWrapper;
import org.apache.directory.shared.ldap.model.schema.parsers.AttributeTypeDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.DitContentRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.DitStructureRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.LdapComparatorDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.LdapSyntaxDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.MatchingRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.MatchingRuleUseDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.NameFormDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.NormalizerDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.SyntaxCheckerDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.registries.AbstractSchemaLoader;
import org.apache.directory.shared.ldap.model.schema.registries.DefaultSchema;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.Base64;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSchemaLoader
extends AbstractSchemaLoader {
    private static final String DEFAULT_APACHEDS_VENDOR_NAME = "Apache Software Foundation";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaLoader.class);
    private LdapConnection connection;
    private Dn subschemaSubentryDn;
    private static AttributeTypeDescriptionSchemaParser AT_DESCR_SCHEMA_PARSER = new AttributeTypeDescriptionSchemaParser();
    private static DitStructureRuleDescriptionSchemaParser DSR_DESCR_SCHEMA_PARSER = new DitStructureRuleDescriptionSchemaParser();
    private static DitContentRuleDescriptionSchemaParser DCR_DESCR_SCHEMA_PARSER = new DitContentRuleDescriptionSchemaParser();
    private static MatchingRuleDescriptionSchemaParser MR_DESCR_SCHEMA_PARSER = new MatchingRuleDescriptionSchemaParser();
    private static MatchingRuleUseDescriptionSchemaParser MRU_DESCR_SCHEMA_PARSER = new MatchingRuleUseDescriptionSchemaParser();
    private static NameFormDescriptionSchemaParser NF_DESCR_SCHEMA_PARSER = new NameFormDescriptionSchemaParser();
    private static ObjectClassDescriptionSchemaParser OC_DESCR_SCHEMA_PARSER = new ObjectClassDescriptionSchemaParser();
    private static LdapSyntaxDescriptionSchemaParser LS_DESCR_SCHEMA_PARSER = new LdapSyntaxDescriptionSchemaParser();
    private static LdapComparatorDescriptionSchemaParser C_DESCR_SCHEMA_PARSER = new LdapComparatorDescriptionSchemaParser();
    private static NormalizerDescriptionSchemaParser N_DESCR_SCHEMA_PARSER = new NormalizerDescriptionSchemaParser();
    private static SyntaxCheckerDescriptionSchemaParser SC_DESCR_SCHEMA_PARSER = new SyntaxCheckerDescriptionSchemaParser();

    public DefaultSchemaLoader(LdapConnection connection) throws LdapException {
        if (connection == null) {
            throw new InvalidConnectionException("Cannot connect on the server, the connection is null");
        }
        this.connection = connection;
        boolean wasConnected = connection.isConnected();
        try {
            Entry rootDse;
            if (!wasConnected) {
                connection.connect();
            }
            if ((rootDse = connection.lookup(Dn.ROOT_DSE, "subschemaSubentry", "vendorName")) != null && this.isApacheDs(rootDse)) {
                System.out.println("isApacheDS");
                Attribute subschemaSubentryAttribute = rootDse.get("subschemaSubentry");
                if (subschemaSubentryAttribute != null && subschemaSubentryAttribute.size() > 0) {
                    this.subschemaSubentryDn = new Dn(connection.getSchemaManager(), new String[]{subschemaSubentryAttribute.getString()});
                    this.loadSchemas();
                }
            }
        }
        catch (IOException e) {
            throw new LdapException((Throwable)e);
        }
        finally {
            if (!wasConnected && connection.isConnected()) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    throw new LdapException((Throwable)e);
                }
            }
        }
    }

    private boolean isApacheDs(Entry rootDse) throws LdapInvalidAttributeValueException {
        Attribute vendorNameAttribute;
        if (rootDse != null && (vendorNameAttribute = rootDse.get("vendorName")) != null && vendorNameAttribute.size() == 1) {
            return DEFAULT_APACHEDS_VENDOR_NAME.equalsIgnoreCase(vendorNameAttribute.getString());
        }
        return false;
    }

    public DefaultSchemaLoader(LdapConnection connection, Dn subschemaSubentryDn) throws Exception {
        if (!connection.isAuthenticated()) {
            throw new IllegalArgumentException("connection is not authenticated");
        }
        this.connection = connection;
        this.subschemaSubentryDn = subschemaSubentryDn;
        this.loadSchemas();
    }

    private void loadSchemas() throws LdapException {
        LOG.debug("initializing schemas");
        Entry subschemaSubentry = this.connection.lookup(this.subschemaSubentryDn, "attributeTypes", "comparators", "ditContentRules", "ditStructureRules", "ldapSyntaxes", "matchingRules", "matchingRuleUse", "nameForms", "normalizers", "objectClasses", "syntaxCheckers");
        Attribute attributeTypes = subschemaSubentry.get("attributeTypes");
        this.loadAttributeTypes(attributeTypes);
        Attribute comparators = subschemaSubentry.get("comparators");
        this.loadComparators(comparators);
        Attribute ditContentRules = subschemaSubentry.get("ditContentRules");
        this.loadDitContentRules(ditContentRules);
        Attribute ditStructureRules = subschemaSubentry.get("ditStructureRules");
        this.loadDitStructureRules(ditStructureRules);
        Attribute ldapSytaxes = subschemaSubentry.get("ldapSyntaxes");
        this.loadLdapSyntaxes(ldapSytaxes);
        Attribute matchingRules = subschemaSubentry.get("matchingRules");
        this.loadMatchingRules(matchingRules);
        Attribute matchingRuleUse = subschemaSubentry.get("matchingRuleUse");
        this.loadMatchingRuleUses(matchingRuleUse);
        Attribute normalizers = subschemaSubentry.get("normalizers");
        this.loadNormalizers(normalizers);
        Attribute nameForms = subschemaSubentry.get("nameForms");
        this.loadNameForms(nameForms);
        Attribute objectClasses = subschemaSubentry.get("objectClasses");
        this.loadObjectClasses(objectClasses);
        Attribute syntaxCheckers = subschemaSubentry.get("syntaxCheckers");
        this.loadSyntaxCheckers(syntaxCheckers);
    }

    private void loadAttributeTypes(Attribute attributeTypes) throws LdapException {
        if (attributeTypes == null) {
            return;
        }
        for (Value value : attributeTypes) {
            String desc = value.getString();
            try {
                AttributeType attributeType = AT_DESCR_SCHEMA_PARSER.parseAttributeTypeDescription(desc);
                this.updateSchemas((SchemaObject)attributeType);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadComparators(Attribute comparators) throws LdapException {
        if (comparators == null) {
            return;
        }
        for (Value value : comparators) {
            String desc = value.getString();
            try {
                LdapComparatorDescription comparator = C_DESCR_SCHEMA_PARSER.parseComparatorDescription(desc);
                this.updateSchemas((SchemaObject)comparator);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadDitContentRules(Attribute ditContentRules) throws LdapException {
        if (ditContentRules == null) {
            return;
        }
        for (Value value : ditContentRules) {
            String desc = value.getString();
            try {
                DitContentRule ditContentRule = DCR_DESCR_SCHEMA_PARSER.parseDITContentRuleDescription(desc);
                this.updateSchemas((SchemaObject)ditContentRule);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadDitStructureRules(Attribute ditStructureRules) throws LdapException {
        if (ditStructureRules == null) {
            return;
        }
        for (Value value : ditStructureRules) {
            String desc = value.getString();
            try {
                DitStructureRule ditStructureRule = DSR_DESCR_SCHEMA_PARSER.parseDITStructureRuleDescription(desc);
                this.updateSchemas((SchemaObject)ditStructureRule);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadLdapSyntaxes(Attribute ldapSyntaxes) throws LdapException {
        if (ldapSyntaxes == null) {
            return;
        }
        for (Value value : ldapSyntaxes) {
            String desc = value.getString();
            try {
                LdapSyntax ldapSyntax = LS_DESCR_SCHEMA_PARSER.parseLdapSyntaxDescription(desc);
                this.updateSchemas((SchemaObject)ldapSyntax);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadMatchingRules(Attribute matchingRules) throws LdapException {
        if (matchingRules == null) {
            return;
        }
        for (Value value : matchingRules) {
            String desc = value.getString();
            try {
                MatchingRule matchingRule = MR_DESCR_SCHEMA_PARSER.parseMatchingRuleDescription(desc);
                this.updateSchemas((SchemaObject)matchingRule);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadMatchingRuleUses(Attribute matchingRuleUses) throws LdapException {
        if (matchingRuleUses == null) {
            return;
        }
        for (Value value : matchingRuleUses) {
            String desc = value.getString();
            try {
                MatchingRuleUse matchingRuleUse = MRU_DESCR_SCHEMA_PARSER.parseMatchingRuleUseDescription(desc);
                this.updateSchemas((SchemaObject)matchingRuleUse);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadNameForms(Attribute nameForms) throws LdapException {
        if (nameForms == null) {
            return;
        }
        for (Value value : nameForms) {
            String desc = value.getString();
            try {
                NameForm nameForm = NF_DESCR_SCHEMA_PARSER.parseNameFormDescription(desc);
                this.updateSchemas((SchemaObject)nameForm);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadNormalizers(Attribute normalizers) throws LdapException {
        if (normalizers == null) {
            return;
        }
        for (Value value : normalizers) {
            String desc = value.getString();
            try {
                NormalizerDescription normalizer = N_DESCR_SCHEMA_PARSER.parseNormalizerDescription(desc);
                this.updateSchemas((SchemaObject)normalizer);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadObjectClasses(Attribute objectClasses) throws LdapException {
        if (objectClasses == null) {
            return;
        }
        for (Value value : objectClasses) {
            String desc = value.getString();
            try {
                ObjectClass objectClass = OC_DESCR_SCHEMA_PARSER.parseObjectClassDescription(desc);
                this.updateSchemas((SchemaObject)objectClass);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void loadSyntaxCheckers(Attribute syntaxCheckers) throws LdapException {
        if (syntaxCheckers == null) {
            return;
        }
        for (Value value : syntaxCheckers) {
            String desc = value.getString();
            try {
                SyntaxCheckerDescription syntaxChecker = SC_DESCR_SCHEMA_PARSER.parseSyntaxCheckerDescription(desc);
                this.updateSchemas((SchemaObject)syntaxChecker);
            }
            catch (ParseException pe) {
                throw new LdapException((Throwable)pe);
            }
        }
    }

    private void updateSchemas(SchemaObject schemaObject) {
        String schemaName = schemaObject.getSchemaName();
        Schema schema = null;
        if (Strings.isEmpty((String)schemaName) || Strings.equals((String)"null", (String)schemaName)) {
            schemaName = "default";
            schema = (Schema)this.schemaMap.get(schemaName);
        } else {
            schema = (Schema)this.schemaMap.get(schemaName);
        }
        if (schema == null) {
            schema = new DefaultSchema(schemaName);
            this.schemaMap.put(schemaName, schema);
        }
        schema.getContent().add(new SchemaObjectWrapper(schemaObject));
    }

    public List<Entry> loadAttributeTypes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> attributeTypeEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return attributeTypeEntries;
        }
        AttributesFactory factory = new AttributesFactory();
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof AttributeType)) continue;
                AttributeType attributeType = (AttributeType)schemaObject;
                Entry attributeTypeEntry = factory.convert(attributeType, schema, null);
                attributeTypeEntries.add(attributeTypeEntry);
            }
        }
        return attributeTypeEntries;
    }

    public List<Entry> loadComparators(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> comparatorEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return comparatorEntries;
        }
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof LdapComparatorDescription)) continue;
                LdapComparatorDescription ldapComparatorDescription = (LdapComparatorDescription)schemaObject;
                Entry lcEntry = this.getEntry(ldapComparatorDescription);
                comparatorEntries.add(lcEntry);
            }
        }
        return comparatorEntries;
    }

    public List<Entry> loadDitContentRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditContentRuleEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return ditContentRuleEntries;
        }
        AttributesFactory factory = new AttributesFactory();
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof DitContentRule)) continue;
                DitContentRule ditContentRule = (DitContentRule)schemaObject;
                Entry ditContentRuleEntry = factory.convert(ditContentRule, schema, null);
                ditContentRuleEntries.add(ditContentRuleEntry);
            }
        }
        return ditContentRuleEntries;
    }

    public List<Entry> loadDitStructureRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditStructureRuleEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return ditStructureRuleEntries;
        }
        AttributesFactory factory = new AttributesFactory();
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof DitStructureRule)) continue;
                DitStructureRule ditStructureRule = (DitStructureRule)schemaObject;
                Entry ditStructureRuleEntry = factory.convert(ditStructureRule, schema, null);
                ditStructureRuleEntries.add(ditStructureRuleEntry);
            }
        }
        return ditStructureRuleEntries;
    }

    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleUseEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleUseEntries;
        }
        AttributesFactory factory = new AttributesFactory();
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof MatchingRuleUse)) continue;
                MatchingRuleUse matchingRuleUse = (MatchingRuleUse)schemaObject;
                Entry matchingRuleUseEntry = factory.convert(matchingRuleUse, schema, null);
                matchingRuleUseEntries.add(matchingRuleUseEntry);
            }
        }
        return matchingRuleUseEntries;
    }

    public List<Entry> loadMatchingRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleEntries;
        }
        AttributesFactory factory = new AttributesFactory();
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof MatchingRule)) continue;
                MatchingRule matchingRule = (MatchingRule)schemaObject;
                Entry matchingRuleEntry = factory.convert(matchingRule, schema, null);
                matchingRuleEntries.add(matchingRuleEntry);
            }
        }
        return matchingRuleEntries;
    }

    public List<Entry> loadNameForms(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> nameFormEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return nameFormEntries;
        }
        AttributesFactory factory = new AttributesFactory();
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof NameForm)) continue;
                NameForm nameForm = (NameForm)schemaObject;
                Entry nameFormEntry = factory.convert(nameForm, schema, null);
                nameFormEntries.add(nameFormEntry);
            }
        }
        return nameFormEntries;
    }

    public List<Entry> loadNormalizers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> normalizerEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return normalizerEntries;
        }
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof NormalizerDescription)) continue;
                NormalizerDescription normalizerDescription = (NormalizerDescription)schemaObject;
                Entry normalizerEntry = this.getEntry(normalizerDescription);
                normalizerEntries.add(normalizerEntry);
            }
        }
        return normalizerEntries;
    }

    public List<Entry> loadObjectClasses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> objectClassEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return objectClassEntries;
        }
        AttributesFactory factory = new AttributesFactory();
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof ObjectClass)) continue;
                ObjectClass objectClass = (ObjectClass)schemaObject;
                Entry objectClassEntry = factory.convert(objectClass, schema, null);
                objectClassEntries.add(objectClassEntry);
            }
        }
        return objectClassEntries;
    }

    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxCheckerEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxCheckerEntries;
        }
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof SyntaxCheckerDescription)) continue;
                SyntaxCheckerDescription syntaxCheckerDescription = (SyntaxCheckerDescription)schemaObject;
                Entry syntaxCheckerEntry = this.getEntry(syntaxCheckerDescription);
                syntaxCheckerEntries.add(syntaxCheckerEntry);
            }
        }
        return syntaxCheckerEntries;
    }

    public List<Entry> loadSyntaxes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxEntries = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxEntries;
        }
        AttributesFactory factory = new AttributesFactory();
        for (Schema schema : schemas) {
            Set schemaObjectWrappers = schema.getContent();
            for (SchemaObjectWrapper schemaObjectWrapper : schemaObjectWrappers) {
                SchemaObject schemaObject = schemaObjectWrapper.get();
                if (!(schemaObject instanceof LdapSyntax)) continue;
                LdapSyntax ldapSyntax = (LdapSyntax)schemaObject;
                Entry ldapSyntaxEntry = factory.convert(ldapSyntax, schema, null);
                syntaxEntries.add(ldapSyntaxEntry);
            }
        }
        return syntaxEntries;
    }

    private Entry getEntry(LdapComparatorDescription comparatorDescription) {
        DefaultEntry entry = new DefaultEntry();
        entry.put("objectClass", new String[]{"top", "metaTop", "metaComparator"});
        entry.put("m-oid", new String[]{comparatorDescription.getOid()});
        entry.put("m-fqcn", new String[]{comparatorDescription.getFqcn()});
        if (comparatorDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode((char[])comparatorDescription.getBytecode().toCharArray())});
        }
        if (comparatorDescription.getDescription() != null) {
            entry.put("m-description", new String[]{comparatorDescription.getDescription()});
        }
        return entry;
    }

    private Entry getEntry(SyntaxCheckerDescription syntaxCheckerDescription) {
        DefaultEntry entry = new DefaultEntry();
        entry.put("objectClass", new String[]{"top", "metaTop", "metaSyntaxChecker"});
        entry.put("m-oid", new String[]{syntaxCheckerDescription.getOid()});
        entry.put("m-fqcn", new String[]{syntaxCheckerDescription.getFqcn()});
        if (syntaxCheckerDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode((char[])syntaxCheckerDescription.getBytecode().toCharArray())});
        }
        if (syntaxCheckerDescription.getDescription() != null) {
            entry.put("m-description", new String[]{syntaxCheckerDescription.getDescription()});
        }
        return entry;
    }

    private Entry getEntry(NormalizerDescription normalizerDescription) {
        DefaultEntry entry = new DefaultEntry();
        entry.put("objectClass", new String[]{"top", "metaTop", "metaNormalizer"});
        entry.put("m-oid", new String[]{normalizerDescription.getOid()});
        entry.put("m-fqcn", new String[]{normalizerDescription.getFqcn()});
        if (normalizerDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode((char[])normalizerDescription.getBytecode().toCharArray())});
        }
        if (normalizerDescription.getDescription() != null) {
            entry.put("m-description", new String[]{normalizerDescription.getDescription()});
        }
        return entry;
    }
}

