/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;

public class RoutesCollector
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesCollector.class);
    private final ApplicationContext applicationContext;
    private final List<CamelContextConfiguration> camelContextConfigurations;

    public RoutesCollector(ApplicationContext applicationContext, List<CamelContextConfiguration> camelContextConfigurations) {
        this.applicationContext = applicationContext;
        this.camelContextConfigurations = new ArrayList<CamelContextConfiguration>(camelContextConfigurations);
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        ApplicationContext applicationContext = contextRefreshedEvent.getApplicationContext();
        if (this.applicationContext.equals(applicationContext)) {
            CamelContext camelContext = (CamelContext)contextRefreshedEvent.getApplicationContext().getBean(CamelContext.class);
            if (camelContext.getStatus().isStopped()) {
                LOG.debug("Post-processing CamelContext bean: {}", (Object)camelContext.getName());
                for (RoutesBuilder routesBuilder : applicationContext.getBeansOfType(RoutesBuilder.class).values()) {
                    try {
                        LOG.debug("Injecting following route into the CamelContext: {}", (Object)routesBuilder);
                        camelContext.addRoutes(routesBuilder);
                    }
                    catch (Exception e) {
                        throw new CamelSpringBootInitializationException(e);
                    }
                }
                try {
                    this.loadXmlRoutes(applicationContext, camelContext);
                    for (CamelContextConfiguration camelContextConfiguration : this.camelContextConfigurations) {
                        LOG.debug("CamelContextConfiguration found. Invoking: {}", (Object)camelContextConfiguration);
                        camelContextConfiguration.beforeApplicationStart(camelContext);
                    }
                    camelContext.start();
                }
                catch (Exception e) {
                    throw new CamelSpringBootInitializationException(e);
                }
            } else {
                LOG.debug("Camel already started, not adding routes.");
            }
        } else {
            LOG.debug("Ignore ContextRefreshedEvent: {}", (Object)contextRefreshedEvent);
        }
    }

    private void loadXmlRoutes(ApplicationContext applicationContext, CamelContext camelContext) throws Exception {
        LOG.debug("Started XML routes detection. Scanning classpath (/camel/*.xml)...");
        try {
            Resource[] xmlRoutes;
            for (Resource xmlRoute : xmlRoutes = applicationContext.getResources("classpath:camel/*.xml")) {
                RoutesDefinition xmlDefinition = camelContext.loadRoutesDefinition(xmlRoute.getInputStream());
                camelContext.addRouteDefinitions((Collection)xmlDefinition.getRoutes());
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("No XMl routes found in the classpath (/camel/*.xml). Skipping XML routes detection.");
        }
    }
}

