/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.people.action.web;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.mingsoft.base.constant.e.BaseCookieEnum;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.entity.ResultJson;
import com.mingsoft.people.action.BaseAction;
import com.mingsoft.people.action.web.CodeBean;
import com.mingsoft.people.bean.PeopleLoginBean;
import com.mingsoft.people.biz.IPeopleBiz;
import com.mingsoft.people.biz.IPeopleUserBiz;
import com.mingsoft.people.constant.ModelCode;
import com.mingsoft.people.constant.e.CookieConstEnum;
import com.mingsoft.people.constant.e.PeopleEnum;
import com.mingsoft.people.constant.e.SessionConstEnum;
import com.mingsoft.people.entity.PeopleEntity;
import com.mingsoft.people.entity.PeopleUserEntity;
import com.mingsoft.util.DateUtil;
import com.mingsoft.util.MD5Util;
import com.mingsoft.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="webPeople")
@RequestMapping(value={"/"})
public class PeopleAction
extends BaseAction {
    @Autowired
    private IPeopleBiz peopleBiz;
    @Autowired
    private IPeopleUserBiz peopleUserBiz;

    @RequestMapping(value={"/checkCode"}, method={RequestMethod.POST})
    @ResponseBody
    public void checkCode(HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkRandCode(request)) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("rand.code")}));
            return;
        }
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.POST})
    @ResponseBody
    public void check(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity _people = this.peopleBiz.getByPeople(people, this.getAppId(request));
        if (_people != null) {
            this.outJson(response, true);
        } else {
            this.outJson(response, false);
        }
    }

    @RequestMapping(value={"/checkLogin"}, method={RequestMethod.POST})
    @ResponseBody
    public void checkLogin(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkRandCode(request)) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("rand.code")}));
            return;
        }
        if (StringUtil.isBlank((String)people.getPeopleName()) || StringUtil.isBlank((String)people.getPeoplePassword())) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_LOGIN, false, this.getResString("err.error", new String[]{this.getResString("people")}));
            return;
        }
        int appId = this.getAppId(request);
        PeopleEntity peopleEntity = this.peopleBiz.getEntityByUserName(people.getPeopleName(), appId);
        if (peopleEntity == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_LOGIN, false, this.getResString("err.error", new String[]{this.getResString("pepple.no.exist")}));
            return;
        }
        String peoplePassWord = MD5Util.MD5Encode((String)people.getPeoplePassword(), (String)"utf-8");
        if (peoplePassWord.equals(peopleEntity.getPeoplePassword())) {
            this.setPeopleBySession(request, peopleEntity);
            PeopleLoginBean tempPeople = new PeopleLoginBean();
            tempPeople.setPeopleId(peopleEntity.getPeopleId());
            tempPeople.setPeopleName(peopleEntity.getPeopleName());
            tempPeople.setPeopleMail(peopleEntity.getPeopleMail());
            tempPeople.setPeopleState(peopleEntity.getPeopleState());
            tempPeople.setCookie(request.getHeader("cookie"));
            if (people.getPeopleAutoLogin() > 0) {
                tempPeople.setPeoplePassword(people.getPeoplePassword());
                this.setCookie(request, response, (BaseCookieEnum)CookieConstEnum.PEOPLE_COOKIE, (Object)JSONObject.toJSONString((Object)tempPeople), 86400 * people.getPeopleAutoLogin());
            }
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_LOGIN, true, JSONObject.toJSONString((Object)tempPeople));
        } else {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_LOGIN, false, this.getResString("err.error", new String[]{this.getResString("pepple.no.exist")}));
        }
    }

    @RequestMapping(value={"/checkLoginStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public void checkLoginStatus(HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession(request);
        this.outJson(response, people != null);
    }

    @RequestMapping(value={"/checkResetPasswordCode"}, method={RequestMethod.POST})
    @ResponseBody
    public void checkResetPasswordCode(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtil.isBlank((String)this.getRandCode(request)) || !this.checkRandCode(request)) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("rand.code")}));
            return;
        }
        PeopleEntity _people = (PeopleEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.PEOPLE_EXISTS_SESSION);
        if (_people == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.not.exist", new String[]{this.getResString("people")}));
            return;
        }
        this.LOG.debug((Object)(_people.getPeoplePhoneCheck() + ":" + PeopleEnum.PHONE_CHECK.toInt()));
        this.LOG.debug((Object)(_people.getPeopleCode() + ":" + people.getPeopleCode()));
        if (_people.getPeoplePhoneCheck() == PeopleEnum.PHONE_CHECK.toInt() && _people.getPeopleCode().equals(people.getPeopleCode())) {
            this.setSession(request, (BaseSessionEnum)SessionConstEnum.PEOPLE_RESET_PASSWORD_SESSION, (Object)_people);
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true, this.getResString("success", new String[]{this.getResString("people.get.password")}));
        } else if (_people.getPeopleMailCheck() == PeopleEnum.MAIL_CHECK.toInt() && _people.getPeopleCode().equals(people.getPeopleCode())) {
            this.setSession(request, (BaseSessionEnum)SessionConstEnum.PEOPLE_RESET_PASSWORD_SESSION, (Object)_people);
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true, this.getResString("success", new String[]{this.getResString("people.get.password")}));
        } else {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("fail", new String[]{this.getResString("people.get.password")}));
        }
    }

    @RequestMapping(value={"/isExists"}, method={RequestMethod.POST})
    @ResponseBody
    public void isExists(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity _people;
        this.LOG.debug((Object)JSONObject.toJSONString((Object)people));
        if (StringUtil.isBlank((String)people.getPeopleName()) && StringUtil.isBlank((String)people.getPeoplePhone()) && StringUtil.isBlank((String)people.getPeopleMail())) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.empty", new String[]{this.getResString("people.name")}));
            return;
        }
        int appId = this.getAppId(request);
        people.setPeopleAppId(appId);
        if (!StringUtil.isBlank((String)people.getPeopleMail())) {
            people.setPeopleMailCheck((BaseEnum)PeopleEnum.MAIL_CHECK);
        }
        if (!StringUtil.isBlank((String)people.getPeoplePhone())) {
            people.setPeoplePhoneCheck((BaseEnum)PeopleEnum.PHONE_CHECK);
        }
        if ((_people = (PeopleEntity)this.peopleBiz.getEntity((BaseEntity)people)) != null) {
            this.setSession(request, (BaseSessionEnum)SessionConstEnum.PEOPLE_EXISTS_SESSION, (Object)_people);
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
            return;
        }
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false);
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    @ResponseBody
    public void register(@ModelAttribute PeopleUserEntity people, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity _people;
        Object obj;
        this.LOG.debug((Object)"people register");
        if (!this.checkRandCode(request)) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("rand.code")}));
            return;
        }
        if (people == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.empty", new String[]{this.getResString("people")}));
            return;
        }
        int appId = this.getAppId(request);
        if (!StringUtil.isBlank((String)people.getPeopleName())) {
            if (StringUtil.isBlank((String)people.getPeopleName())) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.empty", new String[]{this.getResString("people.name")}));
                return;
            }
            if (people.getPeopleName().contains(" ")) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("people.name") + this.getResString("people.space"));
                return;
            }
            if (!StringUtil.checkLength((String)people.getPeopleName(), (int)3, (int)30)) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.length", new String[]{this.getResString("people.name"), "3", "30"}));
                return;
            }
            PeopleEntity peopleName = this.peopleBiz.getEntityByUserName(people.getPeopleName(), appId);
            if (peopleName != null) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.exist", new String[]{this.getResString("people.name") + peopleName.getPeopleName()}));
                return;
            }
        }
        if (!StringUtil.isBlank((String)people.getPeoplePhone())) {
            PeopleEntity peoplePhone = this.peopleBiz.getEntityByUserName(people.getPeoplePhone(), appId);
            if (peoplePhone != null && peoplePhone.getPeoplePhoneCheck() == PeopleEnum.PHONE_CHECK.toInt()) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.exist", new String[]{this.getResString("people.phone")}));
                return;
            }
            obj = this.getSession(request, (BaseSessionEnum)SessionConstEnum.SEND_CODE_SESSION);
            if (obj != null && (_people = (PeopleEntity)obj).getPeoplePhone().equals(people.getPeoplePhone())) {
                if (_people.getPeopleCode().equals(people.getPeopleCode())) {
                    people.setPeoplePhoneCheck((BaseEnum)PeopleEnum.PHONE_CHECK);
                } else {
                    this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.error", new String[]{this.getResString("people.code")}));
                    return;
                }
            }
        }
        if (!StringUtil.isBlank((String)people.getPeopleMail())) {
            if (people.getPeopleMail().contains(" ")) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("people.mail") + this.getResString("people.space"));
                return;
            }
            PeopleEntity peopleMail = this.peopleBiz.getEntityByUserName(people.getPeopleMail(), appId);
            if (peopleMail != null && peopleMail.getPeopleMailCheck() == PeopleEnum.MAIL_CHECK.toInt()) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.exist", new String[]{this.getResString("people.mail")}));
                return;
            }
            obj = this.getSession(request, (BaseSessionEnum)SessionConstEnum.SEND_CODE_SESSION);
            if (obj != null && (_people = (PeopleEntity)obj).getPeopleMail().equals(people.getPeopleMail())) {
                if (_people.getPeopleCode().equals(people.getPeopleCode())) {
                    people.setPeopleMailCheck((BaseEnum)PeopleEnum.MAIL_CHECK);
                } else {
                    this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.error", new String[]{this.getResString("people.mail")}));
                    return;
                }
            }
        }
        if (StringUtil.isBlank((String)people.getPeoplePassword())) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.empty", new String[]{this.getResString("people.password")}));
            return;
        }
        if (people.getPeoplePassword().contains(" ")) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("people.password") + this.getResString("people.space"));
            return;
        }
        if (people.getPeoplePassword().length() < 6 || people.getPeoplePassword().length() > 30) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.length", new String[]{this.getResString("people.password"), "6", "30"}));
            return;
        }
        people.setPeoplePassword(MD5Util.MD5Encode((String)people.getPeoplePassword(), (String)"utf-8"));
        people.setPeopleAppId(appId);
        people.setPeopleDateTime(new Date());
        this.peopleUserBiz.savePeople((PeopleEntity)people);
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, true, this.getResString("success", new String[]{this.getResString("people.register")}));
        this.LOG.debug((Object)"people register ok");
    }

    @RequestMapping(value={"/resetPassword"}, method={RequestMethod.POST})
    @ResponseBody
    public void resetPassword(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtil.isBlank((String)this.getRandCode(request)) || !this.checkRandCode(request)) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("rand.code")}));
            return;
        }
        if (!StringUtil.checkLength((String)people.getPeoplePassword(), (int)3, (int)12)) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("people.password")}));
            return;
        }
        PeopleEntity _people = (PeopleEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.PEOPLE_RESET_PASSWORD_SESSION);
        if (_people == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.not.exist", new String[]{this.getResString("people")}));
            return;
        }
        if (_people.getPeoplePhoneCheck() == PeopleEnum.PHONE_CHECK.toInt() && _people.getPeopleCode().equals(people.getPeopleCode())) {
            _people.setPeoplePassword(MD5Util.MD5Encode((String)people.getPeoplePassword(), (String)"utf-8"));
            this.peopleBiz.updateEntity((BaseEntity)_people);
            this.LOG.debug((Object)"\u66f4\u65b0\u5bc6\u7801\u6210\u529f");
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true, this.getResString("success", new String[]{this.getResString("people.get.password")}));
        } else if (_people.getPeopleMailCheck() == PeopleEnum.MAIL_CHECK.toInt() && _people.getPeopleCode().equals(people.getPeopleCode())) {
            _people.setPeoplePassword(MD5Util.MD5Encode((String)people.getPeoplePassword(), (String)"utf-8"));
            this.peopleBiz.updateEntity((BaseEntity)_people);
            this.LOG.debug((Object)"\u66f4\u65b0\u5bc6\u7801\u6210\u529f");
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true, this.getResString("success", new String[]{this.getResString("people.get.password")}));
        } else {
            this.LOG.debug((Object)"\u66f4\u65b0\u5bc6\u7801\u5931\u8d25");
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("fail", new String[]{this.getResString("people.get.password")}));
        }
    }

    @RequestMapping(value={"/autoLogin"}, method={RequestMethod.POST})
    @ResponseBody
    public void autoLogin(HttpServletRequest request, HttpServletResponse response) {
        String cookie = this.getCookie(request, (BaseCookieEnum)CookieConstEnum.PEOPLE_COOKIE);
        if (StringUtil.isBlank((String)cookie)) {
            this.outJson(response, false);
            return;
        }
        PeopleEntity people = (PeopleEntity)JSONObject.parseObject((String)cookie, PeopleEntity.class);
        PeopleEntity peopleEntity = this.peopleBiz.getByPeople(people, this.getAppId(request));
        if (peopleEntity != null) {
            this.setPeopleBySession(request, peopleEntity);
            this.outJson(response, true);
        } else {
            this.outJson(response, false);
        }
    }

    @RequestMapping(value={"/sendCode"})
    public void sendCode(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        String receive = request.getParameter("receive");
        String modelCode = request.getParameter("modelCode");
        String thrid = request.getParameter("thrid");
        String type = request.getParameter("type");
        boolean isSession = this.getBoolean(request, "isSession");
        if (StringUtil.isBlank((String)receive)) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.empty", new String[]{this.getResString("receive")}));
            return;
        }
        if (StringUtil.isBlank((String)modelCode)) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.empty", new String[]{"modelCode"}));
            return;
        }
        if (StringUtil.isBlank((String)type)) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.empty", new String[]{this.getResString("type")}));
            return;
        }
        String peopleCode = StringUtil.randomNumber((int)6);
        String _modelCode = this.encryptByAES(request, modelCode);
        this.LOG.debug((Object)("\u524d\u7aef\u4f20\u7684" + modelCode));
        this.LOG.debug((Object)("\u89e3\u5bc6" + _modelCode));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("modelCode", _modelCode);
        params.put("receive", receive);
        params.put("thrid", thrid);
        params.put("content", "{code:'" + peopleCode + "'}");
        params.put("type", type);
        if (isSession) {
            PeopleEntity p;
            if (!this.checkRandCode(request)) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("rand.code")}));
                return;
            }
            Object obj = this.getSession(request, (BaseSessionEnum)SessionConstEnum.SEND_CODE_SESSION);
            if (obj != null && DateUtil.diffSec((DateUtil)new DateUtil(), (DateUtil)new DateUtil((p = (PeopleEntity)obj).getPeopleCodeSendDate().getTime())) == 60L) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("people.code.time.error"));
                return;
            }
            PeopleEntity _people = new PeopleEntity();
            _people.setPeopleCode(peopleCode);
            _people.setPeopleCodeSendDate(DateUtil.dateToTimestamp((Date)new Date()));
            this.setSession(request, (BaseSessionEnum)SessionConstEnum.SEND_CODE_SESSION, (Object)_people);
            String contentt = HttpUtil.post((String)(this.getUrl(request) + "/msend/send.do"), params);
            ResultJson rs = (ResultJson)JSONObject.parseObject((String)contentt, ResultJson.class);
            this.outJson(response, (Object)rs.getResultMsg());
            this.LOG.debug((Object)("send " + receive + ":content " + peopleCode));
            return;
        }
        if (StringUtil.isMobile((String)receive)) {
            people.setPeoplePhone(receive);
        } else {
            people.setPeopleMail(receive);
        }
        if (StringUtil.isBlank((String)people.getPeopleName()) && this.getPeopleBySession() == null) {
            if (!StringUtil.isBlank((String)people.getPeopleMail())) {
                people.setPeopleMailCheck((BaseEnum)PeopleEnum.MAIL_CHECK);
            }
            if (!StringUtil.isBlank((String)people.getPeoplePhone())) {
                people.setPeoplePhoneCheck((BaseEnum)PeopleEnum.PHONE_CHECK);
            }
        }
        int appId = this.getAppId(request);
        people.setPeopleAppId(appId);
        PeopleEntity peopleEntity = (PeopleEntity)this.peopleBiz.getEntity((BaseEntity)people);
        if (peopleEntity == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.not.exist", new String[]{this.getResString("people")}));
            return;
        }
        if (peopleEntity.getPeopleUser() != null) {
            CodeBean code = new CodeBean();
            code.setCode(peopleCode);
            code.setUserName(peopleEntity.getPeopleUser().getPuNickname());
            params.put("content", JSONObject.toJSONString((Object)code));
        }
        peopleEntity.setPeopleCode(peopleCode);
        peopleEntity.setPeopleCodeSendDate(DateUtil.dateToTimestamp((Date)new Date()));
        this.peopleBiz.updateEntity((BaseEntity)peopleEntity);
        PeopleEntity _people = (PeopleEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.PEOPLE_EXISTS_SESSION);
        if (_people != null) {
            this.setSession(request, (BaseSessionEnum)SessionConstEnum.PEOPLE_EXISTS_SESSION, (Object)peopleEntity);
        }
        String content = HttpUtil.post((String)(this.getUrl(request) + "/msend/send.do"), params);
        this.LOG.debug((Object)("content :" + content));
        ResultJson rs = (ResultJson)JSONObject.parseObject((String)content, ResultJson.class);
        if (rs != null) {
            this.outJson(response, true);
        }
        this.LOG.debug((Object)("send " + receive + ":content " + peopleCode));
    }

    @RequestMapping(value={"/checkSendCode"}, method={RequestMethod.POST})
    public void checkSendCode(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        String code = request.getParameter("code");
        String receive = request.getParameter("receive");
        if (StringUtil.isBlank((String)code)) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("people.code")}));
            return;
        }
        if (StringUtil.isMobile((String)receive)) {
            people.setPeoplePhone(receive);
        }
        if (StringUtil.isEmail((String)receive).booleanValue()) {
            people.setPeopleMail(receive);
        }
        int appId = this.getAppId(request);
        people.setPeopleAppId(appId);
        PeopleEntity peopleEntity = (PeopleEntity)this.peopleBiz.getEntity((BaseEntity)people);
        if (BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.SEND_CODE_SESSION) != null) {
            peopleEntity = (PeopleEntity)BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.SEND_CODE_SESSION);
            if (!peopleEntity.getPeopleCode().equals(code)) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("people.code")}));
                return;
            }
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
        } else {
            String date;
            if (StringUtil.isMobile((String)receive)) {
                if (peopleEntity.getPeoplePhoneCheck() == PeopleEnum.PHONE_CHECK.toInt()) {
                    this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false);
                    return;
                }
            } else if (peopleEntity.getPeopleMailCheck() == PeopleEnum.MAIL_CHECK.toInt()) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false);
                return;
            }
            if (DateUtil.secondBetween((String)(date = peopleEntity.getPeopleCodeSendDate().toString())) > 86400) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("people.msg.code.error"));
                return;
            }
            if (!peopleEntity.getPeopleCode().equals(code)) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("people.code")}));
                return;
            }
            peopleEntity.setPeopleCode("");
            if (StringUtil.isMobile((String)receive)) {
                peopleEntity.setPeoplePhoneCheck((BaseEnum)PeopleEnum.PHONE_CHECK);
            } else {
                peopleEntity.setPeopleMailCheck((BaseEnum)PeopleEnum.MAIL_CHECK);
            }
            this.peopleBiz.updateEntity((BaseEntity)peopleEntity);
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
        }
    }

    @RequestMapping(value={"/cancelBind"}, method={RequestMethod.POST})
    public void cancelBind(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        String code = request.getParameter("code");
        String receive = request.getParameter("receive");
        if (StringUtil.isBlank((String)code)) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("people.code")}));
            return;
        }
        if (StringUtil.isMobile((String)receive)) {
            people.setPeoplePhone(receive);
        }
        if (StringUtil.isEmail((String)receive).booleanValue()) {
            people.setPeopleMail(receive);
        }
        int appId = this.getAppId(request);
        people.setPeopleAppId(appId);
        PeopleEntity peopleEntity = (PeopleEntity)this.peopleBiz.getEntity((BaseEntity)people);
        if (BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.SEND_CODE_SESSION) != null) {
            peopleEntity = (PeopleEntity)BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.SEND_CODE_SESSION);
            if (!peopleEntity.getPeopleCode().equals(code)) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("people.code")}));
                return;
            }
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
        } else {
            String date;
            if (StringUtil.isMobile((String)receive)) {
                if (peopleEntity.getPeoplePhoneCheck() == PeopleEnum.PHONE_NO_CHECK.toInt()) {
                    this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false);
                    return;
                }
            } else if (peopleEntity.getPeopleMailCheck() == PeopleEnum.MAIL_NO_CHECK.toInt()) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false);
                return;
            }
            if (DateUtil.secondBetween((String)(date = peopleEntity.getPeopleCodeSendDate().toString())) > 86400) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("people.msg.code.error"));
                return;
            }
            if (!peopleEntity.getPeopleCode().equals(code)) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("people.code")}));
                return;
            }
            peopleEntity.setPeopleCode("");
            if (StringUtil.isMobile((String)receive)) {
                peopleEntity.setPeoplePhoneCheck((BaseEnum)PeopleEnum.PHONE_NO_CHECK);
            } else {
                peopleEntity.setPeopleMailCheck((BaseEnum)PeopleEnum.MAIL_NO_CHECK);
            }
            this.peopleBiz.updateEntity((BaseEntity)peopleEntity);
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
        }
    }
}

