/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.base.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.mingsoft.base.constant.Const;
import com.mingsoft.base.constant.e.BaseCookieEnum;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.entity.ResultJson;
import com.mingsoft.util.Base64Util;
import com.mingsoft.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class BaseAction {
    @Value(value="${managerPath}")
    protected String managerPath;
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private final String PAGE_NO = "pageNo";
    private final String PAGE_SIZE = "pageSize";
    private static String[] mobileGateWayHeaders = new String[]{"ZXWAP", "chinamobile.com", "monternet.com", "infoX", "XMS 724Solutions HTG", "wap.lizongbo.com", "Bytemobile"};
    private static String[] pcHeaders = new String[]{"Windows 98", "Windows ME", "Windows 2000", "Windows XP", "Windows NT", "Ubuntu"};
    private static String[] mobileUserAgents = new String[]{"Nokia", "SAMSUNG", "MIDP-2", "CLDC1.1", "SymbianOS", "MAUI", "UNTRUSTED/1.0", "Windows CE", "iPhone", "iPad", "Android", "BlackBerry", "UCWEB", "ucweb", "BREW", "J2ME", "YULONG", "YuLong", "COOLPAD", "TIANYU", "TY-", "K-Touch", "Haier", "DOPOD", "Lenovo", "LENOVO", "HUAQIN", "AIGO-", "CTC/1.0", "CTC/2.0", "CMCC", "DAXIAN", "MOT-", "SonyEricsson", "GIONEE", "HTC", "ZTE", "HUAWEI", "webOS", "GoBrowser", "IEMobile", "WAP2.0"};

    protected Integer getPageNo(HttpServletRequest request) {
        return this.getInt(request, "pageNo", 1);
    }

    protected Integer getPageSize(HttpServletRequest request) {
        return this.getPageSize(request, 10);
    }

    protected Integer getPageSize(HttpServletRequest request, int pageSize) {
        return this.getInt(request, "pageSize", pageSize);
    }

    protected Integer getInt(HttpServletRequest request, String param) {
        String value = request.getParameter(param);
        if (StringUtil.isInteger((String)value)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    protected Integer getInt(HttpServletRequest request, String param, int def) {
        String value = request.getParameter(param);
        if (StringUtil.isInteger((String)value)) {
            return Integer.parseInt(value);
        }
        return def;
    }

    protected Integer getIntBase64(HttpServletRequest request, String param) {
        String value = request.getParameter(param);
        if (StringUtil.isInteger((String)value)) {
            return Integer.parseInt(new String(Base64Util.decode((String)value)));
        }
        return null;
    }

    protected Boolean getBoolean(HttpServletRequest request, String param) {
        String value = request.getParameter(param);
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Object getSession(HttpServletRequest request, BaseSessionEnum key) {
        return request.getSession().getAttribute(key.toString());
    }

    protected void setSession(HttpServletRequest request, BaseSessionEnum key, Object value) {
        request.getSession().setAttribute(key.toString(), value);
    }

    protected void removeSession(HttpServletRequest request, BaseSessionEnum key) {
        request.getSession().removeAttribute(key.toString());
    }

    protected String getCookie(HttpServletRequest request, BaseCookieEnum key) {
        if (request.getCookies() != null) {
            for (Cookie c : request.getCookies()) {
                if (!c.getName().equals(key.toString())) continue;
                return c.getValue();
            }
        }
        return null;
    }

    protected void setCookie(HttpServletRequest request, HttpServletResponse response, BaseCookieEnum key, Object value) {
        request.getSession().setAttribute(key.toString(), value);
        Cookie cookie = new Cookie(key.toString(), (String)value);
        cookie.setPath("/");
        cookie.setValue((String)value);
        response.addCookie(cookie);
    }

    protected void setCookie(HttpServletRequest request, HttpServletResponse response, BaseCookieEnum key, Object value, int maxAge) {
        request.getSession().setAttribute(key.toString(), value);
        Cookie cookie = new Cookie(key.toString(), value.toString());
        cookie.setPath("/");
        cookie.setValue(value.toString());
        cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }

    protected void outJson(HttpServletResponse response, BaseEnum code, boolean flag, String msg, Object data) {
        try {
            response.setContentType("application/json;charset=utf-8");
            ResultJson result = new ResultJson();
            if (code != null) {
                result.setCode(code.toString());
            }
            result.setResult(flag);
            result.setResultMsg(msg);
            result.setResultData(data);
            response.setCharacterEncoding("utf-8");
            PrintWriter out = response.getWriter();
            out.print(JSONObject.toJSON((Object)result));
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.LOG.error((Object)e);
        }
    }

    protected void outJson(HttpServletResponse response, BaseEnum code, boolean flag, String msg) {
        this.outJson(response, code, flag, msg, null);
    }

    protected void outJson(HttpServletResponse response, boolean flag, String msg) {
        this.outJson(response, null, flag, msg, null);
    }

    protected void outJson(HttpServletResponse response, BaseEnum code, boolean flag) {
        this.outJson(response, code, flag, null, null);
    }

    protected void outJson(HttpServletResponse response, boolean flag) {
        this.outJson(response, null, flag, null, null);
    }

    protected void outJson(HttpServletResponse response, Object jsonDataStr) {
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter out = response.getWriter();
            out.print(jsonDataStr);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.LOG.error((Object)e);
        }
    }

    protected void outJson(HttpServletResponse response, BaseEntity entity) {
        this.outJson(response, JSONObject.toJSONString((Object)entity));
    }

    protected void outJson(HttpServletResponse response, List list) {
        this.outJson(response, JSONArray.toJSONString((Object)list));
    }

    protected void outJson(HttpServletResponse response, List list, final String ... filters) {
        PropertyFilter filter = new PropertyFilter(){

            public boolean apply(Object source, String name, Object value) {
                List<String> list = Arrays.asList(filters);
                return !list.contains(name);
            }
        };
        SerializeWriter sw = new SerializeWriter();
        JSONSerializer serializer = new JSONSerializer(sw);
        serializer.getPropertyFilters().add(filter);
        serializer.write((Object)list);
        this.outJson(response, sw);
    }

    protected void outJson(HttpServletResponse response, Object obj, final String ... filters) {
        PropertyFilter filter = new PropertyFilter(){

            public boolean apply(Object source, String name, Object value) {
                List<String> list = Arrays.asList(filters);
                return !list.contains(name);
            }
        };
        SerializeWriter sw = new SerializeWriter();
        JSONSerializer serializer = new JSONSerializer(sw);
        serializer.getPropertyFilters().add(filter);
        serializer.write(obj);
        this.outJson(response, sw);
    }

    protected void outJson(HttpServletResponse response, List list, String dateFmt) {
        this.outJson(response, JSONArray.toJSONStringWithDateFormat((Object)list, (String)dateFmt, (SerializerFeature[])new SerializerFeature[0]));
    }

    protected void redirect(HttpServletResponse response, String path) {
        this.outString(response, "<script>location.href='" + path + "'</script>");
    }

    protected void outString(HttpServletResponse response, Object dataStr) {
        try {
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = response.getWriter();
            out.print(dataStr);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.LOG.error((Object)e);
        }
    }

    protected String getUrl(HttpServletRequest request) {
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName();
        basePath = request.getServerPort() == 80 ? basePath + path : basePath + ":" + request.getServerPort() + path;
        return basePath;
    }

    protected String getDomain(HttpServletRequest request) {
        String path = request.getContextPath();
        String domain = request.getServerName();
        domain = request.getServerPort() == 80 ? domain + path : domain + ":" + request.getServerPort() + path;
        return domain;
    }

    protected String getHost(HttpServletRequest request) {
        String basePath = request.getServerName();
        if (request.getServerPort() != 80) {
            basePath = basePath + ":" + request.getServerPort();
        }
        return basePath;
    }

    protected String getHostIp() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress().toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected String getResString(String key) {
        return Const.RESOURCES.getString(key);
    }

    protected String getResString(String key, ResourceBundle rb) {
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException e) {
            return Const.RESOURCES.getString(key);
        }
    }

    protected String getResString(String key, String ... fullStrs) {
        String temp = this.getResString(key);
        for (int i = 0; i < fullStrs.length; ++i) {
            temp = temp.replace("{" + i + "}", fullStrs[i]);
        }
        return temp;
    }

    protected String getResString(String key, ResourceBundle rb, String ... fullStrs) {
        String temp = "";
        try {
            temp = rb.getString(key);
        }
        catch (MissingResourceException e) {
            temp = this.getResString(key);
        }
        for (int i = 0; i < fullStrs.length; ++i) {
            temp = temp.replace("{" + i + "}", fullStrs[i]);
        }
        return temp;
    }

    protected Object getBean(ServletContext sc, String beanName) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc).getBean(beanName);
    }

    protected Object getBean(String beanName) {
        return Const.CONTEXT.getBean(beanName);
    }

    public boolean isMobileDevice(HttpServletRequest request) {
        int i;
        boolean b = false;
        boolean pcFlag = false;
        boolean mobileFlag = false;
        String via = request.getHeader("Via");
        String userAgent = request.getHeader("user-agent");
        for (i = 0; via != null && !via.trim().equals("") && i < mobileGateWayHeaders.length; ++i) {
            if (!via.contains(mobileGateWayHeaders[i])) continue;
            mobileFlag = true;
            break;
        }
        for (i = 0; !mobileFlag && userAgent != null && !userAgent.trim().equals("") && i < mobileUserAgents.length; ++i) {
            if (!userAgent.contains(mobileUserAgents[i])) continue;
            mobileFlag = true;
            break;
        }
        for (i = 0; userAgent != null && !userAgent.trim().equals("") && i < pcHeaders.length; ++i) {
            if (!userAgent.contains(pcHeaders[i])) continue;
            pcFlag = true;
            break;
        }
        if (mobileFlag && !pcFlag) {
            b = true;
        }
        return b;
    }

    protected Map<String, String> getMapByProperties(String filePath) {
        if (StringUtil.isBlank((String)filePath)) {
            return null;
        }
        ResourceBundle rb = ResourceBundle.getBundle(filePath);
        return this.getMapByProperties(rb);
    }

    protected Map<String, String> getMapByProperties(ResourceBundle rb) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> en = rb.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            map.put(key, rb.getString(key));
        }
        return map;
    }

    protected String getRealPath(HttpServletRequest request, String filePath) {
        return request.getServletContext().getRealPath("") + File.separator + filePath;
    }

    @Deprecated
    protected Map<String, Object> assemblyRequestMap(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map map = request.getParameterMap();
        for (String k : map.keySet()) {
            String[] value = (String[])map.get(k);
            if (value.length == 1) {
                String temp = null;
                if (!StringUtil.isBlank((String)value[0])) {
                    temp = value[0];
                }
                params.put(k, temp);
                request.setAttribute(k, (Object)temp);
                continue;
            }
            if (value.length == 0) {
                params.put(k, null);
                request.setAttribute(k, null);
                continue;
            }
            if (value.length <= 1) continue;
            params.put(k, value);
            request.setAttribute(k, (Object)value);
        }
        return params;
    }

    protected String assemblyRequestUrlParams(HttpServletRequest request) {
        return this.assemblyRequestUrlParams(request, null);
    }

    @Deprecated
    protected String assemblyRequestUrlParams(HttpServletRequest request, String[] filter) {
        Map map = request.getParameterMap();
        Iterator key = map.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (key.hasNext()) {
            String k = (String)key.next();
            if (filter != null && Arrays.asList(filter).contains(k)) continue;
            String[] value = (String[])map.get(k);
            if (value.length == 1) {
                String temp = null;
                if (!StringUtil.isBlank((String)value[0])) {
                    temp = value[0];
                }
                sb.append(k).append("=").append(temp).append("&");
                continue;
            }
            if (value.length <= 1) continue;
            sb.append(k).append("=").append(value).append("&");
        }
        this.LOG.debug((Object)("url params" + sb.toString()));
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected String readStreamParameter(HttpServletRequest request) {
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "utf-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return buffer.toString();
    }

    public String getIp(HttpServletRequest request) {
        String ipAddress = null;
        ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && (ipAddress = request.getRemoteAddr()).equals("127.0.0.1")) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public String getMACAddress(String ip) {
        String str = "";
        String macAddress = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            for (int i = 1; i < 100; ++i) {
                str = input.readLine();
                if (str == null || str.indexOf("MAC Address") <= 1) continue;
                macAddress = str.substring(str.indexOf("MAC Address") + 14, str.length());
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        return macAddress;
    }
}

