/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.service;

import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.internal.util.ResourceScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DirectoryWatcher {
    private Logger logger = LoggerFactory.getLogger(DirectoryWatcher.class);
    private Pattern matcher;
    private final Set<File> rootDirs = new HashSet<File>();
    private final Map<File, FileEntry> entries = new HashMap<File, FileEntry>();

    public DirectoryWatcher(Collection<String> paths, Pattern matcher) {
        if (paths != null) {
            this.matcher = matcher;
            this.logger.info("Tracking resources for changes");
            List<URI> uris = ResourceScanner.toURIs(paths);
            for (URI uri : uris) {
                try {
                    Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(uri.getSchemeSpecificPart());
                    while (resources.hasMoreElements()) {
                        URL url = resources.nextElement();
                        File dir = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
                        if (!dir.exists() || !dir.isDirectory()) continue;
                        this.logger.info("Tracking directory:" + dir.getAbsolutePath());
                        this.rootDirs.add(dir);
                        this.update(dir);
                    }
                }
                catch (IOException e1) {
                    throw new WebApplicationException(e1);
                }
            }
        }
    }

    public void registerDirectory(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot register null directory");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " is not a directory");
        }
    }

    private void update(File file) {
        if (file != null && file.exists()) {
            this.entries.put(file, new FileEntry(file));
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    this.update(child);
                }
            }
        }
    }

    private boolean hasChanged(File file) {
        if (file.isFile() && !this.matcher.matcher(file.getName()).matches()) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        FileEntry entry = this.entries.get(file);
        if (entry == null) {
            return true;
        }
        if (entry.hasChanged(file)) {
            return true;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (!this.hasChanged(child)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasChanged() {
        for (File root : this.rootDirs) {
            if (!this.hasChanged(root)) continue;
            this.reload();
            return true;
        }
        return false;
    }

    private void reload() {
        this.entries.clear();
        for (File root1 : this.rootDirs) {
            this.update(root1);
        }
    }

    private static class FileEntry {
        long lastModified;
        long fileCount;

        FileEntry(File file) {
            this.lastModified = file.lastModified();
            if (file.isDirectory()) {
                this.fileCount = file.list().length;
            }
        }

        boolean hasChanged(File file) {
            if (file.isFile() && file.lastModified() != this.lastModified) {
                return true;
            }
            return file.isDirectory() && this.fileCount != (long)file.list().length;
        }
    }
}

