/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.component;

import net.contextfw.web.application.component.Script;
import net.contextfw.web.application.component.ScriptContext;

public class FunctionCall
extends Script {
    private final String function;
    private final Object[] args;

    public FunctionCall(String function, Object ... args) {
        this.function = function;
        this.args = args;
    }

    protected static String toScript(String function, int argCount, boolean isFull) {
        StringBuilder b = new StringBuilder(function).append("(");
        String delim = "";
        for (int i = 0; i < argCount; ++i) {
            b.append(delim).append("{").append(i).append("}");
            delim = ",";
        }
        b.append(")");
        if (isFull) {
            b.append(";\n");
        }
        return b.toString();
    }

    @Override
    public String getScript(ScriptContext scriptContext) {
        return this.getScript(scriptContext, true);
    }

    protected String getScript(ScriptContext scriptContext, boolean isFull) {
        return FunctionCall.toScript(this.getFunctionName(scriptContext), this.args == null ? 0 : this.args.length, isFull);
    }

    @Override
    public Object[] getArguments(ScriptContext scriptContext) {
        return this.args;
    }

    protected String getFunctionName(ScriptContext scriptContext) {
        return this.function;
    }
}

