/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application;

import java.util.Locale;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.contextfw.web.application.lifecycle.PageScoped;

@PageScoped
public class PageContext {
    private transient HttpServlet servlet;
    private transient HttpServletRequest request;
    private transient HttpServletResponse response;
    private final String requestURI;
    private final String queryString;
    private String redirectUrl;
    private String errorMsg;
    private Integer errorCode;
    private boolean reload = false;
    private Locale locale;

    public void reload() {
        this.reload = true;
    }

    public void redirect(String url) {
        this.redirectUrl = url;
    }

    public void sendError(int code) {
        this.sendError(code, null);
    }

    public void sendError(int code, String msg) {
        this.errorCode = code;
        this.errorMsg = msg;
    }

    public void setServlet(HttpServlet servlet) {
        this.servlet = servlet;
    }

    public HttpServlet getServlet() {
        return this.servlet;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public PageContext(HttpServlet servlet, HttpServletRequest request, HttpServletResponse response) {
        this.servlet = servlet;
        this.request = request;
        this.response = response;
        this.requestURI = request.getRequestURI();
        this.queryString = request.getQueryString();
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public boolean isReload() {
        return this.reload;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

