/*
 * Decompiled with CFR 0.152.
 */
package me.normanmaurer.maven.autobahntestsuite;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import me.normanmaurer.maven.autobahntestsuite.AutobahnTestSuite;
import me.normanmaurer.maven.autobahntestsuite.AutobahnUtils;
import me.normanmaurer.maven.autobahntestsuite.FuzzingCaseResult;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="fuzzingclient", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class FuzzingClientMojo
extends AbstractMojo {
    private static final List<String> ALL_CASES = Collections.unmodifiableList(Arrays.asList("*"));
    private static final Map<String, Object> OPTIONS = Collections.singletonMap("version", 18);
    private static final String AGENT = "autobahntestsuite-maven-plugin";
    @Parameter(defaultValue="-1", property="port", required=true)
    private int port;
    @Parameter(property="cases")
    private List<String> cases;
    @Parameter(property="excludeCases")
    private List<String> excludeCases;
    @Parameter(property="mainClass", required=true)
    private String mainClass;
    @Parameter(property="waitTime")
    private long waitTime;
    @Parameter(property="failOnNonStrict")
    private boolean failOnNonStrict;
    @Parameter(property="generateJUnitXml", defaultValue="true")
    private boolean generateJUnitXml;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Component
    private MavenProject project;

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getTestClasspathElements();
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            classpathElements.add(this.project.getBuild().getTestOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip execution of autobahntestsuite-maven-plugin");
            return;
        }
        final AtomicReference error = new AtomicReference();
        Thread runner = null;
        try {
            String host;
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                this.getLog().debug((CharSequence)"Unable to detect localhost address, using 127.0.0.1 as fallback");
                host = "127.0.0.1";
            }
            if (this.port == -1) {
                this.port = AutobahnUtils.getFreePort(host);
            }
            runner = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader(FuzzingClientMojo.this.getClassLoader());
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(FuzzingClientMojo.this.mainClass);
                        Method main = clazz.getMethod("main", String[].class);
                        main.invoke(null, new Object[]{new String[]{String.valueOf(FuzzingClientMojo.this.port)}});
                    }
                    catch (Exception e) {
                        error.set(e);
                    }
                }
            });
            runner.setDaemon(true);
            runner.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            if (this.waitTime <= 0L) {
                this.waitTime = 10000L;
            }
            long sleepTime = this.waitTime / 10L;
            for (int i = 0; i < 10; ++i) {
                Throwable cause = (Throwable)error.get();
                if (cause != null) {
                    throw new MojoExecutionException("Unable to start server", cause);
                }
                Socket socket = new Socket();
                try {
                    socket.connect(new InetSocketAddress(host, this.port));
                    break;
                }
                catch (IOException e) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                }
                if (i != 9) continue;
                throw new MojoExecutionException("Unable to connect to server in " + this.waitTime, (Exception)error.get());
            }
            if (this.cases == null || this.cases.isEmpty()) {
                this.cases = ALL_CASES;
            }
            if (this.excludeCases == null) {
                this.excludeCases = Collections.emptyList();
            }
            List<FuzzingCaseResult> results = AutobahnTestSuite.runFuzzingClient(AGENT, "ws://" + host + ":" + this.port, OPTIONS, this.cases, this.excludeCases);
            if (this.generateJUnitXml) {
                try {
                    this.writeJUnitXmlReport(results);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to generate JUnit Xml", e);
                }
            }
            ArrayList<FuzzingCaseResult> failed = new ArrayList<FuzzingCaseResult>();
            for (FuzzingCaseResult result : results) {
                FuzzingCaseResult.Behavior behavior = result.behavior();
                if (this.failOnNonStrict && behavior == FuzzingCaseResult.Behavior.NON_STRICT) {
                    failed.add(result);
                    continue;
                }
                if (behavior == FuzzingCaseResult.Behavior.OK || behavior == FuzzingCaseResult.Behavior.INFORMATIONAL || behavior == FuzzingCaseResult.Behavior.NON_STRICT) continue;
                failed.add(result);
            }
            if (!failed.isEmpty()) {
                StringBuilder sb = new StringBuilder("\nFailed test cases:\n");
                for (FuzzingCaseResult result : failed) {
                    sb.append("\t");
                    sb.append(result.toString());
                    sb.append("\n");
                }
                throw new MojoFailureException(sb.toString());
            }
            this.getLog().info((CharSequence)"All test cases passed");
        }
        finally {
            if (runner != null) {
                runner.interrupt();
            }
        }
    }

    private void writeJUnitXmlReport(List<FuzzingCaseResult> results) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        String className = ((Object)((Object)this)).getClass().getName();
        int failures = 0;
        long suiteDuration = 0L;
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("testsuite");
        rootElement.setAttribute("name", className);
        rootElement.setAttribute("tests", Integer.toString(results.size()));
        rootElement.setAttribute("errors", Integer.toString(0));
        rootElement.setAttribute("skipped", Integer.toString(0));
        for (FuzzingCaseResult r : results) {
            Element testcase = doc.createElement("testcase");
            testcase.setAttribute("classname", "AutobahnTestCase");
            testcase.setAttribute("name", r.caseName());
            long duration = r.duration();
            suiteDuration += duration;
            testcase.setAttribute("time", Double.toString((double)duration / 1000.0));
            FuzzingCaseResult.Behavior behavior = r.behavior();
            if (this.failOnNonStrict && behavior == FuzzingCaseResult.Behavior.NON_STRICT) {
                this.addFailure(doc, testcase, r);
                ++failures;
            } else if (behavior != FuzzingCaseResult.Behavior.OK && behavior != FuzzingCaseResult.Behavior.INFORMATIONAL && behavior != FuzzingCaseResult.Behavior.NON_STRICT) {
                this.addFailure(doc, testcase, r);
                ++failures;
            }
            rootElement.appendChild(testcase);
        }
        rootElement.setAttribute("failures", Integer.toString(failures));
        rootElement.setAttribute("time", Double.toString((double)suiteDuration / 1000.0));
        doc.appendChild(rootElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        String filename = "target/autobahntestsuite-reports/TEST-" + className + ".xml";
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(filename));
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFailure(Document doc, Element testCase, FuzzingCaseResult result) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(new FileInputStream(result.reportFile()));
            JSONObject object = (JSONObject)parser.parse((Reader)reader);
            Element sysout = doc.createElement("system-out");
            sysout.appendChild(doc.createTextNode(object.toJSONString()));
            testCase.appendChild(sysout);
            String description = object.get((Object)"description").toString();
            String resultText = object.get((Object)"result").toString();
            String expected = object.get((Object)"expected").toString();
            String received = object.get((Object)"received").toString();
            StringBuffer fail = new StringBuffer();
            fail = fail.append(description).append("\n\n");
            fail = fail.append("Case outcome").append("\n\n");
            fail = fail.append(resultText).append("\n\n");
            fail = fail.append("Expected").append("\n").append(expected).append("\n\n");
            fail = fail.append("Received").append("\n").append(received).append("\n\n");
            Element failure = doc.createElement("failure");
            failure.setAttribute("type", "behaviorMissmatch");
            failure.appendChild(doc.createTextNode(fail.toString()));
            testCase.appendChild(failure);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

