/*
 * Decompiled with CFR 0.152.
 */
package me.normanmaurer.maven.autobahntestsuite;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class AutobahnUtils {
    private static final int START_PORT = 32768;
    private static final int END_PORT = 65536;
    private static final int NUM_CANDIDATES = 32768;
    private static final List<Integer> PORTS = new ArrayList<Integer>(32768);
    private static Iterator<Integer> portIterator;

    AutobahnUtils() {
    }

    private static int nextCandidatePort() {
        if (portIterator == null || !portIterator.hasNext()) {
            portIterator = PORTS.iterator();
        }
        return portIterator.next();
    }

    static int getFreePort(String address) {
        for (int i = 0; i < 32768; ++i) {
            int port = AutobahnUtils.nextCandidatePort();
            try {
                ServerSocket ss = new ServerSocket();
                ss.setReuseAddress(false);
                ss.bind(new InetSocketAddress(address, port));
                ss.close();
                return port;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new RuntimeException("unable to find a free port");
    }

    static {
        for (int i = 32768; i < 65536; ++i) {
            PORTS.add(i);
        }
        Collections.shuffle(PORTS);
    }
}

