/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.pay.transfer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.riversoft.weixin.common.WxSslClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.common.util.RandomStringGenerator;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import com.riversoft.weixin.pay.PayWxClientFactory;
import com.riversoft.weixin.pay.base.PaySetting;
import com.riversoft.weixin.pay.base.WxEndpoint;
import com.riversoft.weixin.pay.transfer.bean.TransferRequest;
import com.riversoft.weixin.pay.transfer.bean.TransferResponse;
import com.riversoft.weixin.pay.transfer.bean.TransferResult;
import com.riversoft.weixin.pay.util.SignatureUtil;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transfers {
    private static Logger logger = LoggerFactory.getLogger(Transfers.class);
    private PaySetting paySetting;
    private WxSslClient wxSslClient;

    public void setPaySetting(PaySetting paySetting) {
        this.paySetting = paySetting;
    }

    public static Transfers defaultTransfers() {
        return Transfers.with(PaySetting.defaultSetting());
    }

    public static Transfers with(PaySetting paySetting) {
        Transfers transfers = new Transfers();
        transfers.setPaySetting(paySetting);
        transfers.setWxSslClient(PayWxClientFactory.getInstance().with(paySetting));
        return transfers;
    }

    public void setWxSslClient(WxSslClient wxSslClient) {
        this.wxSslClient = wxSslClient;
    }

    public TransferResponse transfer(TransferRequest transferRequest) {
        TransferRequestWrapper wrapper = new TransferRequestWrapper();
        wrapper.setAppId(this.paySetting.getAppId());
        wrapper.setMchId(this.paySetting.getMchId());
        wrapper.setTransferRequest(transferRequest);
        String nonce = RandomStringGenerator.getRandomStringByLength((int)32);
        wrapper.setNonce(nonce);
        SortedMap transferRequestMap = (SortedMap)JsonMapper.defaultMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        wrapper.setSign(SignatureUtil.sign(transferRequestMap, this.paySetting.getKey()));
        String url = WxEndpoint.get("url.pay.transfer.do");
        try {
            String xml = XmlObjectMapper.defaultMapper().toXml((Object)wrapper);
            logger.info("transfer request: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("got response: {}", (Object)response);
            TransferResponseWrapper transferResponseWrapper = (TransferResponseWrapper)XmlObjectMapper.defaultMapper().fromXml(response, TransferResponseWrapper.class);
            return transferResponseWrapper.getTransferResponse();
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "transfer failed:" + e.getMessage());
        }
    }

    public TransferResult query(String partnerTradeNo) {
        QueryTransferResultRequestWrapper wrapper = new QueryTransferResultRequestWrapper();
        wrapper.setAppId(this.paySetting.getAppId());
        wrapper.setMchId(this.paySetting.getMchId());
        wrapper.setPartnerTradeNo(partnerTradeNo);
        String nonce = RandomStringGenerator.getRandomStringByLength((int)32);
        wrapper.setNonce(nonce);
        SortedMap transferRequestMap = (SortedMap)JsonMapper.defaultMapper().getMapper().convertValue((Object)wrapper, SortedMap.class);
        wrapper.setSign(SignatureUtil.sign(transferRequestMap, this.paySetting.getKey()));
        String url = WxEndpoint.get("url.pay.transfer.query");
        try {
            String xml = XmlObjectMapper.defaultMapper().toXml((Object)wrapper);
            logger.info("transfer query: {}", (Object)xml);
            String response = this.wxSslClient.post(url, xml);
            logger.info("got response: {}", (Object)response);
            TransferResult transferResult = (TransferResult)XmlObjectMapper.defaultMapper().fromXml(response, TransferResult.class);
            return transferResult;
        }
        catch (Exception e) {
            throw new WxRuntimeException(999, "query transfer result failed:" + e.getMessage());
        }
    }

    @JacksonXmlRootElement(localName="xml")
    public static class QueryTransferResultRequestWrapper {
        @JsonProperty(value="partner_trade_no")
        private String partnerTradeNo;
        @JsonProperty(value="appid")
        private String appId;
        @JsonProperty(value="mch_id")
        private String mchId;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String sign;
        @JsonProperty(value="nonce_str")
        private String nonce;

        public String getPartnerTradeNo() {
            return this.partnerTradeNo;
        }

        public void setPartnerTradeNo(String partnerTradeNo) {
            this.partnerTradeNo = partnerTradeNo;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getMchId() {
            return this.mchId;
        }

        public void setMchId(String mchId) {
            this.mchId = mchId;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }
    }

    @JacksonXmlRootElement(localName="xml")
    public static class TransferResponseWrapper {
        @JsonUnwrapped
        private TransferResponse transferResponse;

        public TransferResponse getTransferResponse() {
            return this.transferResponse;
        }

        public void setTransferResponse(TransferResponse transferResponse) {
            this.transferResponse = transferResponse;
        }
    }

    @JacksonXmlRootElement(localName="xml")
    public static class TransferRequestWrapper {
        @JsonUnwrapped
        private TransferRequest transferRequest;
        @JsonProperty(value="mch_appid")
        private String appId;
        @JsonProperty(value="mchid")
        private String mchId;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String sign;
        @JsonProperty(value="nonce_str")
        private String nonce;

        public TransferRequest getTransferRequest() {
            return this.transferRequest;
        }

        public void setTransferRequest(TransferRequest transferRequest) {
            this.transferRequest = transferRequest;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getMchId() {
            return this.mchId;
        }

        public void setMchId(String mchId) {
            this.mchId = mchId;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }
    }
}

