/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.user;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.user.bean.Group;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Groups {
    private static Logger logger = LoggerFactory.getLogger(Groups.class);
    private WxClient wxClient;

    public static Groups defaultGroups() {
        return Groups.with(AppSetting.defaultSettings());
    }

    public static Groups with(AppSetting appSetting) {
        Groups groups = new Groups();
        groups.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return groups;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public Group create(String name) {
        String url = WxEndpoint.get("url.group.create");
        String json = String.format("{\"group\":{\"name\":\"%s\"}}", name);
        logger.debug("create group: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        return (Group)JsonMapper.defaultUnwrapRootMapper().fromJson(response, Group.class);
    }

    public List<Group> list() {
        String url = WxEndpoint.get("url.group.list");
        String response = this.wxClient.get(url);
        logger.debug("list groups: {}", (Object)response);
        GroupList groupList = (GroupList)JsonMapper.defaultMapper().fromJson(response, GroupList.class);
        return groupList.getGroups();
    }

    public void update(int id, String name) {
        String url = WxEndpoint.get("url.group.update");
        String json = String.format("{\"group\":{\"id\":%s,\"name\":\"%s\"}}", id, name);
        logger.debug("update group: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public void delete(int id) {
        String url = WxEndpoint.get("url.group.delete");
        String json = String.format("{\"group\":{\"id\":%s}}", id);
        logger.debug("delete group: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public int getUserGroup(String openId) {
        String url = WxEndpoint.get("url.group.user.get");
        String json = String.format("{\"openid\":\"%s\"}", openId);
        logger.debug("get user group: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        HashMap map = JsonMapper.nonEmptyMapper().json2Map(response);
        if (map.containsKey("groupid")) {
            return (Integer)map.get("groupid");
        }
        return -1;
    }

    public void move(String openId, int group) {
        String url = WxEndpoint.get("url.group.user.move");
        String json = String.format("{\"openid\":\"%s\",\"to_groupid\":%s}", openId, group);
        logger.debug("move user group: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public void move(List<String> openIds, int group) {
        String url = WxEndpoint.get("url.group.user.moves");
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("openid_list", openIds);
        request.put("to_groupid", group);
        String json = JsonMapper.defaultMapper().toJson(request);
        logger.debug("move users group: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public static class GroupList {
        private List<Group> groups;

        public List<Group> getGroups() {
            return this.groups;
        }

        public void setGroups(List<Group> groups) {
            this.groups = groups;
        }
    }
}

