/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.template;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.template.Data;
import com.riversoft.weixin.mp.template.Industry;
import com.riversoft.weixin.mp.template.MiniProgram;
import com.riversoft.weixin.mp.template.Template;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Templates {
    private static Logger logger = LoggerFactory.getLogger(Templates.class);
    private WxClient wxClient;

    public static Templates defaultTemplates() {
        return Templates.with(AppSetting.defaultSettings());
    }

    public static Templates with(AppSetting appSetting) {
        Templates templates = new Templates();
        templates.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return templates;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void setIndustries(String primary, String secondary) {
        String url = WxEndpoint.get("url.template.industry.set");
        String json = String.format("{\"industry_id1\":\"%s\", \"industry_id2\":\"%s\"}", primary, secondary);
        logger.debug("template message, set industry: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public Industry getIndustries() {
        String url = WxEndpoint.get("url.template.industry.get");
        logger.debug("template message, get industry.");
        String response = this.wxClient.get(url);
        IndustryWrapper industryWrapper = (IndustryWrapper)JsonMapper.defaultMapper().fromJson(response, IndustryWrapper.class);
        return new Industry(industryWrapper.getPrimary().toString(), industryWrapper.getSecondary().toString());
    }

    public String fetch(String code) {
        String url = WxEndpoint.get("url.template.get");
        String json = String.format("{\"template_id_short\":\"%s\"}", code);
        logger.debug("template message, get template id: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("template_id")) {
            return result.get("template_id").toString();
        }
        throw new WxRuntimeException(999, "fetch template id failed.");
    }

    public List<Template> list() {
        String url = WxEndpoint.get("url.template.list");
        logger.debug("template message, list templates.");
        String response = this.wxClient.get(url);
        TemplateListWrapper templateListWrapper = (TemplateListWrapper)JsonMapper.defaultMapper().fromJson(response, TemplateListWrapper.class);
        return templateListWrapper.getTemplateList();
    }

    public void delete(String templateId) {
        String url = WxEndpoint.get("url.template.delete");
        String json = String.format("{\"template_id\":\"%s\"}", templateId);
        logger.debug("template message, delete template: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public long send(String toUser, String templateId, String url, Map<String, Data> messages) {
        return this.send(toUser, templateId, url, null, messages);
    }

    public long send(String toUser, String templateId, MiniProgram miniProgram, Map<String, Data> messages) {
        return this.send(toUser, templateId, null, miniProgram, messages);
    }

    public long send(String toUser, String templateId, String url, MiniProgram miniProgram, Map<String, Data> messages) {
        String sendUrl = WxEndpoint.get("url.template.send");
        MessageWrapper messageWrapper = new MessageWrapper();
        messageWrapper.setToUser(toUser);
        messageWrapper.setTemplateId(templateId);
        if (url != null) {
            messageWrapper.setUrl(url);
        }
        if (miniProgram != null) {
            messageWrapper.setMiniProgram(miniProgram);
        }
        messageWrapper.setData(messages);
        String json = JsonMapper.defaultMapper().toJson((Object)messageWrapper);
        logger.debug("template message, send message: {}", (Object)json);
        String response = this.wxClient.post(sendUrl, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("msgid")) {
            return ((Number)result.get("msgid")).longValue();
        }
        throw new WxRuntimeException(999, "send template message failed.");
    }

    public static class IndustryClassWrapper {
        @JsonProperty(value="first_class")
        private String first;
        @JsonProperty(value="second_class")
        private String second;

        public String getFirst() {
            return this.first;
        }

        public void setFirst(String first) {
            this.first = first;
        }

        public String getSecond() {
            return this.second;
        }

        public void setSecond(String second) {
            this.second = second;
        }

        public String toString() {
            return this.first + "|" + this.second;
        }
    }

    public static class IndustryWrapper {
        @JsonProperty(value="primary_industry")
        private IndustryClassWrapper primary;
        @JsonProperty(value="secondary_industry")
        private IndustryClassWrapper secondary;

        public IndustryClassWrapper getPrimary() {
            return this.primary;
        }

        public void setPrimary(IndustryClassWrapper primary) {
            this.primary = primary;
        }

        public IndustryClassWrapper getSecondary() {
            return this.secondary;
        }

        public void setSecondary(IndustryClassWrapper secondary) {
            this.secondary = secondary;
        }
    }

    public static class TemplateListWrapper {
        @JsonProperty(value="template_list")
        private List<Template> templateList;

        public List<Template> getTemplateList() {
            return this.templateList;
        }

        public void setTemplateList(List<Template> templateList) {
            this.templateList = templateList;
        }
    }

    public static class MessageWrapper {
        @JsonProperty(value="touser")
        private String toUser;
        @JsonProperty(value="template_id")
        private String templateId;
        private String url;
        @JsonProperty(value="miniprogram")
        private MiniProgram miniProgram;
        private Map<String, Data> data;

        public String getToUser() {
            return this.toUser;
        }

        public void setToUser(String toUser) {
            this.toUser = toUser;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public MiniProgram getMiniProgram() {
            return this.miniProgram;
        }

        public void setMiniProgram(MiniProgram miniProgram) {
            this.miniProgram = miniProgram;
        }

        public Map<String, Data> getData() {
            return this.data;
        }

        public void setData(Map<String, Data> data) {
            this.data = data;
        }
    }
}

