/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.stat;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.stat.bean.UserCumulative;
import com.riversoft.weixin.mp.stat.bean.UserSummary;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stats {
    private static Logger logger = LoggerFactory.getLogger(Stats.class);
    private WxClient wxClient;

    public static Stats defaultStats() {
        return Stats.with(AppSetting.defaultSettings());
    }

    public static Stats with(AppSetting appSetting) {
        Stats stats = new Stats();
        stats.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return stats;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public List<UserSummary> getUserSummary(Date start, Date end) {
        if (this.diffThan6Days(start, end)) {
            throw new IllegalArgumentException("start\u548cend\u76f8\u5dee\u4e0d\u80fd\u8d85\u8fc76\u5929\u4ee5\u4e0a");
        }
        String url = WxEndpoint.get("url.stats.user.summary");
        String json = "{\"begin_date\":\"%s\",\"end_date\":\"%s\"}";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String body = String.format(json, dateFormat.format(start), dateFormat.format(end));
        logger.debug("stats: get user summary: {}", (Object)body);
        String response = this.wxClient.post(url, body);
        UserSummaryWrapper userSummaryWrapper = (UserSummaryWrapper)JsonMapper.defaultMapper().fromJson(response, UserSummaryWrapper.class);
        return userSummaryWrapper.getList();
    }

    public List<UserSummary> getUserSummary(Date start) {
        return this.getUserSummary(start, new Date());
    }

    public List<UserCumulative> getUserCumulative(Date start, Date end) {
        if (this.diffThan6Days(start, end)) {
            throw new IllegalArgumentException("start\u548cend\u76f8\u5dee\u4e0d\u80fd\u8d85\u8fc76\u5929\u4ee5\u4e0a");
        }
        String url = WxEndpoint.get("url.stats.user.cumulative");
        String json = "{\"begin_date\":\"%s\",\"end_date\":\"%s\"}";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String body = String.format(json, dateFormat.format(start), dateFormat.format(end));
        logger.debug("stats: get user summary: {}", (Object)body);
        String response = this.wxClient.post(url, body);
        UserCumulativeWrapper userCumulativeWrapper = (UserCumulativeWrapper)JsonMapper.defaultMapper().fromJson(response, UserCumulativeWrapper.class);
        return userCumulativeWrapper.getList();
    }

    private boolean diffThan6Days(Date start, Date end) {
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTime(start);
        calendarStart.set(10, 0);
        calendarStart.set(12, 0);
        calendarStart.set(13, 0);
        calendarStart.set(14, 0);
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(start);
        calendarEnd.set(10, 0);
        calendarEnd.set(12, 0);
        calendarEnd.set(13, 0);
        calendarEnd.set(14, 0);
        return calendarStart.getTime().getTime() - calendarEnd.getTime().getTime() > 518400000L;
    }

    public List<UserCumulative> getUserCumulative(Date start) {
        return this.getUserCumulative(start, new Date());
    }

    public static class UserCumulativeWrapper {
        private List<UserCumulative> list;

        public List<UserCumulative> getList() {
            return this.list;
        }

        public void setList(List<UserCumulative> list) {
            this.list = list;
        }
    }

    public static class UserSummaryWrapper {
        private List<UserSummary> list;

        public List<UserSummary> getList() {
            return this.list;
        }

        public void setList(List<UserSummary> list) {
            this.list = list;
        }
    }
}

