/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.app.qrcode;

import com.riversoft.weixin.app.AppWxClientFactory;
import com.riversoft.weixin.app.base.AppSetting;
import com.riversoft.weixin.app.base.WxEndpoint;
import com.riversoft.weixin.common.WxClient;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodes {
    private static Logger logger = LoggerFactory.getLogger(QrCodes.class);
    private WxClient wxClient;

    public static QrCodes defaultQrCodes() {
        return QrCodes.with(AppSetting.defaultSettings());
    }

    public static QrCodes with(AppSetting appSetting) {
        QrCodes qrCodes = new QrCodes();
        qrCodes.setWxClient(AppWxClientFactory.getInstance().with(appSetting));
        return qrCodes;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public InputStream create(String path) {
        return this.create(path, 430);
    }

    public InputStream create(String path, int size) {
        String url = WxEndpoint.get("url.qrcode.create");
        String json = "{\"path\": \"%s\", \"width\": %s}";
        return this.wxClient.copyStream(url, String.format(json, path, size));
    }
}

