/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.app.message;

import com.riversoft.weixin.app.event.UserEnterSession;
import com.riversoft.weixin.common.event.EventRequest;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.message.XmlMessageHeader;
import com.riversoft.weixin.common.request.ImageRequest;
import com.riversoft.weixin.common.request.TextRequest;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppXmlMessages {
    private static Logger logger = LoggerFactory.getLogger(AppXmlMessages.class);

    public static XmlMessageHeader fromXml(String xml) {
        try {
            XmlMessageHeader xmlRequest = (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, XmlMessageHeader.class);
            switch (xmlRequest.getMsgType()) {
                case text: {
                    return (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, TextRequest.class);
                }
                case image: {
                    return (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, ImageRequest.class);
                }
                case event: {
                    return AppXmlMessages.toEvent(xml);
                }
            }
            logger.warn("xml to bean failed, unknown message type {}.", (Object)xmlRequest.getMsgType());
            throw new WxRuntimeException(999, "xml to bean failed, unknown message type " + xmlRequest.getMsgType());
        }
        catch (IOException e) {
            logger.error("xml to message request failed", (Throwable)e);
            throw new WxRuntimeException(999, "xml to message request failed," + e.getMessage());
        }
    }

    private static EventRequest toEvent(String xml) {
        try {
            EventRequest eventRequest = (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, EventRequest.class);
            switch (eventRequest.getEventType()) {
                case user_enter_tempsession: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, UserEnterSession.class);
                }
            }
            logger.warn("xml to event, unknown event type {}.", (Object)eventRequest.getEventType());
            throw new WxRuntimeException(999, "xml to bean event, unknown event type " + eventRequest.getEventType());
        }
        catch (IOException e) {
            logger.error("xml to event failed", (Throwable)e);
            throw new WxRuntimeException(999, "xml to event failed," + e.getMessage());
        }
    }
}

