/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.app.care;

import com.riversoft.weixin.app.AppWxClientFactory;
import com.riversoft.weixin.app.base.AppSetting;
import com.riversoft.weixin.app.base.WxEndpoint;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.message.Media;
import com.riversoft.weixin.common.message.Text;
import com.riversoft.weixin.common.util.JsonMapper;
import java.util.HashMap;
import java.util.Map;

public class CareMessages {
    private WxClient wxClient;

    public static CareMessages defaultCareMessages() {
        return CareMessages.with(AppSetting.defaultSettings());
    }

    public static CareMessages with(AppSetting appSetting) {
        CareMessages messages = new CareMessages();
        messages.setWxClient(AppWxClientFactory.getInstance().with(appSetting));
        return messages;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void text(String openId, String text) {
        Map<String, Object> request = this.initMessage(openId, "text");
        request.put("text", new Text(text));
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    public void image(String openId, String image) {
        Map<String, Object> request = this.initMessage(openId, "image");
        request.put("image", new Media(image));
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    private Map<String, Object> initMessage(String openId, String msgType) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("msgtype", msgType);
        request.put("touser", openId);
        return request;
    }
}

